/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.test;

import io.micronaut.context.annotation.Property;
import io.micronaut.core.annotation.Internal;
import io.micronaut.test.context.TestContext;
import io.micronaut.test.context.TestExecutionListener;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.sync.SynchronousFromReactiveTransactionManager;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
final class DefaultTestSingleTransactionExecutionListener
implements TestExecutionListener {
    private final SynchronousTransactionManager<Object> transactionManager;
    private TransactionStatus<Object> tx;
    private final AtomicInteger counter = new AtomicInteger();
    private final AtomicInteger setupCounter = new AtomicInteger();
    private final boolean rollback;

    DefaultTestSingleTransactionExecutionListener(SynchronousTransactionManager<Object> transactionManager, @Property(name="micronaut.test.rollback", defaultValue="true") boolean rollback) {
        if (transactionManager instanceof SynchronousFromReactiveTransactionManager) {
            throw new IllegalStateException("Transaction mode is not supported when the synchronous transaction manager is created using Reactive transaction manager!");
        }
        this.transactionManager = transactionManager;
        this.rollback = rollback;
    }

    public void beforeSetupTest(TestContext testContext) {
        this.beforeTestExecution(testContext);
    }

    public void afterSetupTest(TestContext testContext) {
        this.setupCounter.getAndIncrement();
    }

    public void beforeCleanupTest(TestContext testContext) {
        this.beforeTestExecution(testContext);
    }

    public void afterCleanupTest(TestContext testContext) {
        this.afterTestExecution(false);
    }

    public void afterTestExecution(TestContext testContext) {
        this.counter.addAndGet(-this.setupCounter.getAndSet(0));
        this.afterTestExecution(this.rollback);
    }

    public void beforeTestExecution(TestContext testContext) {
        if (this.counter.getAndIncrement() == 0) {
            this.tx = this.transactionManager.getTransaction(TransactionDefinition.DEFAULT);
        }
    }

    private void afterTestExecution(boolean rollback) {
        if (this.counter.decrementAndGet() == 0) {
            if (rollback) {
                this.transactionManager.rollback(this.tx);
            } else {
                this.transactionManager.commit(this.tx);
            }
        }
    }
}

