/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.aop.InterceptedProxy;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.support.ResourceTransactionManager;
import io.micronaut.transaction.support.SynchronousTransactionState;
import io.micronaut.transaction.support.TransactionSynchronization;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class TransactionSynchronizationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionSynchronizationUtils.class);

    public static boolean sameResourceFactory(ResourceTransactionManager tm, Object resourceFactory) {
        return TransactionSynchronizationUtils.unwrapResourceIfNecessary(tm.getResourceFactory()).equals(TransactionSynchronizationUtils.unwrapResourceIfNecessary(resourceFactory));
    }

    static Object unwrapResourceIfNecessary(Object resource) {
        Objects.requireNonNull(resource, "Resource must not be null");
        Object resourceRef = resource;
        if (resourceRef instanceof InterceptedProxy) {
            resourceRef = ((InterceptedProxy)resourceRef).interceptedTarget();
        }
        return resourceRef;
    }

    public static void triggerFlush(SynchronousTransactionState state) {
        for (TransactionSynchronization synchronization : state.getSynchronizations()) {
            synchronization.flush();
        }
    }

    public static void triggerBeforeCommit(SynchronousTransactionState state, boolean readOnly) {
        for (TransactionSynchronization synchronization : state.getSynchronizations()) {
            synchronization.beforeCommit(readOnly);
        }
    }

    public static void triggerBeforeCompletion(SynchronousTransactionState state) {
        for (TransactionSynchronization synchronization : state.getSynchronizations()) {
            try {
                synchronization.beforeCompletion();
            }
            catch (Throwable tsex) {
                LOG.error("TransactionSynchronization.beforeCompletion threw exception", tsex);
            }
        }
    }

    public static void triggerAfterCommit(SynchronousTransactionState state) {
        TransactionSynchronizationUtils.invokeAfterCommit(state.getSynchronizations());
    }

    public static void invokeAfterCommit(@Nullable List<TransactionSynchronization> synchronizations) {
        if (synchronizations != null) {
            for (TransactionSynchronization synchronization : synchronizations) {
                synchronization.afterCommit();
            }
        }
    }

    public static void triggerAfterCompletion(SynchronousTransactionState state, @NonNull TransactionSynchronization.Status completionStatus) {
        List<TransactionSynchronization> synchronizations = state.getSynchronizations();
        TransactionSynchronizationUtils.invokeAfterCompletion(synchronizations, completionStatus);
    }

    public static void invokeAfterCompletion(@Nullable List<TransactionSynchronization> synchronizations, @NonNull TransactionSynchronization.Status completionStatus) {
        if (synchronizations != null) {
            for (TransactionSynchronization synchronization : synchronizations) {
                try {
                    synchronization.afterCompletion(completionStatus);
                }
                catch (Throwable tsex) {
                    LOG.error("TransactionSynchronization.afterCompletion threw exception", tsex);
                }
            }
        }
    }
}

