/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.support;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.support.DefaultSynchronousTransactionState;
import io.micronaut.transaction.support.ResourceHolder;
import io.micronaut.transaction.support.SynchronousTransactionState;
import io.micronaut.transaction.support.TransactionSynchronization;
import io.micronaut.transaction.support.TransactionSynchronizationUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransactionSynchronizationManager {
    public static final Object DEFAULT_STATE_KEY = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(TransactionSynchronizationManager.class);
    private static final ThreadLocal<MutableTransactionSynchronizationState> STATE = new ThreadLocal<MutableTransactionSynchronizationState>(){

        public String toString() {
            return "The state";
        }
    };

    @NonNull
    private static MutableTransactionSynchronizationState getOrCreateInternalState() {
        MutableTransactionSynchronizationState mutableState = STATE.get();
        if (mutableState == null) {
            mutableState = new MutableTransactionSynchronizationState();
            STATE.set(mutableState);
        }
        return mutableState;
    }

    @NonNull
    private static MutableTransactionSynchronizationState getInternalState() {
        MutableTransactionSynchronizationState mutableState = STATE.get();
        if (mutableState == null) {
            mutableState = new MutableTransactionSynchronizationState();
        }
        return mutableState;
    }

    private static void removeStateIfEmpty() {
        MutableTransactionSynchronizationState mutableState = STATE.get();
        if (mutableState != null && mutableState.states.isEmpty() && mutableState.resources.isEmpty()) {
            STATE.remove();
        }
    }

    public static Map<Object, Object> getResourceMap() {
        return Collections.unmodifiableMap(TransactionSynchronizationManager.getInternalState().getResources());
    }

    public static boolean hasResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getInternalState().getResources(), actualKey);
        return value != null;
    }

    @Nullable
    public static Object getResource(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getInternalState().getResources(), actualKey);
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Retrieved value [" + value + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @Nullable
    private static <T> T doGetResource(@Nullable Map<Object, T> map, @NonNull Object actualKey) {
        if (map == null) {
            return null;
        }
        T value = map.get(actualKey);
        if (value instanceof ResourceHolder && ((ResourceHolder)value).isVoid()) {
            map.remove(actualKey);
            TransactionSynchronizationManager.removeStateIfEmpty();
            value = null;
        }
        return value;
    }

    public static void bindResource(Object key, Object value) throws IllegalStateException {
        TransactionSynchronizationManager.bindResource(TransactionSynchronizationManager.getOrCreateInternalState().getResources(), key, value);
    }

    private static <T> void bindResource(Map<Object, T> map, Object key, T value) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Objects.requireNonNull(value, "Value must not be null");
        T oldValue = map.put(actualKey, value);
        if (oldValue instanceof ResourceHolder && ((ResourceHolder)oldValue).isVoid()) {
            oldValue = null;
        }
        if (oldValue != null) {
            throw new IllegalStateException("Already value [" + oldValue + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Bound value [" + value + "] for key [" + actualKey + "] to thread [" + Thread.currentThread().getName() + "]");
        }
    }

    public static Object unbindResource(Object key) throws IllegalStateException {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        Object value = TransactionSynchronizationManager.doUnbindResource(TransactionSynchronizationManager.getInternalState().getResources(), actualKey);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @Nullable
    public static Object unbindResourceIfPossible(Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        return TransactionSynchronizationManager.doUnbindResource(TransactionSynchronizationManager.getInternalState().getResources(), actualKey);
    }

    @Nullable
    private static <T> T doUnbindResource(@Nullable Map<Object, T> map, @NonNull Object actualKey) {
        Object value = map == null ? null : map.remove(actualKey);
        TransactionSynchronizationManager.removeStateIfEmpty();
        if (value instanceof ResourceHolder && ((ResourceHolder)value).isVoid()) {
            value = null;
        }
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Removed value [" + value + "] for key [" + actualKey + "] from thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    public static void bindSynchronousTransactionState(@NonNull Object key, @NonNull SynchronousTransactionState state) {
        TransactionSynchronizationManager.bindResource(TransactionSynchronizationManager.getOrCreateInternalState().getStates(), key, state);
    }

    public static SynchronousTransactionState unbindSynchronousTransactionState(Object key) throws IllegalStateException {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        SynchronousTransactionState value = TransactionSynchronizationManager.doUnbindResource(TransactionSynchronizationManager.getInternalState().getStates(), actualKey);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @Nullable
    public static SynchronousTransactionState getSynchronousTransactionState(@NonNull Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        SynchronousTransactionState value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getInternalState().getStates(), actualKey);
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Retrieved value [" + value + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @NonNull
    public static SynchronousTransactionState getRequiredSynchronousTransactionState(@NonNull Object key) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        SynchronousTransactionState value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getInternalState().getStates(), actualKey);
        if (value == null) {
            throw new IllegalStateException("No value for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Retrieved value [" + value + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        return value;
    }

    @NonNull
    public static SynchronousTransactionState getSynchronousTransactionStateOrCreate(@NonNull Object key, Supplier<SynchronousTransactionState> creator) {
        Object actualKey = TransactionSynchronizationUtils.unwrapResourceIfNecessary(key);
        SynchronousTransactionState value = TransactionSynchronizationManager.doGetResource(TransactionSynchronizationManager.getOrCreateInternalState().getStates(), actualKey);
        if (value != null && LOG.isTraceEnabled()) {
            LOG.trace("Retrieved value [" + value + "] for key [" + actualKey + "] bound to thread [" + Thread.currentThread().getName() + "]");
        }
        if (value == null) {
            value = creator.get();
            TransactionSynchronizationManager.bindSynchronousTransactionState(actualKey, value);
        }
        return value;
    }

    @Nullable
    private static SynchronousTransactionState findDefaultState() {
        Map<Object, SynchronousTransactionState> states = TransactionSynchronizationManager.getInternalState().getStates();
        if (states.isEmpty()) {
            return null;
        }
        if (states.size() == 1) {
            return states.values().iterator().next();
        }
        SynchronousTransactionState synchronousTransactionState = states.get(DEFAULT_STATE_KEY);
        if (synchronousTransactionState != null) {
            return synchronousTransactionState;
        }
        throw new IllegalStateException("Multiple synchronous transaction states found!");
    }

    @NonNull
    private static SynchronousTransactionState getOrEmptyDefaultState() {
        SynchronousTransactionState synchronousTransactionState = TransactionSynchronizationManager.findDefaultState();
        return synchronousTransactionState == null ? new DefaultSynchronousTransactionState() : synchronousTransactionState;
    }

    @NonNull
    private static SynchronousTransactionState getRequiredDefaultState() {
        SynchronousTransactionState synchronousTransactionState = TransactionSynchronizationManager.findDefaultState();
        if (synchronousTransactionState == null) {
            throw new IllegalStateException("Cannot find default synchronous transaction state!");
        }
        return synchronousTransactionState;
    }

    @Deprecated
    public static boolean isSynchronizationActive() {
        return TransactionSynchronizationManager.getOrEmptyDefaultState().isSynchronizationActive();
    }

    @Deprecated
    public static void initSynchronization() throws IllegalStateException {
        TransactionSynchronizationManager.getRequiredDefaultState().initSynchronization();
    }

    @Deprecated
    public static void registerSynchronization(TransactionSynchronization synchronization) throws IllegalStateException {
        TransactionSynchronizationManager.getRequiredDefaultState().registerSynchronization(synchronization);
    }

    @Deprecated
    public static List<TransactionSynchronization> getSynchronizations() throws IllegalStateException {
        return TransactionSynchronizationManager.getOrEmptyDefaultState().getSynchronizations();
    }

    @Deprecated
    public static void clearSynchronization() throws IllegalStateException {
        TransactionSynchronizationManager.getRequiredDefaultState().clearSynchronization();
    }

    @Deprecated
    public static void setCurrentTransactionName(@Nullable String name) {
        TransactionSynchronizationManager.getRequiredDefaultState().setTransactionName(name);
    }

    @Deprecated
    @Nullable
    public static String getCurrentTransactionName() {
        return TransactionSynchronizationManager.getOrEmptyDefaultState().getTransactionName();
    }

    @Deprecated
    public static void setCurrentTransactionReadOnly(boolean readOnly) {
        TransactionSynchronizationManager.getRequiredDefaultState().setTransactionReadOnly(readOnly);
    }

    @Deprecated
    public static boolean isCurrentTransactionReadOnly() {
        return TransactionSynchronizationManager.getOrEmptyDefaultState().isTransactionReadOnly();
    }

    @Deprecated
    public static void setCurrentTransactionIsolationLevel(@Nullable TransactionDefinition.Isolation isolationLevel) {
        TransactionSynchronizationManager.getRequiredDefaultState().setTransactionIsolationLevel(isolationLevel);
    }

    @Nullable
    @Deprecated
    public static TransactionDefinition.Isolation getCurrentTransactionIsolationLevel() {
        return TransactionSynchronizationManager.getOrEmptyDefaultState().getTransactionIsolationLevel();
    }

    @Deprecated
    public static void setActualTransactionActive(boolean active) {
        TransactionSynchronizationManager.getRequiredDefaultState().setActualTransactionActive(active);
    }

    @Deprecated
    public static boolean isActualTransactionActive() {
        return TransactionSynchronizationManager.getOrEmptyDefaultState().isActualTransactionActive();
    }

    @Deprecated
    public static void clear() {
        TransactionSynchronizationManager.getRequiredDefaultState().clear();
    }

    @Internal
    @Nullable
    public static TransactionSynchronizationState getState() {
        return STATE.get();
    }

    @Internal
    @NonNull
    public static TransactionSynchronizationState getOrCreateState() {
        return TransactionSynchronizationManager.getOrCreateInternalState();
    }

    @Internal
    public static void setState(@Nullable TransactionSynchronizationState state) {
        if (state == null) {
            STATE.remove();
            return;
        }
        if (!(state instanceof MutableTransactionSynchronizationState)) {
            throw new IllegalStateException("Unknown state: " + state);
        }
        MutableTransactionSynchronizationState mutableState = (MutableTransactionSynchronizationState)state;
        STATE.set(mutableState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public static <T> T withState(@Nullable TransactionSynchronizationState state, Supplier<T> supplier) {
        if (state == null) {
            return supplier.get();
        }
        TransactionSynchronizationState previousState = TransactionSynchronizationManager.getState();
        try {
            TransactionSynchronizationManager.setState(state);
            T t = supplier.get();
            return t;
        }
        finally {
            TransactionSynchronizationManager.setState(previousState);
        }
    }

    @Internal
    public static <T> Supplier<T> decorateToPropagateState(Supplier<T> supplier) {
        TransactionSynchronizationState state = STATE.get();
        if (state == null) {
            return supplier;
        }
        return () -> TransactionSynchronizationManager.withState(state, supplier);
    }

    private static final class MutableTransactionSynchronizationState
    implements TransactionSynchronizationState {
        private final Map<Object, Object> resources = new HashMap<Object, Object>(2, 1.0f);
        private final Map<Object, SynchronousTransactionState> states = new HashMap<Object, SynchronousTransactionState>(2, 1.0f);

        private MutableTransactionSynchronizationState() {
        }

        @NonNull
        public synchronized Map<Object, Object> getResources() {
            return this.resources;
        }

        @NonNull
        public synchronized Map<Object, SynchronousTransactionState> getStates() {
            return this.states;
        }
    }

    @Internal
    public static interface TransactionSynchronizationState {
    }
}

