/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.interceptor;

import io.micronaut.aop.InterceptPhase;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.annotation.TransactionalAdvice;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.exceptions.TransactionSystemException;
import io.micronaut.transaction.interceptor.DefaultTransactionAttribute;
import io.micronaut.transaction.interceptor.TransactionAttribute;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TransactionalInterceptor
implements MethodInterceptor<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalInterceptor.class);
    private static final ThreadLocal<TransactionInfo> TRANSACTION_INFO_HOLDER = new ThreadLocal<TransactionInfo>(){

        public String toString() {
            return "Current aspect-driven transaction";
        }
    };
    private final Map<ExecutableMethod, TransactionInvocation> transactionInvocationMap = new ConcurrentHashMap<ExecutableMethod, TransactionInvocation>(30);
    @NonNull
    private final BeanLocator beanLocator;

    public TransactionalInterceptor(@NonNull BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public int getOrder() {
        return InterceptPhase.TRANSACTION.getPosition();
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
        try {
            boolean isReactive = interceptedMethod.resultType() == InterceptedMethod.ResultType.PUBLISHER;
            boolean isAsync = interceptedMethod.resultType() == InterceptedMethod.ResultType.COMPLETION_STAGE;
            TransactionInvocation transactionInvocation = this.transactionInvocationMap.computeIfAbsent(context.getExecutableMethod(), executableMethod -> {
                String qualifier = executableMethod.stringValue(TransactionalAdvice.class).orElse(null);
                if (isReactive || isAsync) {
                    ReactiveTransactionOperations reactiveTransactionOperations = this.beanLocator.findBean(ReactiveTransactionOperations.class, qualifier != null ? Qualifiers.byName((String)qualifier) : null).orElse(null);
                    if (isReactive && reactiveTransactionOperations == null) {
                        throw new ConfigurationException("No reactive transaction management has been configured. Ensure you have correctly configured a reactive capable transaction manager");
                    }
                    TransactionAttribute transactionAttribute = this.resolveTransactionDefinition((ExecutableMethod<Object, Object>)executableMethod);
                    return new TransactionInvocation(null, reactiveTransactionOperations, transactionAttribute);
                }
                SynchronousTransactionManager transactionManager = (SynchronousTransactionManager)this.beanLocator.getBean(SynchronousTransactionManager.class, qualifier != null ? Qualifiers.byName((String)qualifier) : null);
                TransactionAttribute transactionAttribute = this.resolveTransactionDefinition((ExecutableMethod<Object, Object>)executableMethod);
                return new TransactionInvocation(transactionManager, null, transactionAttribute);
            });
            TransactionAttribute definition = transactionInvocation.definition;
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    return interceptedMethod.handleResult(transactionInvocation.reactiveTransactionOperations.withTransaction(definition, status -> {
                        context.setAttribute((CharSequence)"io.micronaut.tx.STATUS", (Object)status);
                        context.setAttribute((CharSequence)"io.micronaut.tx.ATTRIBUTE", (Object)definition);
                        return (Publisher)Publishers.convertPublisher((Object)context.proceed(), Publisher.class);
                    }));
                }
                case COMPLETION_STAGE: {
                    if (transactionInvocation.reactiveTransactionOperations != null) {
                        return interceptedMethod.handleResult(interceptedMethod.interceptResult());
                    }
                    throw new ConfigurationException("Async return type doesn't support transactional execution.");
                }
                case SYNCHRONOUS: {
                    Object retVal;
                    SynchronousTransactionManager transactionManager = transactionInvocation.transactionManager;
                    TransactionInfo transactionInfo = this.createTransactionIfNecessary(transactionManager, definition, (ExecutableMethod<Object, Object>)context.getExecutableMethod());
                    try {
                        retVal = context.proceed();
                    }
                    catch (Throwable ex) {
                        this.completeTransactionAfterThrowing(transactionInfo, ex);
                        throw ex;
                    }
                    finally {
                        this.cleanupTransactionInfo(transactionInfo);
                    }
                    this.commitTransactionAfterReturning(transactionInfo);
                    return retVal;
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    @Nullable
    private static TransactionInfo currentTransactionInfo() throws NoTransactionException {
        return TRANSACTION_INFO_HOLDER.get();
    }

    public static <T> TransactionStatus<T> currentTransactionStatus() throws NoTransactionException {
        TransactionInfo info = TransactionalInterceptor.currentTransactionInfo();
        if (info == null) {
            throw new NoTransactionException("No transaction aspect-managed TransactionStatus in scope");
        }
        return info.transactionStatus;
    }

    protected TransactionInfo createTransactionIfNecessary(@NonNull SynchronousTransactionManager<?> tm, @NonNull TransactionAttribute txAttr, ExecutableMethod<Object, Object> executableMethod) {
        TransactionStatus<?> status = tm.getTransaction(txAttr);
        return this.prepareTransactionInfo(tm, txAttr, executableMethod, status);
    }

    protected TransactionInfo prepareTransactionInfo(@NonNull SynchronousTransactionManager tm, @NonNull TransactionAttribute txAttr, ExecutableMethod<Object, Object> executableMethod, @NonNull TransactionStatus status) {
        TransactionInfo txInfo = new TransactionInfo(tm, txAttr, executableMethod);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting transaction for [" + txInfo.getJoinpointIdentification() + "]");
        }
        txInfo.newTransactionStatus(status);
        txInfo.bindToThread();
        return txInfo;
    }

    protected void commitTransactionAfterReturning(@NonNull TransactionInfo txInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Completing transaction for [" + txInfo.getJoinpointIdentification() + "]");
        }
        txInfo.getTransactionManager().commit(txInfo.getTransactionStatus());
    }

    protected void completeTransactionAfterThrowing(@NonNull TransactionInfo txInfo, Throwable ex) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Completing transaction for [" + txInfo.getJoinpointIdentification() + "] after exception: " + ex);
        }
        if (txInfo.transactionAttribute.rollbackOn(ex)) {
            try {
                txInfo.getTransactionManager().rollback(txInfo.getTransactionStatus());
            }
            catch (TransactionSystemException ex2) {
                LOG.error("Application exception overridden by rollback exception", ex);
                ex2.initApplicationException(ex);
                throw ex2;
            }
            catch (Error | RuntimeException ex2) {
                LOG.error("Application exception overridden by rollback exception", ex);
                throw ex2;
            }
        }
        try {
            txInfo.getTransactionManager().commit(txInfo.getTransactionStatus());
        }
        catch (TransactionSystemException ex2) {
            LOG.error("Application exception overridden by commit exception", ex);
            ex2.initApplicationException(ex);
            throw ex2;
        }
        catch (Error | RuntimeException ex2) {
            LOG.error("Application exception overridden by commit exception", ex);
            throw ex2;
        }
    }

    protected void cleanupTransactionInfo(@Nullable TransactionInfo txInfo) {
        if (txInfo != null) {
            txInfo.restoreThreadLocalStatus();
        }
    }

    protected TransactionAttribute resolveTransactionDefinition(ExecutableMethod<Object, Object> executableMethod) {
        AnnotationValue annotation = executableMethod.getAnnotation(TransactionalAdvice.class);
        if (annotation == null) {
            throw new IllegalStateException("No declared @Transactional annotation present");
        }
        DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
        attribute.setName(executableMethod.getDeclaringType().getSimpleName() + "." + executableMethod.getMethodName());
        attribute.setReadOnly(annotation.isTrue("readOnly"));
        annotation.intValue("timeout").ifPresent(value -> attribute.setTimeout(Duration.ofSeconds(value)));
        Class[] noRollbackFors = annotation.classValues("noRollbackFor");
        attribute.setNoRollbackFor(noRollbackFors);
        annotation.enumValue("propagation", TransactionDefinition.Propagation.class).ifPresent(attribute::setPropagationBehavior);
        annotation.enumValue("isolation", TransactionDefinition.Isolation.class).ifPresent(attribute::setIsolationLevel);
        return attribute;
    }

    protected static final class TransactionInfo<T> {
        private final SynchronousTransactionManager<T> transactionManager;
        private final TransactionAttribute transactionAttribute;
        private final ExecutableMethod<Object, Object> executableMethod;
        private TransactionStatus<T> transactionStatus;
        private TransactionInfo<T> oldTransactionInfo;

        protected TransactionInfo(@NonNull SynchronousTransactionManager<T> transactionManager, @NonNull TransactionAttribute transactionAttribute, @NonNull ExecutableMethod<Object, Object> executableMethod) {
            this.transactionManager = transactionManager;
            this.transactionAttribute = transactionAttribute;
            this.executableMethod = executableMethod;
        }

        @NonNull
        public SynchronousTransactionManager<T> getTransactionManager() {
            return this.transactionManager;
        }

        @NonNull
        public String getJoinpointIdentification() {
            return this.executableMethod.getDeclaringType().getName() + " . " + this.executableMethod.toString();
        }

        public void newTransactionStatus(@NonNull TransactionStatus<T> status) {
            this.transactionStatus = status;
        }

        @NonNull
        public TransactionStatus<T> getTransactionStatus() {
            if (this.transactionStatus == null) {
                throw new IllegalStateException("Transaction status not yet initialized");
            }
            return this.transactionStatus;
        }

        public boolean hasTransaction() {
            return true;
        }

        private void bindToThread() {
            this.oldTransactionInfo = (TransactionInfo)TRANSACTION_INFO_HOLDER.get();
            TRANSACTION_INFO_HOLDER.set(this);
        }

        private void restoreThreadLocalStatus() {
            TRANSACTION_INFO_HOLDER.set(this.oldTransactionInfo);
        }

        public String toString() {
            return this.transactionAttribute.toString();
        }
    }

    private static final class TransactionInvocation<C> {
        @Nullable
        final SynchronousTransactionManager<C> transactionManager;
        @Nullable
        final ReactiveTransactionOperations<C> reactiveTransactionOperations;
        final TransactionAttribute definition;

        TransactionInvocation(SynchronousTransactionManager<C> transactionManager, ReactiveTransactionOperations<C> reactiveTransactionOperations, TransactionAttribute definition) {
            this.transactionManager = transactionManager;
            this.reactiveTransactionOperations = reactiveTransactionOperations;
            this.definition = definition;
        }

        boolean isReactive() {
            return this.reactiveTransactionOperations != null;
        }
    }
}

