/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.jdbc;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.jdbc.DataSourceUtils;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import io.micronaut.transaction.jdbc.exceptions.CannotGetJdbcConnectionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Singleton;
import javax.sql.DataSource;

@Singleton
public final class TransactionalConnectionInterceptor
implements MethodInterceptor<Connection, Object> {
    private final DataSource dataSource;
    private boolean closed;

    @Internal
    TransactionalConnectionInterceptor(BeanContext beanContext, Qualifier<DataSource> qualifier) {
        DataSource dataSource = (DataSource)beanContext.getBean(DataSource.class, qualifier);
        if (dataSource instanceof DelegatingDataSource) {
            dataSource = ((DelegatingDataSource)dataSource).getTargetDataSource();
        }
        this.dataSource = dataSource;
    }

    public Object intercept(MethodInvocationContext<Connection, Object> context) {
        Connection connection;
        try {
            connection = DataSourceUtils.getConnection(this.dataSource, false);
        }
        catch (CannotGetJdbcConnectionException e) {
            throw new NoTransactionException("No current transaction present. Consider declaring @Transactional on the surrounding method", e);
        }
        ExecutableMethod method = context.getExecutableMethod();
        if (method.getName().equals("close")) {
            try {
                DataSourceUtils.doReleaseConnection(connection, this.dataSource);
            }
            catch (SQLException e) {
                throw new CannotGetJdbcConnectionException("Failed to release connection: " + e.getMessage(), e);
            }
            return null;
        }
        return method.invoke((Object)connection, context.getParameterValues());
    }
}

