/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.jdbc;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Singleton;
import javax.sql.DataSource;

@Singleton
@Requires(missingClasses={"org.springframework.jdbc.datasource.DataSourceTransactionManager"})
public class TransactionAwareDataSource
implements BeanCreatedEventListener<DataSource> {
    private final BeanLocator beanLocator;
    private Connection transactionAwareConnection;
    private String qualifier;

    public TransactionAwareDataSource(BeanLocator beanLocator) {
        this.beanLocator = beanLocator;
    }

    public DataSource onCreated(BeanCreatedEvent<DataSource> event) {
        BeanIdentifier beanIdentifier = event.getBeanIdentifier();
        String name = beanIdentifier.getName();
        if (name.equalsIgnoreCase("primary")) {
            name = "default";
        }
        this.qualifier = name;
        return new DataSourceProxy((DataSource)event.getBean());
    }

    private Connection getTransactionAwareConnection() {
        if (this.transactionAwareConnection == null) {
            this.transactionAwareConnection = (Connection)this.beanLocator.getBean(Connection.class, Qualifiers.byName((String)this.qualifier));
        }
        return this.transactionAwareConnection;
    }

    private final class DataSourceProxy
    extends DelegatingDataSource {
        DataSourceProxy(DataSource targetDataSource) {
            super(targetDataSource);
        }

        @Override
        public Connection getConnection() throws SQLException {
            return TransactionAwareDataSource.this.getTransactionAwareConnection();
        }
    }
}

