/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.transaction.jdbc;

import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.transaction.exceptions.NoTransactionException;
import io.micronaut.transaction.jdbc.DataSourceUtils;
import io.micronaut.transaction.jdbc.exceptions.CannotGetJdbcConnectionException;
import java.sql.Connection;
import javax.inject.Singleton;
import javax.sql.DataSource;

@Singleton
public final class TransactionalConnectionInterceptor
implements MethodInterceptor<Connection, Object> {
    private final DataSource dataSource;

    @Internal
    TransactionalConnectionInterceptor(BeanContext beanContext, Qualifier<DataSource> qualifier) {
        this.dataSource = (DataSource)beanContext.getBean(DataSource.class, qualifier);
    }

    public Object intercept(MethodInvocationContext<Connection, Object> context) {
        Connection connection;
        try {
            connection = DataSourceUtils.getConnection(this.dataSource, false);
        }
        catch (CannotGetJdbcConnectionException e) {
            throw new NoTransactionException("No current transaction present. Consider declaring @Transactional on the surrounding method", e);
        }
        return context.getExecutableMethod().invoke((Object)connection, context.getParameterValues());
    }
}

