/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.runtime;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.spring.runtime.SortDelegate;
import java.util.Optional;
import org.springframework.data.domain.Pageable;

@Internal
class PageableDelegate
implements io.micronaut.data.model.Pageable {
    private final Pageable target;

    PageableDelegate(Pageable target) {
        this.target = target;
    }

    public int getNumber() {
        return this.target.getPageNumber();
    }

    public int getSize() {
        return this.target.getPageSize();
    }

    public Pageable.Mode getMode() {
        return Pageable.Mode.OFFSET;
    }

    public Optional<Pageable.Cursor> cursor() {
        return Optional.empty();
    }

    public boolean requestTotal() {
        return true;
    }

    public long getOffset() {
        return this.target.getOffset();
    }

    @NonNull
    public Sort getSort() {
        return new SortDelegate(this.target.getSort());
    }

    public io.micronaut.data.model.Pageable withTotal() {
        return this;
    }

    public io.micronaut.data.model.Pageable withoutTotal() {
        throw new IllegalStateException("Disabling requesting total is not supported for current Pageable");
    }
}

