/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.runtime.http;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.data.runtime.config.DataConfiguration;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

@Requires(classes={RequestArgumentBinder.class, Pageable.class})
@Singleton
public class SpringPageableRequestArgumentBinder
implements TypedRequestArgumentBinder<Pageable> {
    public static final Argument<Pageable> TYPE = Argument.of(Pageable.class);
    private final DataConfiguration.PageableConfiguration configuration;
    private final Function<String, Sort.Order> sortMapper;

    protected SpringPageableRequestArgumentBinder(DataConfiguration.PageableConfiguration configuration) {
        this.configuration = configuration;
        this.sortMapper = s -> {
            String[] tokens = configuration.getSortDelimiterPattern().split((CharSequence)s);
            if (tokens.length == 1) {
                return new Sort.Order(Sort.Direction.ASC, tokens[0]);
            }
            try {
                Sort.Direction direction = Sort.Direction.valueOf((String)tokens[1].toUpperCase(Locale.ENGLISH));
                return new Sort.Order(direction, tokens[0]);
            }
            catch (IllegalArgumentException e) {
                return new Sort.Order(Sort.Direction.ASC, tokens[0]);
            }
        };
    }

    public Argument<Pageable> argumentType() {
        return TYPE;
    }

    public ArgumentBinder.BindingResult<Pageable> bind(ArgumentConversionContext<Pageable> context, HttpRequest<?> source) {
        Sort sort;
        HttpParameters parameters = source.getParameters();
        int page = Math.max(parameters.getFirst((CharSequence)this.configuration.getPageParameterName(), Integer.class).orElse(0), 0);
        int configuredMaxSize = this.configuration.getMaxPageSize();
        int defaultSize = this.configuration.getDefaultPageSize();
        int size = Math.min(parameters.getFirst((CharSequence)this.configuration.getSizeParameterName(), Integer.class).orElse(defaultSize), configuredMaxSize);
        String sortParameterName = this.configuration.getSortParameterName();
        boolean hasSort = parameters.contains(sortParameterName);
        if (hasSort) {
            List sortParams = parameters.getAll((CharSequence)sortParameterName);
            List orders = sortParams.stream().map(this.sortMapper).collect(Collectors.toList());
            sort = Sort.by(orders);
        } else {
            sort = Sort.unsorted();
        }
        Object pageable = size < 1 ? (page == 0 && configuredMaxSize < 1 && sort.isUnsorted() ? Pageable.unpaged() : PageRequest.of((int)page, (int)defaultSize, (Sort)sort)) : PageRequest.of((int)page, (int)size, (Sort)sort);
        return () -> SpringPageableRequestArgumentBinder.lambda$bind$1((Pageable)pageable);
    }

    private static /* synthetic */ Optional lambda$bind$1(Pageable pageable) {
        return Optional.of(pageable);
    }
}

