/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.runtime.spring;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.jdbc.runtime.spring.SpringJdbcTransactionOperations;
import io.micronaut.transaction.TransactionCallback;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.TransactionStatus;
import io.micronaut.transaction.exceptions.TransactionException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.time.Duration;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

@Requires(classes={HibernateTransactionManager.class})
@EachBean(value=HibernateTransactionManager.class)
@Internal
@Replaces(value=SpringJdbcTransactionOperations.class)
public class SpringHibernateTransactionOperations
implements TransactionOperations<Connection> {
    private final TransactionTemplate writeTransactionTemplate;
    private final TransactionTemplate readTransactionTemplate;
    private final SessionFactory sessionFactory;
    private final HibernateTransactionManager transactionManager;

    protected SpringHibernateTransactionOperations(HibernateTransactionManager hibernateTransactionManager) {
        this.sessionFactory = hibernateTransactionManager.getSessionFactory();
        this.transactionManager = hibernateTransactionManager;
        this.writeTransactionTemplate = new TransactionTemplate((PlatformTransactionManager)hibernateTransactionManager);
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setReadOnly(true);
        this.readTransactionTemplate = new TransactionTemplate((PlatformTransactionManager)hibernateTransactionManager, (org.springframework.transaction.TransactionDefinition)transactionDefinition);
    }

    public <R> R executeRead(@NonNull TransactionCallback<Connection, R> callback) {
        ArgumentUtils.requireNonNull((String)"callback", callback);
        return (R)this.readTransactionTemplate.execute(status -> {
            try {
                return callback.call((TransactionStatus)new JpaTransactionStatus(status));
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "TransactionCallback threw undeclared checked exception");
            }
        });
    }

    public <R> R executeWrite(@NonNull TransactionCallback<Connection, R> callback) {
        ArgumentUtils.requireNonNull((String)"callback", callback);
        return (R)this.writeTransactionTemplate.execute(status -> {
            try {
                return callback.call((TransactionStatus)new JpaTransactionStatus(status));
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "TransactionCallback threw undeclared checked exception");
            }
        });
    }

    @NonNull
    public Connection getConnection() {
        SessionImplementor session = (SessionImplementor)this.sessionFactory.getCurrentSession();
        return session.connection();
    }

    public <R> R execute(@NonNull TransactionDefinition definition, @NonNull TransactionCallback<Connection, R> callback) {
        ArgumentUtils.requireNonNull((String)"callback", callback);
        ArgumentUtils.requireNonNull((String)"definition", (Object)definition);
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setReadOnly(definition.isReadOnly());
        def.setIsolationLevel(definition.getIsolationLevel().getCode());
        def.setPropagationBehavior(definition.getPropagationBehavior().ordinal());
        def.setName(definition.getName());
        Duration timeout = definition.getTimeout();
        if (!timeout.isNegative()) {
            def.setTimeout((int)timeout.getSeconds());
        }
        TransactionTemplate template = new TransactionTemplate((PlatformTransactionManager)this.transactionManager, (org.springframework.transaction.TransactionDefinition)def);
        return (R)template.execute(status -> {
            try {
                return callback.call((TransactionStatus)new JpaTransactionStatus(status));
            }
            catch (Error | RuntimeException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "TransactionCallback threw undeclared checked exception");
            }
        });
    }

    private final class JpaTransactionStatus
    implements TransactionStatus<Connection> {
        private final org.springframework.transaction.TransactionStatus springStatus;

        JpaTransactionStatus(org.springframework.transaction.TransactionStatus springStatus) {
            this.springStatus = springStatus;
        }

        public boolean isNewTransaction() {
            return this.springStatus.isNewTransaction();
        }

        public void setRollbackOnly() {
            this.springStatus.setRollbackOnly();
        }

        public boolean isRollbackOnly() {
            return this.springStatus.isRollbackOnly();
        }

        public boolean isCompleted() {
            return this.springStatus.isCompleted();
        }

        public boolean hasSavepoint() {
            return this.springStatus.hasSavepoint();
        }

        public void flush() {
            this.springStatus.flush();
        }

        @NonNull
        public Object getTransaction() {
            return this.springStatus;
        }

        @NonNull
        public Connection getConnection() {
            SessionImplementor session = (SessionImplementor)SpringHibernateTransactionOperations.this.sessionFactory.getCurrentSession();
            return session.connection();
        }

        public Object createSavepoint() throws TransactionException {
            return this.springStatus.createSavepoint();
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this.springStatus.rollbackToSavepoint(savepoint);
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
            this.springStatus.releaseSavepoint(savepoint);
        }
    }
}

