/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jpa.hibernate;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.support.DefaultConnectionStatus;
import io.micronaut.data.hibernate.connection.HibernateConnectionOperations;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Internal
@EachBean(value=SessionFactory.class)
@Replaces(value=HibernateConnectionOperations.class)
public final class SpringHibernateConnectionOperations
implements ConnectionOperations<Session> {
    private final SessionFactory sessionFactory;

    SpringHibernateConnectionOperations(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public Optional<ConnectionStatus<Session>> findConnectionStatus() {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        if (sessionHolder != null && sessionHolder.getEntityManager() != null) {
            return Optional.of(this.createStatus(sessionHolder.getSession()));
        }
        return Optional.empty();
    }

    public <R> R execute(ConnectionDefinition definition, Function<ConnectionStatus<Session>, R> callback) {
        return (R)new HibernateTemplate(this.sessionFactory).execute(session -> callback.apply((ConnectionStatus<Session>)this.createStatus(session)));
    }

    private DefaultConnectionStatus<Session> createStatus(Session session) {
        return new DefaultConnectionStatus((Object)session, ConnectionDefinition.DEFAULT, true);
    }
}

