/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.spring.jdbc;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.spring.jdbc.SpringJdbcTransactionManagerCondition;
import io.micronaut.data.spring.tx.AbstractSpringTransactionOperations;
import io.micronaut.transaction.exceptions.NoTransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jspecify.annotations.NonNull;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@EachBean(value=DataSourceTransactionManager.class)
@Internal
@Requires(classes={DataSourceTransactionManager.class}, condition=SpringJdbcTransactionManagerCondition.class)
public final class SpringJdbcTransactionOperations
extends AbstractSpringTransactionOperations {
    private final DataSource dataSource;

    SpringJdbcTransactionOperations(DataSourceTransactionManager transactionManager) {
        super((PlatformTransactionManager)transactionManager);
        this.dataSource = transactionManager.getDataSource();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public @NonNull Connection getConnection() {
        try {
            Connection connection = DataSourceUtils.doGetConnection((DataSource)this.dataSource);
            if (DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)this.dataSource)) {
                return connection;
            }
            connection.close();
            throw new NoTransactionException("No transaction declared. Define @Transactional on the surrounding method prior to calling getConnection()");
        }
        catch (SQLException e) {
            throw new DataAccessException("Error retrieving JDBC connection: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean hasConnection() {
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.dataSource);
        return conHolder != null && conHolder.getConnectionHandle() != null;
    }
}

