/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.query.internal;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.CursoredPageable;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.runtime.DefaultStoredDataOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public final class DefaultPreparedQuery<E, RT>
extends DefaultStoredDataOperation<RT>
implements DelegateStoredQuery<E, RT>,
PreparedQuery<E, RT> {
    private final Pageable pageable;
    private final StoredQuery<E, RT> storedQuery;
    private final String query;
    private final boolean dto;
    private final MethodInvocationContext<?, ?> context;
    private final ConversionService conversionService;
    private final @Nullable Limit limit;

    public DefaultPreparedQuery(MethodInvocationContext<?, ?> context, StoredQuery<E, RT> storedQuery, String finalQuery, @NonNull Pageable pageable, @NonNull Limit limit, boolean dtoProjection, ConversionService conversionService) {
        super(context);
        this.context = context;
        this.query = finalQuery;
        this.storedQuery = storedQuery;
        this.dto = dtoProjection;
        this.conversionService = conversionService;
        if (pageable.getMode() == Pageable.Mode.OFFSET && DefaultPreparedQuery.hasReturnTypeInRole("cursoredPage", CursoredPage.class, context, conversionService)) {
            if (pageable.getNumber() == 0) {
                pageable = CursoredPageable.from((int)pageable.getSize(), (Sort)pageable.getSort());
            } else {
                throw new IllegalArgumentException("Cursored page with the offset mode page request needs to start from the first page number: 0, but was: " + pageable.getNumber());
            }
        }
        this.pageable = pageable.withSort(storedQuery.getSort().orders(pageable.getOrderBy()));
        this.limit = Limit.UNLIMITED.equals((Object)limit) && !storedQuery.isCount() ? Limit.of((int)pageable.getSize(), (long)pageable.getOffset()) : limit;
    }

    public static boolean hasReturnTypeInRole(@NonNull String role, @NonNull Class<?> type, @NonNull MethodInvocationContext<?, ?> methodContext, @NonNull ConversionService conversionService) {
        return methodContext.stringValue(DataMethod.NAME, "returnTypeRole").filter(typeRole -> typeRole.equals(role)).map(ignore -> conversionService.canConvert(methodContext.getReturnType().getType(), type)).orElse(false);
    }

    public static <RT1> @NonNull Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Class<RT1> type, @NonNull MethodInvocationContext<?, ?> methodContext, @NonNull ConversionService conversionService) {
        return DefaultPreparedQuery.getParameterInRole(role, Argument.of(type), methodContext, conversionService);
    }

    public static <RT1> @NonNull Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Argument<RT1> type, @NonNull MethodInvocationContext<?, ?> methodContext, @NonNull ConversionService conversionService) {
        return methodContext.stringValue(DataMethod.NAME, role).flatMap(name -> {
            MutableArgumentValue arg = (MutableArgumentValue)methodContext.getParameters().get(name);
            if (arg == null) {
                return Optional.empty();
            }
            Object o = arg.getValue();
            if (o == null) {
                return Optional.empty();
            }
            if (type.isInstance(o)) {
                return Optional.of(o);
            }
            return conversionService.convert(o, ConversionContext.of((Argument)type));
        });
    }

    public static <RT1> @NonNull List<RT1> getParametersInRole(@NonNull String role, @NonNull Class<RT1> type, @NonNull MethodInvocationContext<?, ?> methodContext, @NonNull ConversionService conversionService) {
        return DefaultPreparedQuery.getParametersInRole(role, Argument.of(type), methodContext, conversionService);
    }

    public static <RT1> @NonNull List<RT1> getParametersInRole(@NonNull String role, @NonNull Argument<RT1> type, @NonNull MethodInvocationContext<?, ?> methodContext, @NonNull ConversionService conversionService) {
        AnnotationValue annotation = methodContext.getAnnotation(DataMethod.NAME);
        if (annotation == null) {
            return List.of();
        }
        List roles = annotation.getAnnotations("parametersTypeRoles");
        return roles.stream().filter(a -> ((String)a.stringValue().orElseThrow()).equals(role)).flatMap(a -> {
            Object value = methodContext.getParameterValues()[a.intValue("parameterIndex").orElseThrow()];
            if (value == null) {
                return Stream.empty();
            }
            if (type.isInstance(value)) {
                return Stream.of(value);
            }
            return conversionService.convert(value, type).stream();
        }).toList();
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public MethodInvocationContext<?, ?> getContext() {
        return this.context;
    }

    @Override
    public Class<E> getRootEntity() {
        return this.storedQuery.getRootEntity();
    }

    @Override
    public Map<String, Object> getQueryHints() {
        return this.storedQuery.getQueryHints();
    }

    @Override
    public boolean isRawQuery() {
        return this.storedQuery.isRawQuery();
    }

    @Override
    public StoredQuery<E, RT> getStoredQueryDelegate() {
        return this.storedQuery;
    }

    public <RT1> Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Class<RT1> type) {
        return DefaultPreparedQuery.getParameterInRole(role, type, this.context, this.conversionService);
    }

    public <RT1> List<RT1> getParametersInRole(String role, Class<RT1> type) {
        return DefaultPreparedQuery.getParametersInRole(role, type, this.context, this.conversionService);
    }

    public Class<?> getRepositoryType() {
        return this.context.getTarget().getClass();
    }

    public Object[] getParameterArray() {
        return this.context.getParameterValues();
    }

    public Argument[] getArguments() {
        return this.context.getArguments();
    }

    public @NonNull Pageable getPageable() {
        if (this.storedQuery.isCount()) {
            return Pageable.UNPAGED;
        }
        return this.pageable;
    }

    @Override
    public boolean isDtoProjection() {
        return this.dto;
    }

    @Override
    public @NonNull String getQuery() {
        return this.query;
    }

    public @NonNull ConvertibleValues<Object> getAttributes() {
        return this.context.getAttributes();
    }

    public @NonNull Optional<Object> getAttribute(CharSequence name) {
        return this.context.getAttribute(name);
    }

    public <T> @NonNull Optional<T> getAttribute(CharSequence name, Class<T> type) {
        return this.context.getAttribute(name, type);
    }

    @Override
    public Sort getSort() {
        return this.pageable.getSort();
    }

    @Override
    public Limit getQueryLimit() {
        if (this.limit != null) {
            return this.limit;
        }
        return this.pageable.getLimit();
    }
}

