/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.query.internal;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.StoredQuery;
import java.util.List;

@Internal
public class BasicStoredQuery<E, R>
implements StoredQuery<E, R> {
    private final String name;
    private final AnnotationMetadata annotationMetadata;
    private final String query;
    private final String[] expandableQueryParts;
    private final List<QueryParameterBinding> queryParameterBindings;
    private final Class<E> rootEntity;
    private final Class<R> resultType;
    private final boolean pageable;
    private final boolean isCount;
    private final DataType resultDataType;
    private final boolean rawQuery;
    private final StoredQuery.OperationType operationType;
    private final boolean isDto;

    public BasicStoredQuery(String query, String[] expandableQueryParts, List<QueryParameterBinding> queryParameterBindings, Class<E> rootEntity, Class<R> resultType, StoredQuery.OperationType operationType) {
        this("Custom query", AnnotationMetadata.EMPTY_METADATA, query, expandableQueryParts, queryParameterBindings, rootEntity, resultType, false, false, false, operationType);
    }

    public BasicStoredQuery(String name, AnnotationMetadata annotationMetadata, String query, String[] expandableQueryParts, List<QueryParameterBinding> queryParameterBindings, Class<E> rootEntity, Class<R> resultType, boolean pageable, boolean isCount, StoredQuery.OperationType operationType) {
        this(name, annotationMetadata, query, expandableQueryParts, queryParameterBindings, rootEntity, resultType, pageable, isCount, rootEntity != resultType && DataType.forType(resultType) == DataType.OBJECT && BeanIntrospector.SHARED.findIntrospection(resultType).isPresent(), operationType);
    }

    public BasicStoredQuery(String name, AnnotationMetadata annotationMetadata, String query, String[] expandableQueryParts, List<QueryParameterBinding> queryParameterBindings, Class<E> rootEntity, Class<R> resultType, boolean pageable, boolean isCount, boolean isDto, StoredQuery.OperationType operationType) {
        this.name = name;
        this.annotationMetadata = annotationMetadata;
        this.query = query;
        this.expandableQueryParts = expandableQueryParts == null ? new String[]{} : expandableQueryParts;
        this.queryParameterBindings = queryParameterBindings;
        this.rootEntity = rootEntity;
        this.resultType = resultType;
        this.pageable = pageable;
        this.isCount = isCount;
        this.operationType = operationType;
        this.resultDataType = isCount ? DataType.forType(resultType) : (rootEntity == resultType ? DataType.ENTITY : DataType.forType(resultType));
        this.rawQuery = annotationMetadata.stringValue(Query.class, "rawQuery").isPresent();
        this.isDto = isDto;
    }

    public boolean isDtoProjection() {
        return this.isDto;
    }

    public StoredQuery.OperationType getOperationType() {
        return this.operationType;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public String getName() {
        return this.name;
    }

    public Class<E> getRootEntity() {
        return this.rootEntity;
    }

    public Class<R> getResultType() {
        return this.resultType;
    }

    public Argument<R> getResultArgument() {
        return Argument.of(this.getResultType());
    }

    public DataType getResultDataType() {
        return this.resultDataType;
    }

    public boolean hasPageable() {
        return this.pageable;
    }

    public String getQuery() {
        return this.query;
    }

    public String[] getExpandableQueryParts() {
        return this.expandableQueryParts;
    }

    public List<QueryParameterBinding> getQueryBindings() {
        return this.queryParameterBindings;
    }

    public boolean isCount() {
        return this.isCount;
    }

    public boolean hasResultConsumer() {
        return false;
    }

    public boolean isRawQuery() {
        return this.rawQuery;
    }
}

