/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.sql;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.QueryResult;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.QueryResultInfo;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersStoredQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Internal
public class DefaultSqlStoredQuery<E, R>
extends DefaultBindableParametersStoredQuery<E, R>
implements SqlStoredQuery<E, R> {
    private final boolean expandableQuery;
    private final SqlQueryBuilder queryBuilder;
    private final QueryResultInfo queryResultInfo;

    public DefaultSqlStoredQuery(StoredQuery<E, R> storedQuery, RuntimePersistentEntity<E> runtimePersistentEntity, SqlQueryBuilder queryBuilder, ConversionService conversionService) {
        super(storedQuery, runtimePersistentEntity, conversionService);
        this.queryBuilder = queryBuilder;
        Objects.requireNonNull(storedQuery, "Query cannot be null");
        Objects.requireNonNull(queryBuilder, "Builder cannot be null");
        Object[] expandableQueryParts = storedQuery.getExpandableQueryParts();
        List queryParameterBindings = storedQuery.getQueryBindings();
        boolean bl = this.expandableQuery = expandableQueryParts.length > 1 && queryParameterBindings.stream().anyMatch(QueryParameterBinding::isExpandable);
        if (this.expandableQuery && expandableQueryParts.length != queryParameterBindings.size() + 1) {
            throw new IllegalStateException("Expandable query parts size should be the same as parameters size + 1. " + expandableQueryParts.length + " != 1 + " + queryParameterBindings.size() + " " + storedQuery.getQuery() + " " + Arrays.toString(expandableQueryParts));
        }
        if (storedQuery.getAnnotationMetadata().hasAnnotation(QueryResult.class)) {
            AnnotationValue queryResultAnn = storedQuery.getAnnotationMetadata().getAnnotation(QueryResult.class);
            QueryResult.Type type = queryResultAnn.enumValue("type", QueryResult.Type.class).orElse(QueryResult.Type.JSON);
            String columnName = (String)queryResultAnn.getRequiredValue("column", String.class);
            JsonDataType jsonDataType = type == QueryResult.Type.JSON ? queryResultAnn.enumValue("jsonDataType", JsonDataType.class).orElse(JsonDataType.DEFAULT) : null;
            this.queryResultInfo = new QueryResultInfo(type, columnName, jsonDataType);
        } else {
            this.queryResultInfo = null;
        }
    }

    @Override
    public QueryResultInfo getQueryResultInfo() {
        return this.queryResultInfo;
    }

    @Override
    public boolean isExpandableQuery() {
        return this.expandableQuery;
    }

    @Override
    public Dialect getDialect() {
        return this.queryBuilder.getDialect();
    }

    @Override
    public SqlQueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    @Override
    public Map<QueryParameterBinding, Object> collectAutoPopulatedPreviousValues(E entity) {
        StoredQuery storedQuery = this.getStoredQueryDelegate();
        if (storedQuery.getQueryBindings().isEmpty()) {
            return null;
        }
        return storedQuery.getQueryBindings().stream().filter(b -> b.isAutoPopulated() && b.isRequiresPreviousPopulatedValue()).map(b -> {
            if (b.getPropertyPath() == null) {
                throw new IllegalStateException("Missing property path for query parameter: " + String.valueOf(b));
            }
            Object value = entity;
            for (String property : b.getPropertyPath()) {
                if (value == null) break;
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(property, Argument.OBJECT_ARGUMENT);
            }
            return new AbstractMap.SimpleEntry<QueryParameterBinding, Object>((QueryParameterBinding)b, value);
        }).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }
}

