/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations;

import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ExecutorReactiveOperations
implements ReactiveRepositoryOperations {
    private final ExecutorAsyncOperations asyncOperations;
    private final ConversionService dataConversionService;

    public ExecutorReactiveOperations(@NonNull RepositoryOperations datastore, @NonNull Executor executor, DataConversionService dataConversionService) {
        this(new ExecutorAsyncOperations(datastore, executor), dataConversionService);
    }

    public ExecutorReactiveOperations(@NonNull ExecutorAsyncOperations asyncOperations, DataConversionService dataConversionService) {
        ArgumentUtils.requireNonNull((String)"asyncOperations", (Object)asyncOperations);
        this.asyncOperations = asyncOperations;
        this.dataConversionService = dataConversionService == null ? ConversionService.SHARED : dataConversionService;
    }

    public <T> @NonNull Publisher<T> findOne(@NonNull Class<T> type, @NonNull Object id) {
        return this.fromCompletableFuture(() -> this.asyncOperations.findOne(type, id));
    }

    public <T> Publisher<Boolean> exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.fromCompletableFuture(() -> this.asyncOperations.exists(preparedQuery));
    }

    public <T, R> @NonNull Publisher<R> findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.fromCompletableFuture(() -> this.asyncOperations.findOne(preparedQuery));
    }

    public <T> @NonNull Publisher<T> findOptional(@NonNull Class<T> type, @NonNull Object id) {
        return this.fromCompletableFuture(() -> this.asyncOperations.findOptional(type, id));
    }

    public <T, R> @NonNull Publisher<R> findOptional(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.fromCompletableFuture(() -> this.asyncOperations.findOptional(preparedQuery)).map(r -> {
            Argument returnType = preparedQuery.getResultArgument();
            Argument type = returnType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            if (!type.getType().isInstance(r)) {
                return this.dataConversionService.convert(r, type).orElseThrow(() -> new IllegalStateException("Unexpected return type: " + String.valueOf(r)));
            }
            return r;
        });
    }

    public <T> @NonNull Publisher<T> findAll(PagedQuery<T> pagedQuery) {
        return this.fromCompletableFuture(() -> this.asyncOperations.findAll(pagedQuery)).flatMapMany(Flux::fromIterable);
    }

    public <T> @NonNull Publisher<Long> count(PagedQuery<T> pagedQuery) {
        return this.fromCompletableFuture(() -> this.asyncOperations.count(pagedQuery));
    }

    public <R> @NonNull Publisher<Page<R>> findPage(@NonNull PagedQuery<R> pagedQuery) {
        return this.fromCompletableFuture(() -> this.asyncOperations.findPage(pagedQuery));
    }

    public <T, R> @NonNull Publisher<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.fromCompletableFuture(() -> this.asyncOperations.findAll(preparedQuery)).flatMapMany(Flux::fromIterable);
    }

    public <T> @NonNull Publisher<T> persist(@NonNull InsertOperation<T> entity) {
        return this.fromCompletableFuture(() -> this.asyncOperations.persist(entity));
    }

    public <T> @NonNull Publisher<T> update(@NonNull UpdateOperation<T> operation) {
        return this.fromCompletableFuture(() -> this.asyncOperations.update(operation));
    }

    public <T> @NonNull Publisher<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        return this.fromCompletableFuture(() -> this.asyncOperations.updateAll(operation)).flatMapMany(Flux::fromIterable);
    }

    public <T> @NonNull Publisher<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return this.fromCompletableFuture(() -> this.asyncOperations.persistAll(operation)).flatMapMany(Flux::fromIterable);
    }

    public @NonNull Publisher<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.fromCompletableFuture(() -> this.asyncOperations.executeUpdate((PreparedQuery)preparedQuery)).map(number -> this.convertNumberArgumentIfNecessary((Number)number, (Argument<?>)preparedQuery.getResultArgument()));
    }

    public <T> @NonNull Publisher<Number> delete(@NonNull DeleteOperation<T> operation) {
        return this.fromCompletableFuture(() -> this.asyncOperations.delete(operation));
    }

    public <T> @NonNull Publisher<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        return this.fromCompletableFuture(() -> this.asyncOperations.deleteAll(operation)).map(number -> this.convertNumberArgumentIfNecessary((Number)number, (Argument<?>)operation.getResultArgument()));
    }

    protected final <R> Mono<R> fromCompletableFuture(Supplier<CompletableFuture<R>> futureSupplier) {
        return Mono.fromCompletionStage((Supplier)PropagatedContext.wrapCurrent(futureSupplier));
    }

    private @Nullable Number convertNumberArgumentIfNecessary(Number number, Argument<?> argument) {
        Argument firstTypeVar = argument.getFirstTypeVariable().orElse(Argument.LONG);
        Class type = firstTypeVar.getType();
        if (type == Object.class || type == Void.class) {
            return null;
        }
        if (number == null) {
            number = 0;
        }
        if (!type.isInstance(number)) {
            return (Number)this.dataConversionService.convert((Object)number, firstTypeVar).orElseThrow(() -> new IllegalStateException("Unsupported number type for return type: " + String.valueOf(firstTypeVar)));
        }
        return number;
    }

    public ConversionService getConversionService() {
        return this.dataConversionService;
    }
}

