/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.async.AbstractAsyncSpecificationInterceptor;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Internal
public class FindPageAsyncSpecificationInterceptor
extends AbstractAsyncSpecificationInterceptor<Object, Object> {
    protected FindPageAsyncSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        CompletionStage<List<Object>> content;
        if (context.getExecutableMethod().isSuspend() ? context.getParameterValues().length != 3 : context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Pageable pageable = this.getPageable(context);
        if (pageable.isUnpaged()) {
            return this.findAllAsync(methodKey, context).thenApply(iterable -> {
                List resultList = CollectionUtils.iterableToList((Iterable)iterable);
                return Page.of((List)resultList, (Pageable)pageable, (Long)Long.valueOf(resultList.size()));
            });
        }
        CriteriaQuery<Object> criteriaQuery = this.buildQuery(methodKey, context);
        Root root = (Root)criteriaQuery.getRoots().iterator().next();
        if (root.getJoins().isEmpty()) {
            content = this.findAllAsync(methodKey, context, pageable, criteriaQuery);
        } else {
            CriteriaQuery<Tuple> criteriaIdsQuery = this.buildIdsQuery(methodKey, context, (Sort)pageable);
            content = this.findAllAsync(methodKey, context, pageable, criteriaIdsQuery).thenCompose(tupleResult -> {
                if (tupleResult.isEmpty()) {
                    return CompletableFuture.completedFuture(List.of());
                }
                ArrayList<Object> ids = new ArrayList<Object>(tupleResult.size());
                for (Tuple tuple : tupleResult) {
                    ids.add(tuple.get(0));
                }
                Predicate inPredicate = this.getIdExpression(root).in(ids);
                criteriaQuery.where((Expression)inPredicate);
                return this.findAllAsync(methodKey, context, pageable.withoutPaging(), criteriaQuery);
            });
        }
        return content.thenCompose(iterable -> {
            if (pageable.requestTotal()) {
                return this.getAsyncCriteriaRepositoryOperations(methodKey, context, null).findOne(this.buildCountQuery(methodKey, context)).thenApply(n -> n).thenApply(count -> Page.of((List)CollectionUtils.iterableToList((Iterable)iterable), (Pageable)pageable, (Long)count.longValue()));
            }
            return CompletableFuture.completedFuture(Page.of((List)CollectionUtils.iterableToList((Iterable)iterable), (Pageable)pageable, null));
        });
    }

    private <T> CompletionStage<List<T>> findAllAsync(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Pageable pageable, CriteriaQuery<T> criteriaQuery) {
        pageable = this.applyPaginationAndSort(pageable, criteriaQuery, false);
        if (this.asyncCriteriaOperations != null) {
            if (pageable != null) {
                if (pageable.getMode() != Pageable.Mode.OFFSET) {
                    throw new UnsupportedOperationException("Pageable mode " + String.valueOf(pageable.getMode()) + " is not supported by hibernate operations");
                }
                return this.asyncCriteriaOperations.findAll(criteriaQuery, (int)pageable.getOffset(), pageable.getSize());
            }
            int offset = this.getOffset(context);
            int limit = this.getLimit(context);
            if (offset > 0 || limit > 0) {
                return this.asyncCriteriaOperations.findAll(criteriaQuery, offset, limit);
            }
            return this.asyncCriteriaOperations.findAll(criteriaQuery);
        }
        return this.getAsyncCriteriaRepositoryOperations(methodKey, context, pageable).findAll(criteriaQuery);
    }
}

