/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import jakarta.persistence.criteria.CriteriaQuery;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@Internal
public class FindAllSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Object> {
    protected FindAllSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Class rt = context.getReturnType().getType();
        CriteriaQuery<Object> criteriaQuery = this.buildQuery(methodKey, context);
        List<Object> iterable = this.findAll(methodKey, context, this.getPageable(context), criteriaQuery);
        if (rt.equals(Stream.class)) {
            return StreamSupport.stream(iterable.spliterator(), false);
        }
        if (rt.isInstance(iterable)) {
            return iterable;
        }
        return this.operations.getConversionService().convert(iterable, context.getReturnType().asArgument()).orElse(Collections.emptyList());
    }
}

