/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.criteria.AbstractSpecificationInterceptor;
import jakarta.persistence.criteria.CriteriaQuery;
import org.jspecify.annotations.NonNull;

@Internal
public class CountSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Number> {
    public CountSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    public Number intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Number> context) {
        CriteriaQuery<Long> query = this.buildCountQuery(methodKey, context);
        Long result = (Long)this.getCriteriaRepositoryOperations(methodKey, context, null).findOne(query);
        ReturnType rt = context.getReturnType();
        Class returnType = rt.getType();
        if (returnType.isInstance(result)) {
            return result;
        }
        return (Number)this.operations.getConversionService().convertRequired((Object)result, rt.asArgument());
    }
}

