/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.criteria;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.First;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.OrderBy;
import io.micronaut.data.annotation.Projection;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.AssociationUtils;
import io.micronaut.data.model.CursoredPageable;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jd.SpecificationConstraint;
import io.micronaut.data.model.jpa.criteria.PersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.PersistentEntityFrom;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentPropertyPath;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.operations.CriteriaRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.repository.jpa.criteria.CriteriaDeleteBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaQueryBuilder;
import io.micronaut.data.repository.jpa.criteria.CriteriaUpdateBuilder;
import io.micronaut.data.repository.jpa.criteria.DeleteSpecification;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.repository.jpa.criteria.QuerySpecification;
import io.micronaut.data.repository.jpa.criteria.UpdateSpecification;
import io.micronaut.data.runtime.criteria.RuntimeCriteriaBuilder;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import io.micronaut.data.runtime.intercept.criteria.PreparedQueryCriteriaRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
public abstract class AbstractSpecificationInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    protected static final String PREPARED_QUERY_KEY = "PREPARED_QUERY";
    protected final CriteriaRepositoryOperations criteriaRepositoryOperations;
    protected CriteriaBuilder criteriaBuilder;
    private final Map<RepositoryMethodKey, QueryBuilder> sqlQueryBuilderForRepositories = new ConcurrentHashMap<RepositoryMethodKey, QueryBuilder>();
    private final Map<RepositoryMethodKey, Set<JoinPath>> methodsJoinPaths = new ConcurrentHashMap<RepositoryMethodKey, Set<JoinPath>>();

    protected AbstractSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        if (operations instanceof CriteriaRepositoryOperations) {
            CriteriaRepositoryOperations criteriaOps;
            this.criteriaRepositoryOperations = criteriaOps = (CriteriaRepositoryOperations)operations;
            this.criteriaBuilder = this.criteriaRepositoryOperations.getCriteriaBuilder();
        } else {
            this.criteriaRepositoryOperations = null;
            this.criteriaBuilder = (CriteriaBuilder)operations.getApplicationContext().getBean(RuntimeCriteriaBuilder.class);
        }
    }

    @Override
    protected Pageable getPageable(MethodInvocationContext<?, ?> context) {
        Pageable pageable = super.getPageable(context);
        List<Sort.Order> orders = context.getExecutableMethod().getAnnotationValuesByStereotype(OrderBy.class.getName()).stream().map(av -> new Sort.Order((String)av.stringValue().orElseThrow(), av.booleanValue("descending").orElse(false) != false ? Sort.Order.Direction.DESC : Sort.Order.Direction.ASC, av.booleanValue("ignoreCase").orElse(false).booleanValue())).toList();
        if (!orders.isEmpty()) {
            pageable = pageable.orders(orders);
        }
        return pageable;
    }

    final CriteriaRepositoryOperations getCriteriaRepositoryOperations(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Pageable pageable) {
        if (this.criteriaRepositoryOperations != null) {
            return this.criteriaRepositoryOperations;
        }
        QueryBuilder sqlQueryBuilder = this.getQueryBuilder(methodKey, context);
        return new PreparedQueryCriteriaRepositoryOperations(this.criteriaBuilder, this.operations, context, sqlQueryBuilder, this.getRequiredRootEntity(context), pageable);
    }

    protected final <B> List<B> findAll(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Pageable pageable, CriteriaQuery<B> criteriaQuery) {
        pageable = this.applyPaginationAndSort(pageable, criteriaQuery, false);
        if (this.criteriaRepositoryOperations != null) {
            AnnotationValue annotation;
            Limit limit = Limit.UNLIMITED;
            if (pageable != null) {
                limit = pageable.getLimit();
                if (pageable.getMode() != Pageable.Mode.OFFSET) {
                    throw new UnsupportedOperationException("Pageable mode " + String.valueOf(pageable.getMode()) + " is not supported by hibernate operations");
                }
            }
            if (!limit.isLimited()) {
                limit = this.getParameterInRole(context, "querylimit", Limit.class).orElse(limit);
            }
            if (!limit.isLimited()) {
                int offset = this.getOffset(context);
                int maxResults = this.getLimit(context);
                limit = Limit.of((int)maxResults, (long)offset);
            }
            if (!limit.isLimited() && (annotation = context.getAnnotationMetadata().getAnnotation(First.class)) != null) {
                limit = Limit.of((int)annotation.intValue().orElse(1), (long)0L);
            }
            if (limit.isLimited()) {
                return this.criteriaRepositoryOperations.findAll(criteriaQuery, (int)limit.offset(), limit.maxResults());
            }
            return this.criteriaRepositoryOperations.findAll(criteriaQuery);
        }
        return this.getCriteriaRepositoryOperations(methodKey, context, pageable).findAll(criteriaQuery);
    }

    protected final Set<JoinPath> getMethodJoinPaths(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.methodsJoinPaths.computeIfAbsent(methodKey, repositoryMethodKey -> AssociationUtils.getJoinPaths((AnnotationMetadata)context));
    }

    protected final @NonNull QueryBuilder getQueryBuilder(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.sqlQueryBuilderForRepositories.computeIfAbsent(methodKey, repositoryMethodKey -> {
            Class builder = (Class)context.getAnnotationMetadata().classValue(RepositoryConfiguration.class, "queryBuilder").orElseThrow(() -> new IllegalStateException("Cannot determine QueryBuilder"));
            BeanIntrospection introspection = BeanIntrospection.getIntrospection((Class)builder);
            if (introspection.getConstructorArguments().length == 1 && introspection.getConstructorArguments()[0].getType() == AnnotationMetadata.class) {
                return (QueryBuilder)introspection.instantiate(new Object[]{context.getAnnotationMetadata()});
            }
            return (QueryBuilder)introspection.instantiate();
        });
    }

    protected final @NonNull CriteriaQuery<Object> buildExistsQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.getCriteriaQueryBuilder(context, this.getMethodJoinPaths(methodKey, context), this.getRequiredRootEntity(context)).build(this.criteriaBuilder);
    }

    protected final <E> @NonNull CriteriaUpdate<E> buildUpdateQuery(MethodInvocationContext<?, ?> context) {
        return this.getCriteriaUpdateBuilder(context, this.getRequiredRootEntity(context)).build(this.criteriaBuilder);
    }

    protected final <E> @NonNull CriteriaDelete<E> buildDeleteQuery(MethodInvocationContext<?, ?> context) {
        return this.getCriteriaDeleteBuilder(context, this.getRequiredRootEntity(context)).build(this.criteriaBuilder);
    }

    protected final @NonNull CriteriaQuery<Long> buildCountQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.getCountCriteriaQueryBuilder(context, this.getMethodJoinPaths(methodKey, context), this.getRequiredRootEntity(context)).build(this.criteriaBuilder);
    }

    protected final @NonNull CriteriaQuery<Object> buildQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context) {
        return this.getCriteriaQueryBuilder(context, this.getMethodJoinPaths(methodKey, context), this.getRequiredRootEntity(context)).build(this.criteriaBuilder);
    }

    private <N> void appendSort(Sort sort, CriteriaQuery<N> criteriaQuery, Root<?> root) {
        if (sort.isSorted()) {
            criteriaQuery.orderBy(this.getOrders(sort, root, this.criteriaBuilder));
        }
    }

    protected final Pageable applyPaginationAndSort(Pageable pageable, CriteriaQuery<?> criteriaQuery, boolean singleResult) {
        Root root = (Root)criteriaQuery.getRoots().stream().findFirst().orElseThrow(() -> new IllegalStateException("The root not found!"));
        if (pageable instanceof CursoredPageable) {
            CursoredPageable cursored = (CursoredPageable)pageable;
            cursored = DefaultSqlPreparedQuery.enhancePageable(cursored, this.getPersistentEntity(root));
            pageable = cursored;
            this.buildCursorPagination(criteriaQuery, this.criteriaBuilder, cursored);
        }
        this.appendSort(pageable.getSort(), criteriaQuery, root);
        pageable = pageable.withoutSort();
        if (singleResult && pageable.getOffset() > 0L) {
            pageable = Pageable.from((int)pageable.getNumber(), (int)1);
        }
        if (pageable.isUnpaged()) {
            return pageable;
        }
        if (criteriaQuery instanceof PersistentEntityCriteriaQuery) {
            PersistentEntityCriteriaQuery persistentEntityCriteriaQuery = (PersistentEntityCriteriaQuery)criteriaQuery;
            long offset = pageable.getMode() == Pageable.Mode.OFFSET ? pageable.getOffset() : 0L;
            long limit = pageable.getSize();
            if (offset > 0L) {
                persistentEntityCriteriaQuery.offset((int)offset);
            }
            if (limit > 0L) {
                persistentEntityCriteriaQuery.limit((int)limit);
            }
            return Pageable.UNPAGED;
        }
        return pageable;
    }

    private void buildCursorPagination(CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder, CursoredPageable cursoredPageable) {
        if (cursoredPageable.cursor().isEmpty()) {
            return;
        }
        Pageable.Cursor cursor = (Pageable.Cursor)cursoredPageable.cursor().get();
        Sort sort = cursoredPageable.getSort();
        List orders = sort.getOrderBy();
        if (orders.size() != cursor.size()) {
            throw new IllegalArgumentException("The cursor must match the sorting size");
        }
        if (orders.isEmpty()) {
            throw new IllegalArgumentException("At least one sorting property must be supplied");
        }
        Root root = (Root)criteriaQuery.getRoots().iterator().next();
        ArrayList<Predicate> orPredicates = new ArrayList<Predicate>(orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            ArrayList<Predicate> andPredicates = new ArrayList<Predicate>(orders.size());
            for (int j = 0; j <= i; ++j) {
                String propertyName = ((Sort.Order)orders.get(j)).getProperty();
                Object value = cursor.get(i);
                Predicate predicate = ((Sort.Order)orders.get(i)).isAscending() ? (i == j ? criteriaBuilder.greaterThan((Expression)root.get(propertyName), (Comparable)value) : criteriaBuilder.equal((Expression)root.get(propertyName), value)) : (i == j ? criteriaBuilder.lessThan((Expression)root.get(propertyName), (Comparable)value) : criteriaBuilder.equal((Expression)root.get(propertyName), value));
                andPredicates.add(predicate);
            }
            orPredicates.add(criteriaBuilder.and(andPredicates.toArray(new Predicate[0])));
        }
        Predicate predicate = criteriaBuilder.or(orPredicates.toArray(new Predicate[0]));
        Predicate restriction = criteriaQuery.getRestriction();
        if (restriction == null) {
            criteriaQuery.where((Expression)predicate);
        } else {
            criteriaQuery.where((Expression)criteriaBuilder.and((Expression)restriction, (Expression)predicate));
        }
    }

    protected final CriteriaQuery<Tuple> buildIdsQuery(RepositoryMethodKey methodKey, MethodInvocationContext<?, ?> context, Sort sort) {
        return this.getIdsCriteriaQueryBuilder(context, this.getMethodJoinPaths(methodKey, context), sort, this.getRequiredRootEntity(context)).build(this.criteriaBuilder);
    }

    protected <K> @Nullable QuerySpecification<K> getQuerySpecification(MethodInvocationContext<?, ?> context, Class<?> rootEntity) {
        Optional<PredicateSpecification> predicateSpecification = this.getPredicateSpecification(context, rootEntity);
        if (predicateSpecification.isPresent()) {
            return QuerySpecification.where((PredicateSpecification)predicateSpecification.get());
        }
        Optional spec = this.getParameterInRole(context, "specificationPredicate", Argument.of(QuerySpecification.class, (Class[])new Class[]{rootEntity}));
        if (spec.isPresent()) {
            return (QuerySpecification)spec.get();
        }
        spec = this.getParameterInRole(context, "specificationQuery", Argument.of(QuerySpecification.class, (Class[])new Class[]{rootEntity}));
        if (spec.isPresent()) {
            return (QuerySpecification)spec.get();
        }
        if (context.getArguments()[0].isNullable()) {
            return null;
        }
        throw new IllegalArgumentException("Specification may not be null.");
    }

    private Optional<PredicateSpecification> getPredicateSpecification(MethodInvocationContext<?, ?> context, Class<?> rootEntity) {
        List predicates = CollectionUtils.concat(this.getParametersInRole(context, "specificationPredicate", Argument.of(PredicateSpecification.class, (Class[])new Class[]{rootEntity})), this.getSpecificationConstraints(context));
        if (predicates.isEmpty()) {
            return Optional.empty();
        }
        if (predicates.size() == 1) {
            return Optional.of((PredicateSpecification)predicates.get(0));
        }
        final List finalPredicates = predicates;
        return Optional.of(new PredicateSpecification(){

            public Predicate toPredicate(Root root, CriteriaBuilder criteriaBuilder) {
                ArrayList<Predicate> andPredicates = new ArrayList<Predicate>(finalPredicates.size());
                for (PredicateSpecification predicate : finalPredicates) {
                    andPredicates.add(predicate.toPredicate(root, criteriaBuilder));
                }
                return criteriaBuilder.and(andPredicates.toArray(new Predicate[0]));
            }
        });
    }

    private @NonNull List<PredicateSpecification> getSpecificationConstraints(@NonNull MethodInvocationContext<?, ?> methodContext) {
        AnnotationValue annotation = methodContext.getAnnotation(DataMethod.NAME);
        if (annotation == null) {
            return List.of();
        }
        List roles = annotation.getAnnotations("parametersTypeRoles");
        return roles.stream().filter(a -> ((String)a.stringValue().orElseThrow()).equals("specificationConstraint")).flatMap(a -> {
            int parameterIndex = a.intValue("parameterIndex").orElseThrow();
            Argument argument = methodContext.getArguments()[parameterIndex];
            Object value = methodContext.getParameterValues()[parameterIndex];
            return this.conversionService.convert((Object)new SpecificationConstraint(argument, value), PredicateSpecification.class).stream();
        }).toList();
    }

    protected final <K> @NonNull CriteriaQueryBuilder<Object> getCriteriaQueryBuilder(MethodInvocationContext<?, ?> context, Set<JoinPath> joinPaths, Class<K> rootEntity) {
        Optional queryBuilder = this.getParameterInRole(context, "specificationQuery", Argument.of(CriteriaQueryBuilder.class, (Class[])new Class[]{rootEntity}));
        if (queryBuilder.isPresent()) {
            return (CriteriaQueryBuilder)queryBuilder.get();
        }
        return criteriaBuilder -> {
            Predicate predicate;
            CriteriaQuery criteriaQuery;
            List projections = context.getAnnotationValuesByType(Projection.class);
            AnnotationValue dataAnnotation = context.getAnnotation(DataMethod.class);
            boolean isDto = dataAnnotation.isTrue("dto");
            QuerySpecification specification = this.getQuerySpecification(context, rootEntity);
            if (isDto || !projections.isEmpty()) {
                Class<Object> dtoClass = dataAnnotation.classValue("resultType").orElse(Object.class);
                criteriaQuery = criteriaBuilder.createQuery(dtoClass);
            } else {
                criteriaQuery = criteriaBuilder.createQuery(rootEntity);
            }
            Root root = criteriaQuery.from(rootEntity);
            if (CollectionUtils.isNotEmpty((Collection)joinPaths)) {
                for (JoinPath joinPath : this.sortJoinPaths(joinPaths)) {
                    this.join(root, joinPath);
                }
            }
            if (specification != null && (predicate = specification.toPredicate(root, criteriaQuery, criteriaBuilder)) != null) {
                criteriaQuery.where((Expression)predicate);
            }
            if (!projections.isEmpty()) {
                if (projections.size() == 1) {
                    criteriaQuery.select((Selection)root.get((String)((AnnotationValue)projections.getFirst()).stringValue().orElseThrow()));
                } else {
                    criteriaQuery.multiselect((Selection[])projections.stream().map(av -> root.get((String)av.stringValue().orElseThrow())).toArray(Selection[]::new));
                }
            }
            return criteriaQuery;
        };
    }

    protected final @NonNull CriteriaQueryBuilder<Tuple> getIdsCriteriaQueryBuilder(MethodInvocationContext<?, ?> context, Set<JoinPath> joinPaths, Sort sort, Class<?> rootEntity) {
        Optional queryBuilder = this.getParameterInRole(context, "specificationQuery", Argument.of(CriteriaQueryBuilder.class, (Class[])new Class[]{rootEntity}));
        if (queryBuilder.isPresent()) {
            throw new IllegalStateException("Criteria pagination doesn't support CriteriaQueryBuilder!");
        }
        return criteriaBuilder -> this.createSelectIdsCriteriaQuery(context, joinPaths, sort, rootEntity);
    }

    private <K> @NonNull CriteriaQuery<Tuple> createSelectIdsCriteriaQuery(MethodInvocationContext<?, ?> context, Set<JoinPath> joinPaths, Sort sort, Class<K> rootEntity) {
        Predicate predicate;
        QuerySpecification<K> specification;
        CriteriaQuery criteriaQuery = this.criteriaBuilder.createTupleQuery();
        Root root = criteriaQuery.from(rootEntity);
        if (CollectionUtils.isNotEmpty(joinPaths)) {
            for (JoinPath joinPath : this.sortJoinPaths(joinPaths)) {
                this.join(root, joinPath);
            }
        }
        if ((specification = this.getQuerySpecification(context, rootEntity)) != null && (predicate = specification.toPredicate(root, criteriaQuery, this.criteriaBuilder)) != null) {
            criteriaQuery.where((Expression)predicate);
        }
        criteriaQuery.multiselect(this.createSelectionForSelectingIds(sort, root)).distinct(true);
        return criteriaQuery;
    }

    private <K> List<Selection<?>> createSelectionForSelectingIds(Sort sort, Root<K> root) {
        ArrayList selection = new ArrayList();
        selection.add((Selection<?>)this.getIdExpression((Root<?>)root));
        ArrayList orders = new ArrayList(sort.getOrderBy());
        for (Join join : root.getJoins()) {
            for (Sort.Order order : sort.getOrderBy()) {
                PersistentPropertyPath persistentPropertyPath;
                Iterator orderIterator = StringUtils.splitOmitEmptyStrings((CharSequence)order.getProperty(), (char)'.').iterator();
                if (!orderIterator.hasNext()) continue;
                String firstPath = (String)orderIterator.next();
                if (join instanceof PersistentPropertyPath ? !(persistentPropertyPath = (PersistentPropertyPath)join).getProperty().getName().equals(firstPath) : !join.getAttribute().getName().equals(firstPath)) continue;
                orders.remove(order);
                Join path = join;
                while (orderIterator.hasNext()) {
                    path = path.get((String)orderIterator.next());
                }
                selection.add((Selection<?>)path);
            }
        }
        for (Sort.Order order : orders) {
            Path path = root;
            for (String orderPath : StringUtils.splitOmitEmptyStrings((CharSequence)order.getProperty(), (char)'.')) {
                path = path.get(orderPath);
            }
            selection.add((Selection<?>)path);
        }
        return selection;
    }

    protected @NonNull CriteriaQueryBuilder<Long> getCountCriteriaQueryBuilder(MethodInvocationContext<?, ?> context, final Set<JoinPath> joinPaths, Class<?> rootEntity) {
        final Optional queryBuilder = this.getParameterInRole(context, "specificationQuery", Argument.of(CriteriaQueryBuilder.class, (Class[])new Class[]{rootEntity}));
        if (queryBuilder.isPresent()) {
            return new CriteriaQueryBuilder<Long>(){
                final /* synthetic */ AbstractSpecificationInterceptor this$0;
                {
                    this.this$0 = this$0;
                }

                public CriteriaQuery<Long> build(CriteriaBuilder criteriaBuilder) {
                    boolean countOnRoot;
                    CriteriaQuery criteriaQuery = ((CriteriaQueryBuilder)queryBuilder.get()).build(criteriaBuilder);
                    Expression<?> root = (Expression<?>)criteriaQuery.getRoots().iterator().next();
                    PersistentEntity entity = this.this$0.getPersistentEntity((Root<?>)root);
                    boolean bl = countOnRoot = entity.hasCompositeIdentity() || entity.getIdentity() instanceof Embedded;
                    Expression countExpression = !root.getJoins().isEmpty() || !root.getFetches().isEmpty() || !joinPaths.isEmpty() ? criteriaBuilder.countDistinct((Expression)(countOnRoot ? root : this.this$0.getIdExpression((Root<?>)root))) : criteriaBuilder.count(countOnRoot ? root : this.this$0.getIdExpression((Root<?>)root));
                    return criteriaQuery.select((Selection)countExpression);
                }
            };
        }
        return criteriaBuilder -> this.createPageCountCriteriaQuery(context, criteriaBuilder, joinPaths, rootEntity);
    }

    private <E> CriteriaQuery<Long> createPageCountCriteriaQuery(MethodInvocationContext<?, ?> context, CriteriaBuilder criteriaBuilder, Set<JoinPath> joinPaths, Class<E> rootEntity) {
        PersistentEntity entity;
        boolean countOnRoot;
        Predicate predicate;
        QuerySpecification specification = this.getQuerySpecification(context, rootEntity);
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Expression<?> root = criteriaQuery.from(rootEntity);
        if (specification != null && (predicate = specification.toPredicate((Root)root, criteriaQuery, criteriaBuilder)) != null) {
            criteriaQuery.where((Expression)predicate);
        }
        boolean bl = countOnRoot = (entity = this.getPersistentEntity((Root<?>)root)).hasCompositeIdentity() || entity.getIdentity() instanceof Embedded;
        Expression countExpression = !root.getJoins().isEmpty() || !root.getFetches().isEmpty() || !joinPaths.isEmpty() ? criteriaBuilder.countDistinct((Expression)(countOnRoot ? root : this.getIdExpression((Root<?>)root))) : criteriaBuilder.count(countOnRoot ? root : this.getIdExpression((Root<?>)root));
        return criteriaQuery.select((Selection)countExpression);
    }

    protected final Expression<?> getIdExpression(Root<?> root) {
        if (root instanceof PersistentEntityRoot) {
            PersistentEntityRoot persistentEntityRoot = (PersistentEntityRoot)root;
            return persistentEntityRoot.id();
        }
        return root.get(this.getPersistentEntity(root).getIdentity().getName());
    }

    private PersistentEntity getPersistentEntity(Root<?> root) {
        if (root instanceof PersistentEntityRoot) {
            PersistentEntityRoot persistentEntityRoot = (PersistentEntityRoot)root;
            return persistentEntityRoot.getPersistentEntity();
        }
        return this.operations.getEntity(root.getModel().getJavaType());
    }

    private void join(Root<?> root, JoinPath joinPath) {
        if (root instanceof PersistentEntityFrom) {
            PersistentEntityFrom persistentEntityFrom = (PersistentEntityFrom)root;
            Optional optAlias = joinPath.getAlias();
            if (optAlias.isPresent()) {
                persistentEntityFrom.join(joinPath.getPath(), joinPath.getJoinType(), (String)optAlias.get());
            } else {
                persistentEntityFrom.join(joinPath.getPath(), joinPath.getJoinType());
            }
        } else {
            root.join(joinPath.getPath(), this.toJoinType(joinPath.getJoinType()));
        }
    }

    private JoinType toJoinType(Join.Type joinType) {
        return switch (joinType) {
            case Join.Type.DEFAULT, Join.Type.FETCH, Join.Type.LEFT, Join.Type.LEFT_FETCH -> JoinType.LEFT;
            case Join.Type.RIGHT, Join.Type.RIGHT_FETCH -> JoinType.RIGHT;
            case Join.Type.INNER, Join.Type.INNER_FETCH -> JoinType.INNER;
            default -> throw new IllegalArgumentException("Unsupported join type: " + String.valueOf(joinType));
        };
    }

    protected <K> @Nullable DeleteSpecification<K> getDeleteSpecification(MethodInvocationContext<?, ?> context, Class<K> rootEntity) {
        Optional<PredicateSpecification> predicateSpecification = this.getPredicateSpecification(context, rootEntity);
        if (predicateSpecification.isPresent()) {
            return DeleteSpecification.where((PredicateSpecification)predicateSpecification.get());
        }
        Optional spec = this.getParameterInRole(context, "specificationPredicate", Argument.of(DeleteSpecification.class, (Class[])new Class[]{rootEntity}));
        if (spec.isPresent()) {
            return (DeleteSpecification)spec.get();
        }
        spec = this.getParameterInRole(context, "specificationUpdate", Argument.of(DeleteSpecification.class, (Class[])new Class[]{rootEntity}));
        if (spec.isPresent()) {
            return (DeleteSpecification)spec.get();
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isNullable()) {
            return null;
        }
        throw new IllegalArgumentException("Specification may not be null.");
    }

    protected <K> @NonNull CriteriaDeleteBuilder<K> getCriteriaDeleteBuilder(MethodInvocationContext<?, ?> context, Class<K> rootEntity) {
        Optional<CriteriaDeleteBuilder> criteriaDeleteBuilder = this.getParameterInRole(context, "specificationUpdate", CriteriaDeleteBuilder.class);
        if (criteriaDeleteBuilder.isPresent()) {
            return criteriaDeleteBuilder.get();
        }
        return criteriaBuilder -> {
            Predicate predicate;
            DeleteSpecification specification = this.getDeleteSpecification(context, rootEntity);
            CriteriaDelete criteriaDelete = criteriaBuilder.createCriteriaDelete(rootEntity);
            Root root = criteriaDelete.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaDelete, criteriaBuilder)) != null) {
                criteriaDelete.where((Expression)predicate);
            }
            return criteriaDelete;
        };
    }

    protected <K> @Nullable UpdateSpecification<K> getUpdateSpecification(MethodInvocationContext<?, ?> context, Class<K> rootEntity) {
        Optional spec = this.getParameterInRole(context, "specificationUpdate", Argument.of(UpdateSpecification.class, (Class[])new Class[]{rootEntity}));
        if (spec.isPresent()) {
            return (UpdateSpecification)spec.get();
        }
        Argument parameterArgument = context.getArguments()[0];
        if (parameterArgument.isNullable()) {
            return null;
        }
        throw new IllegalArgumentException("Specification may not be null.");
    }

    protected <K> @NonNull CriteriaUpdateBuilder<K> getCriteriaUpdateBuilder(MethodInvocationContext<?, ?> context, Class<K> rootEntity) {
        Optional criteriaUpdateBuilder = this.getParameterInRole(context, "specificationUpdate", Argument.of(CriteriaUpdateBuilder.class, (Class[])new Class[]{rootEntity}));
        if (criteriaUpdateBuilder.isPresent()) {
            return (CriteriaUpdateBuilder)criteriaUpdateBuilder.get();
        }
        return criteriaBuilder -> {
            Predicate predicate;
            UpdateSpecification specification = this.getUpdateSpecification(context, rootEntity);
            CriteriaUpdate criteriaUpdate = criteriaBuilder.createCriteriaUpdate(rootEntity);
            Root root = criteriaUpdate.from(rootEntity);
            if (specification != null && (predicate = specification.toPredicate(root, criteriaUpdate, criteriaBuilder)) != null) {
                criteriaUpdate.where((Expression)predicate);
            }
            return criteriaUpdate;
        };
    }

    private List<Order> getOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Expression path = root;
            for (String orderPath : StringUtils.splitOmitEmptyStrings((CharSequence)order.getProperty(), (char)'.')) {
                path = path.get(orderPath);
            }
            Expression expression = order.isIgnoreCase() ? cb.lower(path) : path;
            orders.add(order.isAscending() ? cb.asc(expression) : cb.desc(expression));
        }
        return orders;
    }

    private List<JoinPath> sortJoinPaths(Collection<JoinPath> joinPaths) {
        ArrayList<JoinPath> sortedJoinPaths = new ArrayList<JoinPath>(joinPaths);
        sortedJoinPaths.sort((o1, o2) -> Comparator.comparingInt(String::length).thenComparing(String::compareTo).compare(o1.getPath(), o2.getPath()));
        return sortedJoinPaths;
    }
}

