/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.FindSliceInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Slice;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.List;
import org.jspecify.annotations.NonNull;

public class DefaultFindSliceInterceptor<T, R>
extends AbstractQueryInterceptor<T, R>
implements FindSliceInterceptor<T, R> {
    protected DefaultFindSliceInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public R intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, R> context) {
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery preparedQuery = this.prepareQuery(methodKey, context);
            Pageable pageable = preparedQuery.getPageable();
            Iterable iterable = this.operations.findAll(preparedQuery);
            List results = CollectionUtils.iterableToList((Iterable)iterable);
            Slice slice = Slice.of((List)results, (Pageable)pageable);
            return this.convertOrFail(context, slice);
        }
        PagedQuery pagedQuery = this.getPagedQuery(context);
        Iterable iterable = this.operations.findAll(pagedQuery);
        Slice slice = Slice.of((List)CollectionUtils.iterableToList((Iterable)iterable), (Pageable)pagedQuery.getPageable());
        return this.convertOrFail(context, slice);
    }

    private R convertOrFail(MethodInvocationContext<T, R> context, Slice<R> slice) {
        ReturnType returnType = context.getReturnType();
        if (returnType.getType().isInstance(slice)) {
            return (R)slice;
        }
        return (R)this.operations.getConversionService().convert(slice, returnType.asArgument()).orElseThrow(() -> new IllegalStateException("Unsupported slice interface: " + String.valueOf(returnType.getType())));
    }
}

