/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.data.intercept.DeleteOneInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

public class DefaultDeleteOneInterceptor<T>
extends AbstractQueryInterceptor<T, Object>
implements DeleteOneInterceptor<T> {
    protected DefaultDeleteOneInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Object> context) {
        Class returnType = context.getReturnType().getType();
        Optional<Object> deleteEntity = this.findEntityParameter(context, Object.class);
        if (deleteEntity.isPresent()) {
            Object entity = deleteEntity.get();
            Class rootEntity = this.getRequiredRootEntity(context);
            if (!rootEntity.isInstance(entity)) {
                throw new IllegalArgumentException("Entity argument must be an instance of " + rootEntity.getName());
            }
            Integer deleted = this.operations.delete(this.getDeleteOperation(context, entity));
            if (this.isNumber(returnType)) {
                return this.operations.getConversionService().convertRequired((Object)deleted, returnType);
            }
            if (returnType.equals(rootEntity)) {
                if (deleted > 0) {
                    return entity;
                }
                return null;
            }
            return null;
        }
        throw new IllegalStateException("Argument not found");
    }
}

