/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.type.Argument;
import io.micronaut.data.intercept.DeleteAllReturningInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.operations.DeleteReturningRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

public class DefaultDeleteAllReturningInterceptor<E, R>
extends AbstractQueryInterceptor<E, R>
implements DeleteAllReturningInterceptor<E, R> {
    protected DefaultDeleteAllReturningInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public R intercept(RepositoryMethodKey methodKey, MethodInvocationContext<E, R> context) {
        Argument resultType = context.getReturnType().asArgument();
        Optional<Iterable<Object>> deleteEntities = this.findEntitiesParameter(context, Object.class);
        Optional<Object> deleteEntity = this.findEntityParameter(context, Object.class);
        if (deleteEntity.isEmpty() && deleteEntities.isEmpty()) {
            throw new IllegalStateException("Expected to find and entity");
        }
        if (deleteEntity.isPresent()) {
            RepositoryOperations repositoryOperations = this.operations;
            if (repositoryOperations instanceof DeleteReturningRepositoryOperations) {
                DeleteReturningRepositoryOperations deleteReturningRepositoryOperations = (DeleteReturningRepositoryOperations)repositoryOperations;
                Object result = deleteReturningRepositoryOperations.deleteReturning(this.getDeleteReturningOperation(context, deleteEntity.get()));
                return this.convertIfNecessary(resultType, result);
            }
            Integer result = this.operations.delete(this.getDeleteOperation(context, deleteEntity.get()));
            return this.convertIfNecessary(resultType, result);
        }
        RepositoryOperations repositoryOperations = this.operations;
        if (repositoryOperations instanceof DeleteReturningRepositoryOperations) {
            DeleteReturningRepositoryOperations deleteReturningRepositoryOperations = (DeleteReturningRepositoryOperations)repositoryOperations;
            return (R)deleteReturningRepositoryOperations.deleteAllReturning(this.getDeleteReturningBatchOperation(context, deleteEntities.get()));
        }
        Number result = this.operations.deleteAll(this.getDeleteBatchOperation(context, deleteEntities.get())).orElse(0);
        return this.convertIfNecessary(resultType, result);
    }

    private R convertIfNecessary(Argument<R> resultType, Object result) {
        if (!resultType.getType().isInstance(result)) {
            return (R)this.operations.getConversionService().convertRequired(result, resultType);
        }
        return (R)result;
    }
}

