/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.processor.ExecutableMethodProcessor;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.event.EntityEventMapping;
import io.micronaut.data.annotation.event.PostLoad;
import io.micronaut.data.annotation.event.PostPersist;
import io.micronaut.data.annotation.event.PostRemove;
import io.micronaut.data.annotation.event.PostUpdate;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.annotation.event.PreRemove;
import io.micronaut.data.annotation.event.PreUpdate;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.event.PersistenceEventException;
import io.micronaut.data.event.QueryEventContext;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionMethodReference;
import io.micronaut.inject.ExecutableMethod;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jspecify.annotations.NonNull;

@Singleton
@Primary
public class EntityEventRegistry
implements EntityEventListener<Object>,
ExecutableMethodProcessor<EntityEventMapping> {
    public static final List<Class<? extends Annotation>> EVENT_TYPES = Arrays.asList(PostLoad.class, PostPersist.class, PostRemove.class, PostUpdate.class, PrePersist.class, PreRemove.class, PreUpdate.class);
    private final Collection<BeanDefinition<EntityEventListener>> allEventListeners;
    private final Map<RuntimePersistentEntity<Object>, Map<Class<? extends Annotation>, EntityEventListener<Object>>> entityToEventListeners = new ConcurrentHashMap<RuntimePersistentEntity<Object>, Map<Class<? extends Annotation>, EntityEventListener<Object>>>(50);
    private final BeanContext beanContext;
    private final Map<Class<? extends Annotation>, Collection<BeanDefinitionMethodReference<Object, Object>>> beanEventHandlers = new HashMap<Class<? extends Annotation>, Collection<BeanDefinitionMethodReference<Object, Object>>>(10);

    public EntityEventRegistry(BeanContext beanContext) {
        this.beanContext = beanContext;
        this.allEventListeners = beanContext.getBeanDefinitions(EntityEventListener.class).stream().filter(bd -> bd.getBeanType() != this.getClass()).toList();
    }

    public boolean supports(RuntimePersistentEntity<Object> entity, Class<? extends Annotation> eventType) {
        Map<Class<? extends Annotation>, EntityEventListener<Object>> listeners = this.getListeners(entity);
        return listeners.containsKey(eventType);
    }

    public boolean prePersist(@NonNull EntityEventContext<Object> context) {
        try {
            EntityEventListener<Object> target = this.getListeners((RuntimePersistentEntity<Object>)context.getPersistentEntity()).get(PrePersist.class);
            if (target != null) {
                return target.prePersist(context);
            }
        }
        catch (Exception e) {
            throw new PersistenceEventException("An error occurred invoking pre-persist event listeners: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public void postPersist(@NonNull EntityEventContext<Object> context) {
        try {
            EntityEventListener<Object> target = this.getListeners((RuntimePersistentEntity<Object>)context.getPersistentEntity()).get(PostPersist.class);
            if (target != null) {
                target.postPersist(context);
            }
        }
        catch (Exception e) {
            throw new PersistenceEventException("An error occurred invoking post-persist event listeners: " + e.getMessage(), (Throwable)e);
        }
    }

    public void postLoad(@NonNull EntityEventContext<Object> context) {
        try {
            EntityEventListener<Object> target = this.getListeners((RuntimePersistentEntity<Object>)context.getPersistentEntity()).get(PostLoad.class);
            if (target != null) {
                target.postLoad(context);
            }
        }
        catch (Exception e) {
            throw new PersistenceEventException("An error occurred invoking post-load event listeners: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean preRemove(@NonNull EntityEventContext<Object> context) {
        try {
            EntityEventListener<Object> target = this.getListeners((RuntimePersistentEntity<Object>)context.getPersistentEntity()).get(PreRemove.class);
            if (target != null) {
                return target.preRemove(context);
            }
            return true;
        }
        catch (Exception e) {
            throw new PersistenceEventException("An error occurred invoking pre-remove event listeners: " + e.getMessage(), (Throwable)e);
        }
    }

    public void postRemove(@NonNull EntityEventContext<Object> context) {
        try {
            EntityEventListener<Object> target = this.getListeners((RuntimePersistentEntity<Object>)context.getPersistentEntity()).get(PostRemove.class);
            if (target != null) {
                target.postRemove(context);
            }
        }
        catch (Exception e) {
            throw new PersistenceEventException("An error occurred invoking post-remove event listeners: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean preUpdate(@NonNull EntityEventContext<Object> context) {
        try {
            EntityEventListener<Object> target = this.getListeners((RuntimePersistentEntity<Object>)context.getPersistentEntity()).get(PreUpdate.class);
            if (target != null) {
                return target.preUpdate(context);
            }
            return true;
        }
        catch (Exception e) {
            throw new PersistenceEventException("An error occurred invoking pre-update event listeners: " + e.getMessage(), (Throwable)e);
        }
    }

    public void postUpdate(@NonNull EntityEventContext<Object> context) {
        try {
            EntityEventListener<Object> target = this.getListeners((RuntimePersistentEntity<Object>)context.getPersistentEntity()).get(PostUpdate.class);
            if (target != null) {
                target.postUpdate(context);
            }
        }
        catch (Exception e) {
            throw new PersistenceEventException("An error occurred invoking post-update event listeners: " + e.getMessage(), (Throwable)e);
        }
    }

    private @NonNull Map<Class<? extends Annotation>, EntityEventListener<Object>> getListeners(RuntimePersistentEntity<Object> entity) {
        Map<Class<? extends Annotation>, EntityEventListener<Object>> listeners = this.entityToEventListeners.get(entity);
        if (listeners == null) {
            listeners = this.initListeners(entity);
            this.entityToEventListeners.put(entity, listeners);
        }
        return listeners;
    }

    private @NonNull Map<Class<? extends Annotation>, EntityEventListener<Object>> initListeners(RuntimePersistentEntity<Object> entity) {
        HashMap<Class, Collection> listeners = new HashMap<Class, Collection>(8);
        for (BeanDefinition<EntityEventListener> beanDefinition : this.allEventListeners) {
            List typeArguments = beanDefinition.getTypeArguments();
            if (typeArguments.isEmpty()) {
                typeArguments = beanDefinition.getTypeArguments(EntityEventListener.class);
            }
            if (!this.isApplicableListener(entity, typeArguments)) continue;
            EntityEventListener eventListener = (EntityEventListener)this.beanContext.getBean(beanDefinition);
            for (Class<? extends Annotation> et : EVENT_TYPES) {
                if (!eventListener.supports(entity, et)) continue;
                Collection eventListeners = listeners.computeIfAbsent(et, t -> new ArrayList(5));
                eventListeners.add(eventListener);
            }
        }
        this.beanEventHandlers.forEach((annotation, references) -> references.forEach(reference -> {
            if (this.isApplicableListener(entity, Arrays.asList(reference.getArguments()))) {
                Object bean = this.beanContext.getBean(reference.getBeanDefinition());
                Collection eventListeners = listeners.computeIfAbsent((Class)annotation, t -> new ArrayList(5));
                if (annotation == PrePersist.class) {
                    eventListeners.add(entity1 -> {
                        try {
                            reference.invoke(bean, new Object[]{entity1});
                        }
                        catch (Exception e) {
                            throw new PersistenceEventException("An error occurred invoking pre-persist event listener method [" + reference.getDescription(true) + "]: " + e.getMessage(), (Throwable)e);
                        }
                        return true;
                    });
                } else if (annotation == PreRemove.class) {
                    eventListeners.add(entity1 -> {
                        try {
                            reference.invoke(bean, new Object[]{entity1});
                        }
                        catch (Exception e) {
                            throw new PersistenceEventException("An error occurred invoking pre-remove event listener method [" + reference.getDescription(true) + "]: " + e.getMessage(), (Throwable)e);
                        }
                        return true;
                    });
                } else if (annotation == PreUpdate.class) {
                    eventListeners.add(entity1 -> {
                        try {
                            reference.invoke(bean, new Object[]{entity1});
                        }
                        catch (Exception e) {
                            throw new PersistenceEventException("An error occurred invoking pre-update event listener method [" + reference.getDescription(true) + "]: " + e.getMessage(), (Throwable)e);
                        }
                        return true;
                    });
                } else if (annotation == PostPersist.class) {
                    eventListeners.add(entity1 -> {
                        try {
                            reference.invoke(bean, new Object[]{entity1});
                        }
                        catch (Exception e) {
                            throw new PersistenceEventException("An error occurred invoking post-persist event listener method [" + reference.getDescription(true) + "]: " + e.getMessage(), (Throwable)e);
                        }
                    });
                } else if (annotation == PostRemove.class) {
                    eventListeners.add(entity1 -> {
                        try {
                            reference.invoke(bean, new Object[]{entity1});
                        }
                        catch (Exception e) {
                            throw new PersistenceEventException("An error occurred invoking post-remove event listener method [" + reference.getDescription(true) + "]: " + e.getMessage(), (Throwable)e);
                        }
                    });
                } else if (annotation == PostUpdate.class) {
                    eventListeners.add(entity1 -> {
                        try {
                            reference.invoke(bean, new Object[]{entity1});
                        }
                        catch (Exception e) {
                            throw new PersistenceEventException("An error occurred invoking post-update event listener method [" + reference.getDescription(true) + "]: " + e.getMessage(), (Throwable)e);
                        }
                    });
                }
            }
        }));
        Map<Class<Annotation>, Object> finalListeners = listeners.isEmpty() ? Collections.emptyMap() : listeners.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Collection v = (Collection)entry.getValue();
            if (v.isEmpty()) {
                return EntityEventListener.NOOP;
            }
            if (v.size() == 1) {
                return (EntityEventListener)v.iterator().next();
            }
            return new CompositeEventListener(v);
        }));
        return finalListeners;
    }

    private boolean isApplicableListener(RuntimePersistentEntity<Object> entity, List<Argument<?>> typeArguments) {
        return typeArguments.isEmpty() || typeArguments.getFirst().getType().isAssignableFrom(entity.getIntrospection().getBeanType());
    }

    public <B> void process(BeanDefinition<B> beanDefinition, ExecutableMethod<B, ?> method) {
        Argument[] arguments = method.getArguments();
        if (arguments.length == 1) {
            List eventTypes = method.getAnnotationTypesByStereotype(EntityEventMapping.class);
            for (Class eventType : eventTypes) {
                BeanDefinitionMethodReference ref = BeanDefinitionMethodReference.of(beanDefinition, method);
                this.beanEventHandlers.computeIfAbsent(eventType, t -> new ArrayList(5)).add(ref);
            }
        }
    }

    private static final class CompositeEventListener
    implements EntityEventListener<Object> {
        private final EntityEventListener<Object>[] listenerArray;

        public CompositeEventListener(Collection<EntityEventListener<Object>> listeners) {
            this.listenerArray = (EntityEventListener[])listeners.stream().sorted(OrderUtil.COMPARATOR).toArray(EntityEventListener[]::new);
        }

        public boolean supports(RuntimePersistentEntity<Object> entity, Class<? extends Annotation> eventType) {
            for (EntityEventListener<Object> listener : this.listenerArray) {
                if (!listener.supports(entity, eventType)) continue;
                return true;
            }
            return false;
        }

        public boolean prePersist(@NonNull EntityEventContext<Object> context) {
            for (EntityEventListener<Object> listener : this.listenerArray) {
                if (listener.prePersist(context)) continue;
                return false;
            }
            return true;
        }

        public void postPersist(@NonNull EntityEventContext<Object> context) {
            for (EntityEventListener<Object> listener : this.listenerArray) {
                listener.postPersist(context);
            }
        }

        public void postLoad(@NonNull EntityEventContext<Object> context) {
            for (EntityEventListener<Object> listener : this.listenerArray) {
                listener.postLoad(context);
            }
        }

        public boolean preRemove(@NonNull EntityEventContext<Object> context) {
            for (EntityEventListener<Object> listener : this.listenerArray) {
                if (listener.preRemove(context)) continue;
                return false;
            }
            return true;
        }

        public void postRemove(@NonNull EntityEventContext<Object> context) {
            for (EntityEventListener<Object> listener : this.listenerArray) {
                listener.postRemove(context);
            }
        }

        public boolean preUpdate(@NonNull EntityEventContext<Object> context) {
            for (EntityEventListener<Object> listener : this.listenerArray) {
                if (listener.preUpdate(context)) continue;
                return false;
            }
            return true;
        }

        public boolean preQuery(@NonNull QueryEventContext<Object> context) {
            for (EntityEventListener<Object> listener : this.listenerArray) {
                if (listener.preQuery(context)) continue;
                return false;
            }
            return true;
        }

        public void postUpdate(@NonNull EntityEventContext<Object> context) {
            for (EntityEventListener<Object> listener : this.listenerArray) {
                listener.postUpdate(context);
            }
        }
    }
}

