/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.ExpressionType;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.PersistentEntitySubquery;
import io.micronaut.data.model.jpa.criteria.impl.AbstractCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaQuery;
import io.micronaut.data.model.jpa.criteria.impl.expression.ClassExpressionType;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityRoot;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntitySubquery;
import io.micronaut.data.runtime.criteria.metamodel.StaticMetamodelInitializer;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.CriteriaBuilder;

@Internal
final class RuntimePersistentEntityCriteriaQuery<T>
extends AbstractPersistentEntityCriteriaQuery<T> {
    private final AbstractCriteriaBuilder criteriaBuilder;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final StaticMetamodelInitializer staticMetamodelInitializer;

    public RuntimePersistentEntityCriteriaQuery(AbstractCriteriaBuilder criteriaBuilder, StaticMetamodelInitializer staticMetamodelInitializer, Class<T> resultType, RuntimeEntityRegistry runtimeEntityRegistry) {
        super((ExpressionType)new ClassExpressionType(resultType), (CriteriaBuilder)criteriaBuilder);
        this.criteriaBuilder = criteriaBuilder;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.staticMetamodelInitializer = staticMetamodelInitializer;
    }

    public <X> PersistentEntityRoot<X> from(Class<X> entityClass) {
        return this.from(this.runtimeEntityRegistry.getEntity(entityClass));
    }

    public <X> PersistentEntityRoot<X> from(PersistentEntity persistentEntity) {
        return this.from((RuntimePersistentEntity)persistentEntity);
    }

    private <E> PersistentEntityRoot<E> from(RuntimePersistentEntity<E> runtimePersistentEntity) {
        RuntimePersistentEntityRoot<E> newEntityRoot;
        if (this.entityRoot != null) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.staticMetamodelInitializer.initializeMetadata(runtimePersistentEntity);
        this.entityRoot = newEntityRoot = new RuntimePersistentEntityRoot<E>(runtimePersistentEntity, (CriteriaBuilder)this.criteriaBuilder);
        return newEntityRoot;
    }

    public <U> PersistentEntitySubquery<U> subquery(ExpressionType<U> type) {
        return new RuntimePersistentEntitySubquery((AbstractQuery<?>)this, this.criteriaBuilder, this.staticMetamodelInitializer, type.getJavaType(), this.runtimeEntityRegistry);
    }
}

