/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.criteria;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.model.jpa.criteria.impl.AbstractCriteriaBuilder;
import io.micronaut.data.model.jpa.criteria.impl.AbstractPersistentEntityCriteriaDelete;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.criteria.RuntimePersistentEntityRoot;
import io.micronaut.data.runtime.criteria.metamodel.StaticMetamodelInitializer;
import jakarta.persistence.criteria.CriteriaBuilder;

@Internal
final class RuntimePersistentEntityCriteriaDelete<T>
extends AbstractPersistentEntityCriteriaDelete<T> {
    private final AbstractCriteriaBuilder criteriaBuilder;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private final StaticMetamodelInitializer staticMetamodelInitializer;

    public RuntimePersistentEntityCriteriaDelete(AbstractCriteriaBuilder criteriaBuilder, Class<T> root, RuntimeEntityRegistry runtimeEntityRegistry, StaticMetamodelInitializer staticMetamodelInitializer) {
        this.criteriaBuilder = criteriaBuilder;
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.staticMetamodelInitializer = staticMetamodelInitializer;
        this.from(root);
    }

    public PersistentEntityRoot<T> from(Class<T> entityClass) {
        return this.from(this.runtimeEntityRegistry.getEntity(entityClass));
    }

    public PersistentEntityRoot<T> from(PersistentEntity persistentEntity) {
        return this.from((RuntimePersistentEntity)persistentEntity);
    }

    private PersistentEntityRoot<T> from(RuntimePersistentEntity<T> runtimePersistentEntity) {
        RuntimePersistentEntityRoot<T> newEntityRoot;
        if (this.entityRoot != null && !this.entityRoot.getJavaType().equals(runtimePersistentEntity.getIntrospection().getBeanType())) {
            throw new IllegalStateException("The root entity is already specified!");
        }
        this.staticMetamodelInitializer.initializeMetadata(runtimePersistentEntity);
        this.entityRoot = newEntityRoot = new RuntimePersistentEntityRoot<T>(runtimePersistentEntity, (CriteriaBuilder)this.criteriaBuilder);
        return newEntityRoot;
    }
}

