/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.convert;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.type.Argument;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.inject.BeanDefinition;
import jakarta.data.event.LifecycleEvent;
import jakarta.data.event.PostDeleteEvent;
import jakarta.data.event.PostInsertEvent;
import jakarta.data.event.PostUpdateEvent;
import jakarta.data.event.PreDeleteEvent;
import jakarta.data.event.PreInsertEvent;
import jakarta.data.event.PreUpdateEvent;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Requires(classes={LifecycleEvent.class})
@Singleton
final class JakartaDataEntityEventListener
implements EntityEventListener<Object> {
    private final Map<Class<?>, EventListeners<?>> eventListeners;

    JakartaDataEntityEventListener(BeanContext beanContext) {
        HashMap eventListeners = new HashMap();
        for (BeanRegistration reg : beanContext.getBeanRegistrations(Argument.of(ApplicationEventListener.class, (Class[])new Class[]{LifecycleEvent.class}), null)) {
            Argument eventType;
            BeanDefinition definition = reg.definition();
            Optional firstTypeVariable = definition.getTypeArguments(ApplicationEventListener.class).stream().findFirst();
            if (firstTypeVariable.isEmpty() || (firstTypeVariable = (eventType = (Argument)firstTypeVariable.get()).getFirstTypeVariable()).isEmpty()) continue;
            Class beanType = ((Argument)firstTypeVariable.get()).getType();
            EventListeners listeners = eventListeners.computeIfAbsent(beanType, t -> new EventListeners());
            Class eventTypeClass = eventType.getType();
            ApplicationEventListener bean = (ApplicationEventListener)reg.getBean();
            if (eventTypeClass == PreInsertEvent.class) {
                listeners.preInsert.add(bean);
                continue;
            }
            if (eventTypeClass == PostInsertEvent.class) {
                listeners.postInsert.add(bean);
                continue;
            }
            if (eventTypeClass == PreUpdateEvent.class) {
                listeners.preUpdate.add(bean);
                continue;
            }
            if (eventTypeClass == PostUpdateEvent.class) {
                listeners.postUpdate.add(bean);
                continue;
            }
            if (eventTypeClass == PreDeleteEvent.class) {
                listeners.preDelete.add(bean);
                continue;
            }
            if (eventTypeClass == PostDeleteEvent.class) {
                listeners.postDelete.add(bean);
                continue;
            }
            throw new IllegalStateException("Unsupported event type: " + String.valueOf(eventTypeClass));
        }
        this.eventListeners = eventListeners;
    }

    public boolean supports(RuntimePersistentEntity<Object> entity, Class<? extends Annotation> eventType) {
        return this.eventListeners.containsKey(entity.getIntrospection().getBeanType());
    }

    public boolean prePersist(EntityEventContext<Object> context) {
        this.getListeners(context).preInsert.forEach(it -> it.onApplicationEvent((Object)new PreInsertEvent(context.getEntity())));
        return true;
    }

    public void postPersist(EntityEventContext<Object> context) {
        this.getListeners(context).postInsert.forEach(it -> it.onApplicationEvent((Object)new PostInsertEvent(context.getEntity())));
    }

    public boolean preRemove(EntityEventContext<Object> context) {
        this.getListeners(context).preDelete.forEach(it -> it.onApplicationEvent((Object)new PreDeleteEvent(context.getEntity())));
        return true;
    }

    public void postRemove(EntityEventContext<Object> context) {
        this.getListeners(context).postDelete.forEach(it -> it.onApplicationEvent((Object)new PostDeleteEvent(context.getEntity())));
    }

    public boolean preUpdate(EntityEventContext<Object> context) {
        this.getListeners(context).preUpdate.forEach(it -> it.onApplicationEvent((Object)new PreUpdateEvent(context.getEntity())));
        return true;
    }

    public void postUpdate(EntityEventContext<Object> context) {
        this.getListeners(context).postUpdate.forEach(it -> it.onApplicationEvent((Object)new PostUpdateEvent(context.getEntity())));
    }

    private <T> EventListeners<T> getListeners(EntityEventContext<T> context) {
        return this.eventListeners.get(context.getPersistentEntity().getIntrospection().getBeanType());
    }

    private record EventListeners<T>(List<ApplicationEventListener<PreInsertEvent<T>>> preInsert, List<ApplicationEventListener<PostInsertEvent<T>>> postInsert, List<ApplicationEventListener<PreUpdateEvent<T>>> preUpdate, List<ApplicationEventListener<PostUpdateEvent<T>>> postUpdate, List<ApplicationEventListener<PreDeleteEvent<T>>> preDelete, List<ApplicationEventListener<PostDeleteEvent<T>>> postDelete) {
        private EventListeners() {
            this(new ArrayList<ApplicationEventListener<PreInsertEvent<T>>>(), new ArrayList<ApplicationEventListener<PostInsertEvent<T>>>(), new ArrayList<ApplicationEventListener<PreUpdateEvent<T>>>(), new ArrayList<ApplicationEventListener<PostUpdateEvent<T>>>(), new ArrayList<ApplicationEventListener<PreDeleteEvent<T>>>(), new ArrayList<ApplicationEventListener<PostDeleteEvent<T>>>());
        }
    }
}

