/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.convert;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.MutableConversionService;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.data.model.CursoredPageable;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.jd.SpecificationConstraint;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.runtime.convert.JakartaDataConstraintConverter;
import io.micronaut.data.runtime.convert.JakartaDataRestrictionsConverter;
import io.micronaut.data.runtime.date.DateTimeProvider;
import jakarta.data.Order;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import jakarta.data.page.impl.CursoredPageRecord;
import jakarta.data.page.impl.PageRecord;
import jakarta.data.restrict.Restriction;
import java.util.Arrays;
import java.util.List;

@Requires(classes={Order.class})
@Prototype
@Internal
final class JakartaDataConverters
implements TypeConverterRegistrar {
    private final DateTimeProvider dateTimeProvider;

    JakartaDataConverters(DateTimeProvider dateTimeProvider) {
        this.dateTimeProvider = dateTimeProvider;
    }

    public void register(MutableConversionService conversionService) {
        conversionService.addConverter(Restriction.class, PredicateSpecification.class, new JakartaDataRestrictionsConverter(this.dateTimeProvider));
        conversionService.addConverter(SpecificationConstraint.class, PredicateSpecification.class, new JakartaDataConstraintConverter(this.dateTimeProvider));
        conversionService.addConverter(jakarta.data.Limit.class, Limit.class, limit -> Limit.of((int)limit.maxResults(), (long)((int)limit.startAt() - 1)));
        conversionService.addConverter(Order.class, Sort.class, order -> Sort.of(order.sorts().stream().map(sort -> new Sort.Order(sort.property(), sort.isAscending() ? Sort.Order.Direction.ASC : Sort.Order.Direction.DESC, sort.ignoreCase())).toList()));
        conversionService.addConverter(jakarta.data.Sort.class, Sort.class, sort -> Sort.of((Sort.Order[])new Sort.Order[]{new Sort.Order(sort.property(), sort.isAscending() ? Sort.Order.Direction.ASC : Sort.Order.Direction.DESC, sort.ignoreCase())}));
        conversionService.addConverter(jakarta.data.Sort[].class, Sort.class, sort -> Sort.of(Arrays.stream(sort).map(s -> new Sort.Order(s.property(), s.isAscending() ? Sort.Order.Direction.ASC : Sort.Order.Direction.DESC, s.ignoreCase())).toList()));
        conversionService.addConverter(PageRequest.class, Pageable.class, pageRequest -> {
            if (pageRequest.mode() == PageRequest.Mode.CURSOR_NEXT || pageRequest.mode() == PageRequest.Mode.CURSOR_PREVIOUS) {
                return CursoredPageable.from((int)((int)(pageRequest.page() - 1L)), (Pageable.Cursor)pageRequest.cursor().map(cursor -> Pageable.Cursor.of((List)cursor.elements())).orElse(null), (Pageable.Mode)(pageRequest.mode() == PageRequest.Mode.CURSOR_NEXT ? Pageable.Mode.CURSOR_NEXT : Pageable.Mode.CURSOR_PREVIOUS), (int)pageRequest.size(), null, (boolean)pageRequest.requestTotal());
            }
            Pageable pageable = Pageable.from((int)((int)(pageRequest.page() - 1L)), (int)pageRequest.size());
            pageable = pageRequest.requestTotal() ? pageable.withTotal() : pageable.withoutTotal();
            return pageable;
        });
        conversionService.addConverter(Pageable.class, PageRequest.class, JakartaDataConverters::convert);
        conversionService.addConverter(io.micronaut.data.model.Page.class, Page.class, page -> new PageRecord(JakartaDataConverters.convert(page.getPageable()), page.getContent(), page.getPageable().requestTotal() ? page.getTotalSize() : -1L));
        conversionService.addConverter(io.micronaut.data.model.CursoredPage.class, CursoredPage.class, page -> {
            io.micronaut.data.model.CursoredPage cursoredPage = page;
            return new CursoredPageRecord(cursoredPage.getContent(), cursoredPage.getCursors().stream().map(JakartaDataConverters::convertCursor).toList(), cursoredPage.hasTotalSize() ? cursoredPage.getTotalSize() : -1L, JakartaDataConverters.convert(cursoredPage.getPageable()), JakartaDataConverters.convert(cursoredPage.nextPageable()), JakartaDataConverters.convert(cursoredPage.previousPageable()));
        });
    }

    private static PageRequest.Cursor convertCursor(Pageable.Cursor c) {
        return PageRequest.Cursor.forKey((Object[])c.elements().toArray());
    }

    private static PageRequest convert(CursoredPageable pageable) {
        if (pageable == null) {
            return null;
        }
        PageRequest.Cursor cursor = pageable.cursor().map(JakartaDataConverters::convertCursor).orElse(null);
        if (cursor == null) {
            return null;
        }
        if (pageable.getMode().equals((Object)Pageable.Mode.CURSOR_NEXT)) {
            return PageRequest.afterCursor((PageRequest.Cursor)cursor, (long)(pageable.getNumber() + 1), (int)pageable.getSize(), (boolean)pageable.requestTotal());
        }
        if (pageable.getMode().equals((Object)Pageable.Mode.CURSOR_PREVIOUS)) {
            return PageRequest.beforeCursor((PageRequest.Cursor)cursor, (long)(pageable.getNumber() + 1), (int)pageable.getSize(), (boolean)pageable.requestTotal());
        }
        throw new IllegalArgumentException("Unknown mode " + String.valueOf(pageable.getMode()));
    }

    private static PageRequest convert(Pageable pageable) {
        if (pageable == null) {
            return null;
        }
        return PageRequest.ofPage((long)(pageable.getNumber() + 1), (int)(pageable.getSize() == -1 ? Integer.MAX_VALUE : pageable.getSize()), (boolean)pageable.requestTotal());
    }
}

