/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.convert;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.type.Argument;
import io.micronaut.data.model.jd.SpecificationConstraint;
import io.micronaut.data.model.jpa.criteria.PersistentEntityRoot;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.runtime.convert.JakartaDataRestrictionsConverter;
import io.micronaut.data.runtime.date.DateTimeProvider;
import jakarta.data.constraint.AtLeast;
import jakarta.data.constraint.AtMost;
import jakarta.data.constraint.Constraint;
import jakarta.data.constraint.EqualTo;
import jakarta.data.constraint.GreaterThan;
import jakarta.data.constraint.In;
import jakarta.data.constraint.LessThan;
import jakarta.data.constraint.Like;
import jakarta.data.constraint.NotEqualTo;
import jakarta.data.constraint.NotIn;
import jakarta.data.constraint.NotLike;
import jakarta.data.repository.By;
import jakarta.data.repository.Is;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Optional;

@Internal
final class JakartaDataConstraintConverter<E>
implements TypeConverter<SpecificationConstraint, PredicateSpecification<E>> {
    private final DateTimeProvider<OffsetDateTime> dateTimeProvider;

    JakartaDataConstraintConverter(DateTimeProvider<OffsetDateTime> dateTimeProvider) {
        this.dateTimeProvider = dateTimeProvider;
    }

    public Optional<PredicateSpecification<E>> convert(final SpecificationConstraint jakartaDataConstraint, Class<PredicateSpecification<E>> targetType, ConversionContext context) {
        final Argument argument = jakartaDataConstraint.argument();
        final AnnotationValue isAnnotation = argument.getAnnotationMetadata().getAnnotation(Is.class);
        if (isAnnotation != null) {
            return Optional.of(new PredicateSpecification<E>(this){
                final /* synthetic */ JakartaDataConstraintConverter this$0;
                {
                    this.this$0 = this$0;
                }

                public Predicate toPredicate(Root<E> root, CriteriaBuilder criteriaBuilder) {
                    Class<EqualTo> constraint = isAnnotation.classValue().orElse(EqualTo.class);
                    Expression path = this.this$0.getExpression(root, argument);
                    Object value = jakartaDataConstraint.value();
                    if (constraint == AtLeast.class) {
                        Expression expression = path;
                        Comparable comparable = (Comparable)value;
                        return criteriaBuilder.greaterThanOrEqualTo(expression, comparable);
                    }
                    if (constraint == GreaterThan.class) {
                        Expression expression = path;
                        Comparable comparable = (Comparable)value;
                        return criteriaBuilder.greaterThan(expression, comparable);
                    }
                    if (constraint == AtMost.class) {
                        Expression expression = path;
                        Comparable comparable = (Comparable)value;
                        return criteriaBuilder.lessThanOrEqualTo(expression, comparable);
                    }
                    if (constraint == LessThan.class) {
                        Expression expression = path;
                        Comparable comparable = (Comparable)value;
                        return criteriaBuilder.lessThan(expression, comparable);
                    }
                    if (constraint == EqualTo.class) {
                        return criteriaBuilder.equal(path, value);
                    }
                    if (constraint == NotEqualTo.class) {
                        return criteriaBuilder.notEqual(path, value);
                    }
                    if (constraint == In.class) {
                        return this.in(value, path);
                    }
                    if (constraint == NotIn.class) {
                        return this.in(value, path).not();
                    }
                    if (constraint == Like.class) {
                        return criteriaBuilder.like(path, (String)value);
                    }
                    if (constraint == NotLike.class) {
                        return criteriaBuilder.notLike(path, (String)value);
                    }
                    throw new IllegalArgumentException("Unknown constraint [" + String.valueOf(constraint) + "]");
                }

                private Predicate in(Object value, Expression<?> path) {
                    if (value instanceof Collection) {
                        Collection collection = (Collection)value;
                        return path.in(collection);
                    }
                    if (value instanceof Object[]) {
                        Object[] array = (Object[])value;
                        return path.in(array);
                    }
                    return path.in(new Object[]{value});
                }
            });
        }
        Object object = jakartaDataConstraint.value();
        if (object instanceof Constraint) {
            final Constraint constraint = (Constraint)object;
            return Optional.of(new PredicateSpecification<E>(this){
                private final JakartaDataRestrictionsConverter<E> converter;
                final /* synthetic */ JakartaDataConstraintConverter this$0;
                {
                    this.this$0 = this$0;
                    this.converter = new JakartaDataRestrictionsConverter(this.this$0.dateTimeProvider);
                }

                public Predicate toPredicate(Root<E> root, CriteriaBuilder criteriaBuilder) {
                    return this.converter.toPredicate(root, criteriaBuilder, constraint, this.this$0.getExpression(root, argument));
                }
            });
        }
        return Optional.empty();
    }

    private <V> Expression<V> getExpression(Root<E> root, Argument<?> argument) {
        String propertyName = argument.getAnnotationMetadata().stringValue(By.class).or(() -> argument.getAnnotationMetadata().stringValue(io.micronaut.data.annotation.By.class)).orElse(argument.getName());
        if (propertyName.equals("id(this)")) {
            return ((PersistentEntityRoot)root).id();
        }
        return root.get(propertyName);
    }
}

