/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.operations.internal.AbstractCascadeOperations;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class SyncCascadeOperations<Ctx extends OperationContext>
extends AbstractCascadeOperations {
    private static final Logger LOG = LoggerFactory.getLogger(SyncCascadeOperations.class);
    private final SyncCascadeOperationsHelper<Ctx> helper;

    public SyncCascadeOperations(ConversionService conversionService, SyncCascadeOperationsHelper<Ctx> helper) {
        super(conversionService);
        this.helper = helper;
    }

    public <T> T cascadeEntity(Ctx ctx, T entity, RuntimePersistentEntity<T> persistentEntity, boolean isPost, Relation.Cascade cascadeType) {
        ArrayList<AbstractCascadeOperations.CascadeOp> cascadeOps = new ArrayList<AbstractCascadeOperations.CascadeOp>();
        this.cascade(((OperationContext)ctx).annotationMetadata, ((OperationContext)ctx).repositoryType, isPost, cascadeType, AbstractCascadeOperations.CascadeContext.of(((OperationContext)ctx).associations, entity, persistentEntity), persistentEntity, entity, cascadeOps);
        for (AbstractCascadeOperations.CascadeOp cascadeOp : cascadeOps) {
            RuntimeAssociation association;
            List<Object> entities;
            RuntimePersistentEntity childPersistentEntity;
            if (cascadeOp instanceof AbstractCascadeOperations.CascadeOneOp) {
                boolean hasId;
                AbstractCascadeOperations.CascadeOneOp cascadeOneOp = (AbstractCascadeOperations.CascadeOneOp)cascadeOp;
                childPersistentEntity = cascadeOp.childPersistentEntity;
                Object child = cascadeOneOp.child;
                if (((OperationContext)ctx).persisted.contains(child)) continue;
                RuntimePersistentProperty identity = childPersistentEntity.getIdentity();
                boolean bl = hasId = identity.getProperty().get(child) != null;
                if (cascadeType == Relation.Cascade.PERSIST && SyncCascadeOperations.shouldPersistChildOnPersist((RuntimePersistentEntity<Object>)childPersistentEntity, child)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), cascadeOp.ctx.associations);
                    }
                    Object persisted = this.helper.persistOne(ctx, child, childPersistentEntity);
                    entity = this.afterCascadedOne(entity, cascadeOp.ctx.associations, child, persisted);
                    child = persisted;
                } else if (hasId && cascadeType == Relation.Cascade.UPDATE) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading MERGE for '{}' ({}) association: '{}'", new Object[]{persistentEntity.getName(), persistentEntity.getIdentity().getProperty().get(entity), cascadeOp.ctx.associations});
                    }
                    Object updated = this.helper.updateOne(ctx, child, childPersistentEntity);
                    entity = this.afterCascadedOne(entity, cascadeOp.ctx.associations, child, updated);
                    child = updated;
                }
                RuntimeAssociation association2 = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
                if (!hasId && (cascadeType == Relation.Cascade.PERSIST || cascadeType == Relation.Cascade.UPDATE) && SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association2)) {
                    this.helper.persistManyAssociation(ctx, association2, entity, persistentEntity, child, (RuntimePersistentEntity<Object>)childPersistentEntity);
                }
                ((OperationContext)ctx).persisted.add(child);
                continue;
            }
            if (!(cascadeOp instanceof AbstractCascadeOperations.CascadeManyOp)) continue;
            AbstractCascadeOperations.CascadeManyOp cascadeManyOp = (AbstractCascadeOperations.CascadeManyOp)cascadeOp;
            childPersistentEntity = cascadeManyOp.childPersistentEntity;
            if (cascadeType == Relation.Cascade.UPDATE) {
                entities = CollectionUtils.iterableToList(cascadeManyOp.children);
                iterator = entities.listIterator();
                while (iterator.hasNext()) {
                    Object child = iterator.next();
                    if (((OperationContext)ctx).persisted.contains(child)) continue;
                    identity = childPersistentEntity.getIdentity();
                    Object value = identity.getProperty().get(child) == null ? this.helper.persistOne(ctx, child, childPersistentEntity) : this.helper.updateOne(ctx, child, childPersistentEntity);
                    iterator.set(value);
                }
            } else {
                if (cascadeType != Relation.Cascade.PERSIST) continue;
                if (this.helper.isSupportsBatchInsert(ctx, childPersistentEntity)) {
                    association = (RuntimeAssociation)cascadeManyOp.ctx.getAssociation();
                    Predicate<Object> veto = SyncCascadeOperations.batchPersistVeto((RuntimePersistentEntity<Object>)childPersistentEntity, (RuntimeAssociation<Object>)association, ((OperationContext)ctx).persisted);
                    Iterable<Object> sourceChildren = SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association) ? SyncCascadeOperations.deduplicateSourceForJoinBatch((RuntimePersistentEntity<Object>)childPersistentEntity, cascadeManyOp.children) : cascadeManyOp.children;
                    entities = this.helper.persistBatch(ctx, sourceChildren, childPersistentEntity, veto);
                } else {
                    entities = CollectionUtils.iterableToList(cascadeManyOp.children);
                    iterator = entities.listIterator();
                    while (iterator.hasNext()) {
                        Object child = iterator.next();
                        if (((OperationContext)ctx).persisted.contains(child) || (identity = childPersistentEntity.getIdentity()).getProperty().get(child) != null) continue;
                        Object persisted = this.helper.persistOne(ctx, child, childPersistentEntity);
                        iterator.set(persisted);
                    }
                }
            }
            entity = this.afterCascadedMany(entity, cascadeOp.ctx.associations, cascadeManyOp.children, entities);
            association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
            if (SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association) && !CollectionUtils.iterableToList(cascadeManyOp.children).isEmpty()) {
                if (this.helper.isSupportsBatchInsert(ctx, childPersistentEntity)) {
                    List<Object> union = SyncCascadeOperations.uniqueByIdForJoin((RuntimePersistentEntity<Object>)childPersistentEntity, cascadeManyOp.children, entities);
                    if (!union.isEmpty()) {
                        this.helper.persistManyAssociationBatch(ctx, association, cascadeOp.ctx.parent, cascadeOp.ctx.parentPersistentEntity, union, (RuntimePersistentEntity<Object>)childPersistentEntity);
                    }
                } else {
                    for (Object e : cascadeManyOp.children) {
                        if (((OperationContext)ctx).persisted.contains(e)) continue;
                        this.helper.persistManyAssociation(ctx, association, cascadeOp.ctx.parent, cascadeOp.ctx.parentPersistentEntity, e, (RuntimePersistentEntity<Object>)childPersistentEntity);
                    }
                }
            }
            ((OperationContext)ctx).persisted.addAll((Collection<Object>)entities);
        }
        return entity;
    }

    public static interface SyncCascadeOperationsHelper<Ctx extends OperationContext> {
        default public boolean isSupportsBatchInsert(Ctx ctx, RuntimePersistentEntity<?> persistentEntity) {
            return true;
        }

        default public boolean isSupportsBatchUpdate(Ctx ctx, RuntimePersistentEntity<?> persistentEntity) {
            return true;
        }

        default public boolean isSupportsBatchDelete(Ctx ctx, RuntimePersistentEntity<?> persistentEntity) {
            return true;
        }

        public <T> T persistOne(Ctx var1, T var2, RuntimePersistentEntity<T> var3);

        public <T> List<T> persistBatch(Ctx var1, Iterable<T> var2, RuntimePersistentEntity<T> var3, Predicate<T> var4);

        public <T> T updateOne(Ctx var1, T var2, RuntimePersistentEntity<T> var3);

        public void persistManyAssociation(Ctx var1, RuntimeAssociation var2, Object var3, RuntimePersistentEntity<Object> var4, Object var5, RuntimePersistentEntity<Object> var6);

        public void persistManyAssociationBatch(Ctx var1, RuntimeAssociation var2, Object var3, RuntimePersistentEntity<Object> var4, Iterable<Object> var5, RuntimePersistentEntity<Object> var6);
    }
}

