/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event.listeners;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.DateCreated;
import io.micronaut.data.annotation.DateUpdated;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.annotation.event.PreUpdate;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.model.runtime.PropertyAutoPopulator;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.event.listeners.AutoPopulateUtil;
import io.micronaut.data.runtime.event.listeners.AutoPopulatedEntityEventListener;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

@Singleton
public class AutoTimestampEntityEventListener
extends AutoPopulatedEntityEventListener
implements PropertyAutoPopulator<DateUpdated> {
    private final DateTimeProvider<?> dateTimeProvider;
    private final DataConversionService conversionService;

    public AutoTimestampEntityEventListener(DateTimeProvider<?> dateTimeProvider, DataConversionService conversionService) {
        this.dateTimeProvider = dateTimeProvider;
        this.conversionService = conversionService;
    }

    @Override
    @NonNull
    protected List<Class<? extends Annotation>> getEventTypes() {
        return Arrays.asList(PrePersist.class, PreUpdate.class);
    }

    @Override
    @NonNull
    protected Predicate<RuntimePersistentProperty<Object>> getPropertyPredicate() {
        return prop -> {
            AnnotationMetadata annotationMetadata = prop.getAnnotationMetadata();
            return annotationMetadata.hasAnnotation(DateCreated.class) || annotationMetadata.hasAnnotation(DateUpdated.class);
        };
    }

    public boolean prePersist(@NonNull EntityEventContext<Object> context) {
        this.autoTimestampIfNecessary(context, false);
        return true;
    }

    public boolean preUpdate(@NonNull EntityEventContext<Object> context) {
        this.autoTimestampIfNecessary(context, true);
        return true;
    }

    @NonNull
    public Object populate(RuntimePersistentProperty<?> property, @Nullable Object previousValue) {
        Object now = this.dateTimeProvider.getNow();
        ChronoUnit truncateToValue = this.truncateToDateUpdated(property.getAnnotationMetadata());
        now = this.truncate(now, truncateToValue);
        return this.conversionService.convertRequired(now, property.getArgument());
    }

    private Object truncate(Object now, ChronoUnit truncateToValue) {
        if (truncateToValue != null) {
            if (now instanceof OffsetDateTime) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)now;
                now = offsetDateTime.truncatedTo(truncateToValue);
            } else {
                now = ((Instant)this.conversionService.convertRequired(now, Instant.class)).truncatedTo(truncateToValue);
            }
        }
        return now;
    }

    private Object computePropertyNow(@NonNull AnnotationMetadata annotationMetadata, boolean isUpdate, Object now) {
        ChronoUnit truncateToValue;
        if (isUpdate) {
            truncateToValue = this.truncateToDateUpdated(annotationMetadata);
        } else {
            truncateToValue = this.truncateToDateCreated(annotationMetadata);
            if (truncateToValue == null) {
                truncateToValue = this.truncateToDateUpdated(annotationMetadata);
            }
        }
        return this.truncate(now, truncateToValue);
    }

    @Nullable
    private Object convertIfNeeded(@NonNull Object value, @NonNull Class<?> targetType) {
        if (targetType.isInstance(value)) {
            return value;
        }
        return this.conversionService.convert(value, targetType).orElse(null);
    }

    private void autoTimestampIfNecessary(@NonNull EntityEventContext<Object> context, boolean isUpdate) {
        RuntimePersistentProperty<Object>[] applicableProperties = this.getApplicableProperties(context);
        Object now = this.dateTimeProvider.getNow();
        AutoPopulateUtil.applyTopLevel(context, applicableProperties, prop -> {
            if (isUpdate && !prop.getAnnotationMetadata().booleanValue(AutoPopulated.class, "updatable").orElse(true).booleanValue()) {
                return null;
            }
            Object propertyNow = this.computePropertyNow(prop.getAnnotationMetadata(), isUpdate, now);
            return this.convertIfNeeded(propertyNow, prop.getType());
        });
        AutoPopulateUtil.applyEmbedded(context, (embeddedPersistentProperty, current) -> {
            AnnotationMetadata am = embeddedPersistentProperty.getAnnotationMetadata();
            boolean hasDateCreated = am.hasAnnotation(DateCreated.class);
            boolean hasDateUpdated = am.hasAnnotation(DateUpdated.class);
            if (!hasDateCreated && !hasDateUpdated) {
                return current;
            }
            if (isUpdate && !am.booleanValue(AutoPopulated.class, "updatable").orElse(true).booleanValue()) {
                return current;
            }
            Object propertyNow = this.computePropertyNow(am, isUpdate, now);
            Class propertyType = embeddedPersistentProperty.getType();
            Object newValue = this.convertIfNeeded(propertyNow, propertyType);
            BeanProperty prop = embeddedPersistentProperty.getProperty();
            if (!prop.hasSetterOrConstructorArgument()) {
                return current;
            }
            if (prop.isReadOnly()) {
                return prop.withValue(current, newValue);
            }
            prop.set(current, newValue);
            return current;
        });
    }

    @Nullable
    private ChronoUnit truncateToDateCreated(@NonNull AnnotationMetadata annotationMetadata) {
        return annotationMetadata.enumValue(DateCreated.class, "truncatedTo", ChronoUnit.class).filter(cu -> cu != ChronoUnit.FOREVER).orElse(null);
    }

    @Nullable
    private ChronoUnit truncateToDateUpdated(@NonNull AnnotationMetadata annotationMetadata) {
        return annotationMetadata.enumValue(DateUpdated.class, "truncatedTo", ChronoUnit.class).filter(cu -> cu != ChronoUnit.FOREVER).orElse(null);
    }
}

