/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.query.internal;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.CursoredPage;
import io.micronaut.data.model.CursoredPageable;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.runtime.DefaultStoredDataOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
public final class DefaultPreparedQuery<E, RT>
extends DefaultStoredDataOperation<RT>
implements DelegateStoredQuery<E, RT>,
PreparedQuery<E, RT> {
    private static final String DATA_METHOD_ANN_NAME = DataMethod.class.getName();
    private final Pageable pageable;
    private final StoredQuery<E, RT> storedQuery;
    private final String query;
    private final boolean dto;
    private final MethodInvocationContext<?, ?> context;
    private final ConversionService conversionService;
    @Nullable
    private final Limit limit;

    public DefaultPreparedQuery(MethodInvocationContext<?, ?> context, StoredQuery<E, RT> storedQuery, String finalQuery, @NonNull Pageable pageable, @NonNull Limit limit, boolean dtoProjection, ConversionService conversionService) {
        super(context);
        this.context = context;
        this.query = finalQuery;
        this.storedQuery = storedQuery;
        this.dto = dtoProjection;
        this.conversionService = conversionService;
        if (pageable.getMode() == Pageable.Mode.OFFSET && DefaultPreparedQuery.hasReturnTypeInRole("cursoredPage", CursoredPage.class, context, conversionService)) {
            if (pageable.getNumber() == 0) {
                pageable = CursoredPageable.from((int)pageable.getSize(), (Sort)pageable.getSort());
            } else {
                throw new IllegalArgumentException("Cursored page with the offset mode page request needs to start from the first page number: 0, but was: " + pageable.getNumber());
            }
        }
        this.pageable = pageable.withSort(storedQuery.getSort().orders(pageable.getOrderBy()));
        this.limit = Limit.UNLIMITED.equals(limit) && !storedQuery.isCount() ? Limit.of((int)pageable.getSize(), (long)pageable.getOffset()) : limit;
    }

    public static boolean hasReturnTypeInRole(@NonNull String role, @NonNull Class<?> type, @NonNull MethodInvocationContext<?, ?> methodContext, @NonNull ConversionService conversionService) {
        return methodContext.stringValue(DATA_METHOD_ANN_NAME, "returnTypeRole").filter(typeRole -> typeRole.equals(role)).map(ignore -> conversionService.canConvert(methodContext.getReturnType().getType(), type)).orElse(false);
    }

    @NonNull
    public static <RT1> Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Class<RT1> type, @NonNull MethodInvocationContext<?, ?> methodContext, @NonNull ConversionService conversionService) {
        return methodContext.stringValue(DATA_METHOD_ANN_NAME, role).flatMap(name -> {
            MutableArgumentValue arg = (MutableArgumentValue)methodContext.getParameters().get(name);
            if (arg == null) {
                return Optional.empty();
            }
            Object o = arg.getValue();
            if (o == null) {
                return Optional.empty();
            }
            if (type.isInstance(o)) {
                return Optional.of(o);
            }
            return conversionService.convert(o, type);
        });
    }

    @NonNull
    public static <RT1> List<RT1> getParametersInRole(@NonNull String role, @NonNull Class<RT1> type, @NonNull MethodInvocationContext<?, ?> methodContext, @NonNull ConversionService conversionService) {
        AnnotationValue annotation = methodContext.getAnnotation(DATA_METHOD_ANN_NAME);
        if (annotation == null) {
            return List.of();
        }
        List roles = annotation.getAnnotations("parametersTypeRoles");
        return roles.stream().filter(a -> ((String)a.stringValue().orElseThrow()).equals(role)).flatMap(a -> {
            Object value = methodContext.getParameterValues()[a.intValue("parameterIndex").orElseThrow()];
            if (value == null) {
                return Stream.empty();
            }
            if (type.isInstance(value)) {
                return Stream.of(value);
            }
            return conversionService.convert(value, type).stream();
        }).toList();
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public MethodInvocationContext<?, ?> getContext() {
        return this.context;
    }

    @Override
    public Class<E> getRootEntity() {
        return this.storedQuery.getRootEntity();
    }

    @Override
    public Map<String, Object> getQueryHints() {
        return this.storedQuery.getQueryHints();
    }

    @Override
    public boolean isRawQuery() {
        return this.storedQuery.isRawQuery();
    }

    @Override
    public StoredQuery<E, RT> getStoredQueryDelegate() {
        return this.storedQuery;
    }

    public <RT1> Optional<RT1> getParameterInRole(@NonNull String role, @NonNull Class<RT1> type) {
        return DefaultPreparedQuery.getParameterInRole(role, type, this.context, this.conversionService);
    }

    public <RT1> List<RT1> getParametersInRole(String role, Class<RT1> type) {
        return DefaultPreparedQuery.getParametersInRole(role, type, this.context, this.conversionService);
    }

    public Class<?> getRepositoryType() {
        return this.context.getTarget().getClass();
    }

    public Object[] getParameterArray() {
        return this.context.getParameterValues();
    }

    public Argument[] getArguments() {
        return this.context.getArguments();
    }

    @NonNull
    public Pageable getPageable() {
        if (this.storedQuery.isCount()) {
            return Pageable.UNPAGED;
        }
        return this.pageable;
    }

    @Override
    public boolean isDtoProjection() {
        return this.dto;
    }

    @Override
    @NonNull
    public String getQuery() {
        return this.query;
    }

    @NonNull
    public ConvertibleValues<Object> getAttributes() {
        return this.context.getAttributes();
    }

    @NonNull
    public Optional<Object> getAttribute(CharSequence name) {
        return this.context.getAttribute(name);
    }

    @NonNull
    public <T> Optional<T> getAttribute(CharSequence name, Class<T> type) {
        return this.context.getAttribute(name, type);
    }

    @Override
    public int getOffset() {
        if (this.limit != null) {
            return (int)this.limit.offset();
        }
        return DelegateStoredQuery.super.getOffset();
    }

    @Override
    public int getLimit() {
        if (this.limit != null) {
            return this.limit.maxResults();
        }
        return DelegateStoredQuery.super.getLimit();
    }

    @Override
    public Sort getSort() {
        return this.pageable.getSort();
    }

    @Override
    public Limit getQueryLimit() {
        if (this.limit != null) {
            return this.limit;
        }
        return this.pageable.getLimit();
    }
}

