/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper.sql;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.Embeddable;
import io.micronaut.data.annotation.EmbeddedId;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.TypeDef;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.NonUniqueResultException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.convert.AttributeConverter;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.mapper.sql.SqlJsonColumnReader;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import java.sql.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiFunction;

@Internal
public final class SqlResultEntityTypeMapper<RS, R>
implements SqlTypeMapper<RS, R> {
    private final RuntimePersistentEntity<R> entity;
    private final ResultReader<RS, String> resultReader;
    private final Map<String, JoinPath> fetchJoinPaths;
    private final boolean hasJoins;
    private final String startingPrefix;
    private final SqlJsonColumnReader<RS> jsonColumnReader;
    private final DataConversionService conversionService;
    private final BiFunction<RuntimePersistentEntity<Object>, Object, Object> eventListener;
    private boolean callNext = true;

    public SqlResultEntityTypeMapper(String prefix, @NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable SqlJsonColumnReader<RS> jsonColumnReader, DataConversionService conversionService) {
        this(entity, resultReader, Collections.emptySet(), prefix, jsonColumnReader, conversionService, null);
    }

    public SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths, @Nullable SqlJsonColumnReader<RS> jsonColumnReader, DataConversionService conversionService) {
        this(entity, resultReader, joinPaths, null, jsonColumnReader, conversionService, null);
    }

    public SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths, @Nullable SqlJsonColumnReader<RS> jsonColumnReader, @Nullable BiFunction<RuntimePersistentEntity<Object>, Object, Object> loadListener, DataConversionService conversionService) {
        this(entity, resultReader, joinPaths, null, jsonColumnReader, conversionService, loadListener);
    }

    private SqlResultEntityTypeMapper(@NonNull RuntimePersistentEntity<R> entity, @NonNull ResultReader<RS, String> resultReader, @Nullable Set<JoinPath> joinPaths, String startingPrefix, @Nullable SqlJsonColumnReader<RS> jsonColumnReader, DataConversionService conversionService, @Nullable BiFunction<RuntimePersistentEntity<Object>, Object, Object> eventListener) {
        this.conversionService = conversionService;
        ArgumentUtils.requireNonNull((String)"entity", entity);
        ArgumentUtils.requireNonNull((String)"resultReader", resultReader);
        this.entity = entity;
        this.jsonColumnReader = jsonColumnReader;
        this.resultReader = resultReader;
        this.eventListener = eventListener;
        if (CollectionUtils.isNotEmpty(joinPaths)) {
            this.hasJoins = true;
            this.fetchJoinPaths = CollectionUtils.newLinkedHashMap((int)joinPaths.size());
            for (JoinPath joinPath : joinPaths) {
                if (!joinPath.getJoinType().isFetch()) continue;
                this.fetchJoinPaths.put(joinPath.getPath(), joinPath);
            }
        } else {
            this.fetchJoinPaths = Collections.emptyMap();
            this.hasJoins = false;
        }
        this.startingPrefix = startingPrefix;
    }

    @Override
    public DataConversionService getConversionService() {
        return this.conversionService;
    }

    @NonNull
    public RuntimePersistentEntity<R> getEntity() {
        return this.entity;
    }

    @NonNull
    public ResultReader<RS, String> getResultReader() {
        return this.resultReader;
    }

    @Override
    @NonNull
    public R map(@NonNull RS rs, @NonNull Class<R> type) throws DataAccessException {
        return this.readEntity(rs);
    }

    @NonNull
    public R readEntity(@NonNull RS rs) {
        R entityInstance = this.readEntity(rs, MappingContext.of(this.entity, this.startingPrefix), null, null);
        if (entityInstance == null) {
            throw new DataAccessException("Unable to map result to entity of type [" + String.valueOf(this.entity.getIntrospection().getBeanType()) + "]. Missing result data.");
        }
        return this.triggerPostLoad(this.entity, entityInstance);
    }

    @Override
    @Nullable
    public Object read(@NonNull RS resultSet, @NonNull String name) {
        RuntimePersistentProperty property = this.entity.getPropertyByName(name);
        if (property == null) {
            throw new DataAccessException("DTO projection defines a property [" + name + "] that doesn't exist on root entity: " + this.entity.getName());
        }
        DataType dataType = property.getDataType();
        String columnName = property.getPersistedName();
        return this.resultReader.readDynamic(resultSet, columnName, dataType);
    }

    @Override
    @Nullable
    public Object read(@NonNull RS resultSet, @NonNull Argument<?> argument) {
        String columnName;
        DataType dataType;
        String name = argument.getName();
        RuntimePersistentProperty property = this.entity.getPropertyByName(name);
        if (property == null) {
            dataType = argument.getAnnotationMetadata().enumValue(TypeDef.class, "type", DataType.class).orElseGet(() -> DataType.forType((Class)argument.getType()));
            columnName = argument.getName();
        } else {
            dataType = property.getDataType();
            columnName = property.getPersistedName();
        }
        return this.resultReader.readDynamic(resultSet, columnName, dataType);
    }

    @Override
    public boolean hasNext(RS resultSet) {
        if (this.callNext) {
            return this.resultReader.next(resultSet);
        }
        this.callNext = true;
        return true;
    }

    public PushingMapper<RS, R> readOneMapper() {
        if (this.hasJoins) {
            return new PushingMapper<RS, R>(){
                final MappingContext<R> ctx;
                Object entityId;
                R entityInstance;
                {
                    this.ctx = MappingContext.of(SqlResultEntityTypeMapper.this.entity, SqlResultEntityTypeMapper.this.startingPrefix);
                }

                @Override
                public void processRow(RS row) {
                    Object id = SqlResultEntityTypeMapper.this.readEntityId(row, this.ctx);
                    if (id == null) {
                        throw new IllegalStateException("Entity needs to have an ID when JOINs are used!");
                    }
                    if (this.entityId == null) {
                        this.entityId = id;
                        this.entityInstance = SqlResultEntityTypeMapper.this.readEntity(row, this.ctx, null, null);
                    } else if (this.entityId.equals(id)) {
                        SqlResultEntityTypeMapper.this.readChildren(row, this.entityInstance, null, this.ctx);
                    }
                }

                @Override
                public R getResult() {
                    if (this.entityInstance == null) {
                        return null;
                    }
                    if (!SqlResultEntityTypeMapper.this.fetchJoinPaths.isEmpty()) {
                        return SqlResultEntityTypeMapper.this.setChildrenAndTriggerPostLoad(this.entityInstance, this.ctx, null);
                    }
                    return SqlResultEntityTypeMapper.this.triggerPostLoad(SqlResultEntityTypeMapper.this.entity, this.entityInstance);
                }
            };
        }
        return new PushingMapper<RS, R>(){
            final MappingContext<R> ctx;
            R entityInstance;
            {
                this.ctx = MappingContext.of(SqlResultEntityTypeMapper.this.entity, SqlResultEntityTypeMapper.this.startingPrefix);
            }

            @Override
            public void processRow(RS row) {
                if (this.entityInstance != null) {
                    throw new NonUniqueResultException();
                }
                this.entityInstance = SqlResultEntityTypeMapper.this.readEntity(row, this.ctx, null, null);
            }

            @Override
            public R getResult() {
                if (this.entityInstance == null) {
                    return null;
                }
                return SqlResultEntityTypeMapper.this.triggerPostLoad(SqlResultEntityTypeMapper.this.entity, this.entityInstance);
            }
        };
    }

    public PushingMapper<RS, List<R>> readManyMapper() {
        if (this.hasJoins) {
            return new PushingMapper<RS, List<R>>(){
                final Map<Object, MappingContext<R>> idEntities = CollectionUtils.newLinkedHashMap((int)20);
                final List<MappingContext<R>> allProcessed = new ArrayList(20);

                @Override
                public void processRow(RS row) {
                    MappingContext ctx = MappingContext.of(SqlResultEntityTypeMapper.this.entity, SqlResultEntityTypeMapper.this.startingPrefix);
                    Object id = SqlResultEntityTypeMapper.this.readEntityId(row, ctx);
                    if (id == null) {
                        throw new IllegalStateException("Entity needs to have an ID when JOINs are used!");
                    }
                    MappingContext prevCtx = this.idEntities.get(id);
                    if (prevCtx != null) {
                        SqlResultEntityTypeMapper.this.readChildren(row, prevCtx.entity, null, prevCtx);
                    } else {
                        ctx.entity = SqlResultEntityTypeMapper.this.readEntity(row, ctx, null, id);
                        this.idEntities.put(id, ctx);
                        this.allProcessed.add(ctx);
                    }
                }

                @Override
                public List<R> getResult() {
                    ArrayList<Object> values = new ArrayList<Object>(this.allProcessed.size());
                    boolean hasFetchJoins = !SqlResultEntityTypeMapper.this.fetchJoinPaths.isEmpty();
                    for (MappingContext ctx : this.allProcessed) {
                        if (hasFetchJoins) {
                            values.add(SqlResultEntityTypeMapper.this.setChildrenAndTriggerPostLoad(ctx.entity, ctx, null));
                            continue;
                        }
                        values.add(SqlResultEntityTypeMapper.this.triggerPostLoad(ctx.persistentEntity, ctx.entity));
                    }
                    return values;
                }
            };
        }
        return new PushingMapper<RS, List<R>>(){
            final List<R> allProcessed = new ArrayList(20);
            final MappingContext<R> ctx;
            {
                this.ctx = MappingContext.of(SqlResultEntityTypeMapper.this.entity, SqlResultEntityTypeMapper.this.startingPrefix);
            }

            @Override
            public void processRow(RS row) {
                this.allProcessed.add(SqlResultEntityTypeMapper.this.readEntity(row, this.ctx, null, null));
            }

            @Override
            public List<R> getResult() {
                ListIterator iterator = this.allProcessed.listIterator();
                while (iterator.hasNext()) {
                    Object newEntity;
                    Object entity = iterator.next();
                    if (entity == (newEntity = SqlResultEntityTypeMapper.this.triggerPostLoad(this.ctx.persistentEntity, entity))) continue;
                    iterator.set(newEntity);
                }
                return this.allProcessed;
            }
        };
    }

    private void readChildren(RS rs, Object instance, Object parent, MappingContext<R> ctx) {
        if (ctx.manyAssociations != null) {
            Object id = this.readEntityId(rs, ctx);
            if (id != null) {
                MappingContext associatedCtx = ctx.manyAssociations.get(id);
                if (associatedCtx == null) {
                    associatedCtx = ctx.copy();
                    Object entity = this.readEntity(rs, associatedCtx, parent, id);
                    Objects.requireNonNull(id);
                    ctx.associate(associatedCtx, id, entity);
                } else {
                    this.readChildren(rs, instance, parent, associatedCtx);
                }
            }
            return;
        }
        if (ctx.associations != null) {
            for (Map.Entry<Association, MappingContext> e : ctx.associations.entrySet()) {
                MappingContext associationCtx = e.getValue();
                RuntimeAssociation runtimeAssociation = (RuntimeAssociation)e.getKey();
                Object in = instance == null || !runtimeAssociation.getKind().isSingleEnded() ? null : runtimeAssociation.getProperty().get(instance);
                this.readChildren(rs, in, instance, associationCtx);
            }
        }
    }

    private Object setChildrenAndTriggerPostLoad(Object instance, MappingContext<?> ctx, Object parent) {
        if (ctx.manyAssociations != null) {
            ArrayList<Object> values = new ArrayList<Object>(ctx.manyAssociations.size());
            for (MappingContext associationCtx : ctx.manyAssociations.values()) {
                values.add(this.setChildrenAndTriggerPostLoad(associationCtx.entity, associationCtx, parent));
            }
            return values;
        }
        if (ctx.associations != null) {
            for (Map.Entry<Association, MappingContext> e : ctx.associations.entrySet()) {
                MappingContext associationCtx = e.getValue();
                RuntimeAssociation runtimeAssociation = (RuntimeAssociation)e.getKey();
                BeanProperty beanProperty = runtimeAssociation.getProperty();
                if (runtimeAssociation.getKind().isSingleEnded() && (associationCtx.manyAssociations == null || associationCtx.manyAssociations.isEmpty())) {
                    Object value = beanProperty.get(instance);
                    Object newValue = this.setChildrenAndTriggerPostLoad(value, associationCtx, instance);
                    if (newValue == value) continue;
                    instance = this.setProperty(beanProperty, instance, newValue);
                    continue;
                }
                Object newValue = this.setChildrenAndTriggerPostLoad(null, associationCtx, instance);
                newValue = this.resultReader.convertRequired(newValue == null ? new ArrayList() : newValue, beanProperty.getType());
                instance = this.setProperty(beanProperty, instance, newValue);
            }
        }
        if (instance != null && (ctx.association == null || ctx.jp != null)) {
            Object inverseInstance;
            PersistentAssociationPath inverse;
            Association association;
            if (parent != null && ctx.association != null && ctx.association.isBidirectional() && (association = (inverse = (PersistentAssociationPath)ctx.association.getInversePathSide().orElseThrow(IllegalStateException::new)).getAssociation()).getKind().isSingleEnded() && (inverseInstance = inverse.getPropertyValue(instance)) != parent && ((RuntimeAssociation)inverse.getProperty()).getType().isInstance(parent)) {
                instance = inverse.setPropertyValue(instance, parent);
            }
            return this.triggerPostLoad(ctx.persistentEntity, instance);
        }
        return instance;
    }

    private <X, Y> X setProperty(BeanProperty<X, Y> beanProperty, X x, Y y) {
        if (beanProperty.isReadOnly()) {
            return (X)beanProperty.withValue(x, y);
        }
        beanProperty.set(x, y);
        return x;
    }

    @Nullable
    private <K> K readEntity(RS rs, MappingContext<K> ctx, @Nullable Object parent, @Nullable Object resolveId) {
        RuntimePersistentEntity persistentEntity = ctx.persistentEntity;
        BeanIntrospection introspection = persistentEntity.getIntrospection();
        Object[] constructorArguments = persistentEntity.getConstructorArguments();
        try {
            Object v;
            RuntimePersistentProperty version;
            Object v2;
            Embedded embedded;
            RuntimeAssociation entityAssociation;
            Object entity;
            Object id;
            RuntimePersistentProperty identity = persistentEntity.getIdentity();
            boolean isAssociation = ctx.association != null;
            boolean isEmbedded = ctx.association instanceof Embedded;
            boolean nullableEmbedded = isEmbedded && ctx.association.isOptional();
            Object object = id = resolveId == null ? this.readEntityId(rs, ctx) : resolveId;
            if (id == null && !isEmbedded && isAssociation) {
                return null;
            }
            if (ArrayUtils.isEmpty((Object[])constructorArguments)) {
                entity = introspection.instantiate();
            } else {
                int len = constructorArguments.length;
                Object[] args = new Object[len];
                for (int i = 0; i < len; ++i) {
                    Object prop = constructorArguments[i];
                    if (prop != null) {
                        if (prop instanceof RuntimeAssociation) {
                            boolean isInverse;
                            entityAssociation = (RuntimeAssociation)prop;
                            if (prop instanceof Embedded) {
                                embedded = (Embedded)prop;
                                args[i] = this.readEntity(rs, ctx.embedded(embedded), null, null);
                                continue;
                            }
                            Relation.Kind kind = entityAssociation.getKind();
                            boolean bl = isInverse = parent != null && isAssociation && ctx.association.getOwner() == entityAssociation.getAssociatedEntity();
                            if (isInverse && kind.isSingleEnded() && this.mappedByMatchesOrEmpty(ctx.association, prop.getProperty())) {
                                args[i] = parent;
                                continue;
                            }
                            MappingContext joinCtx = ctx.join(this.fetchJoinPaths, (Association)entityAssociation);
                            Object resolvedId = null;
                            if (!entityAssociation.isForeignKey()) {
                                resolvedId = this.readEntityId(rs, ctx.path((Association)entityAssociation));
                            }
                            if (kind.isSingleEnded()) {
                                if (joinCtx.jp == null || resolvedId == null && !entityAssociation.isForeignKey()) {
                                    args[i] = this.buildIdOnlyEntity(rs, ctx.path((Association)entityAssociation), resolvedId);
                                    continue;
                                }
                                args[i] = this.readEntity(rs, joinCtx, null, resolvedId);
                                continue;
                            }
                            if (!entityAssociation.getProperty().isReadOnly()) continue;
                            args[i] = this.resultReader.convertRequired(new ArrayList(0), entityAssociation.getProperty().getType());
                            if (joinCtx.jp == null) continue;
                            MappingContext associatedCtx = joinCtx.copy();
                            if (resolvedId == null) {
                                resolvedId = this.readEntityId(rs, associatedCtx);
                            }
                            Object associatedEntity = null;
                            if (resolvedId != null || entityAssociation.isForeignKey()) {
                                associatedEntity = this.readEntity(rs, associatedCtx, null, resolvedId);
                            }
                            if (associatedEntity == null) continue;
                            joinCtx.associate(associatedCtx, resolvedId, associatedEntity);
                            continue;
                        }
                        v2 = this.provideConstructorArgumentValue(rs, ctx, (RuntimePersistentProperty<K>)prop, (RuntimePersistentProperty<K>)identity, id);
                        if (v2 == null) {
                            if (!prop.isOptional() && !nullableEmbedded) {
                                AnnotationMetadata entityAnnotationMetadata = ctx.persistentEntity.getAnnotationMetadata();
                                if (entityAnnotationMetadata.hasAnnotation(Embeddable.class) || entityAnnotationMetadata.hasAnnotation(EmbeddedId.class)) {
                                    return null;
                                }
                                throw new DataAccessException("Null value read for non-null constructor argument [" + prop.getName() + "] of type: " + persistentEntity.getName());
                            }
                            args[i] = null;
                            continue;
                        }
                        args[i] = this.convert((RuntimePersistentProperty<?>)prop, v2);
                        continue;
                    }
                    throw new DataAccessException("Constructor argument [" + constructorArguments[i].getName() + "] must have an associated getter.");
                }
                if (nullableEmbedded && args.length > 0 && this.isAllNulls(args)) {
                    return null;
                }
                entity = introspection.instantiate(args);
            }
            if (id != null) {
                if (identity != null) {
                    BeanProperty idProperty = identity.getProperty();
                    entity = this.convertAndSetWithValue(entity, identity, idProperty, id);
                } else if (!persistentEntity.getIdentityProperties().isEmpty()) {
                    Map ids = (Map)id;
                    for (RuntimePersistentProperty identityProperty : persistentEntity.getRuntimeIdentityProperties()) {
                        Object anId = ids.get(identityProperty.getName());
                        entity = this.convertAndSetWithValue(entity, identityProperty, identityProperty.getProperty(), anId);
                    }
                }
            }
            if ((version = persistentEntity.getVersion()) != null && (v = this.readProperty(rs, ctx, version)) != null) {
                entity = this.convertAndSetWithValue(entity, version, version.getProperty(), v);
            }
            for (RuntimePersistentProperty rpp : persistentEntity.getPersistentProperties()) {
                RuntimeAssociation a;
                Relation.Kind kind;
                if (rpp.isReadOnly() || rpp.isConstructorArgument() && (!(rpp instanceof RuntimeAssociation) || (kind = (a = (RuntimeAssociation)rpp).getKind()).isSingleEnded())) continue;
                BeanProperty property = rpp.getProperty();
                if (rpp instanceof RuntimeAssociation) {
                    boolean isInverse;
                    entityAssociation = (RuntimeAssociation)rpp;
                    if (rpp instanceof Embedded) {
                        embedded = (Embedded)rpp;
                        Object value = this.readEntity(rs, ctx.embedded(embedded), parent == null ? entity : parent, null);
                        entity = this.setProperty(property, entity, value);
                        continue;
                    }
                    boolean bl = isInverse = parent != null && entityAssociation.getKind().isSingleEnded() && isAssociation && ctx.association.getOwner() == entityAssociation.getAssociatedEntity();
                    if (isInverse && this.mappedByMatchesOrEmpty(ctx.association, property)) {
                        entity = this.setProperty(property, entity, parent);
                        continue;
                    }
                    MappingContext joinCtx = ctx.join(this.fetchJoinPaths, (Association)entityAssociation);
                    Object associatedId = null;
                    if (!entityAssociation.isForeignKey() && (associatedId = this.readEntityId(rs, ctx.path((Association)entityAssociation))) == null) continue;
                    if (joinCtx.jp != null) {
                        Object associatedEntity;
                        if (entityAssociation.getKind().isSingleEnded()) {
                            Object associatedEntity2 = this.readEntity(rs, joinCtx, entity, associatedId);
                            entity = this.setProperty(property, entity, associatedEntity2);
                            continue;
                        }
                        MappingContext associatedCtx = joinCtx.copy();
                        if (associatedId == null) {
                            associatedId = this.readEntityId(rs, associatedCtx);
                        }
                        if ((associatedEntity = this.readEntity(rs, associatedCtx, entity, associatedId)) != null) {
                            Objects.requireNonNull(associatedId);
                            joinCtx.associate(associatedCtx, associatedId, associatedEntity);
                            continue;
                        }
                        if (joinCtx.manyAssociations != null) continue;
                        joinCtx.manyAssociations = new LinkedHashMap<Object, MappingContext>();
                        continue;
                    }
                    if (!entityAssociation.getKind().isSingleEnded() || entityAssociation.isForeignKey()) continue;
                    Object value = this.buildIdOnlyEntity(rs, ctx.path((Association)entityAssociation), associatedId);
                    entity = this.setProperty(property, entity, value);
                    continue;
                }
                v2 = this.readProperty(rs, ctx, rpp);
                if (v2 == null) continue;
                entity = this.convertAndSetWithValue(entity, rpp, property, v2);
            }
            return (K)entity;
        }
        catch (InstantiationException e) {
            throw new DataAccessException("Error instantiating entity [" + persistentEntity.getName() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    private <K> boolean mappedByMatchesOrEmpty(Association association, BeanProperty<K, Object> property) {
        String mappedBy = association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").orElse(null);
        if (mappedBy == null) {
            return true;
        }
        return mappedBy.equals(property.getName());
    }

    private <K> Object provideConstructorArgumentValue(@NonNull RS rs, @NonNull MappingContext<K> ctx, @NonNull RuntimePersistentProperty<K> property, @Nullable RuntimePersistentProperty<K> identity, @Nullable Object idValue) {
        if (idValue != null) {
            if (identity != null) {
                if (property.equals(identity)) {
                    return idValue;
                }
            } else {
                for (PersistentProperty identityProperty : ctx.persistentEntity.getIdentityProperties()) {
                    if (!property.equals((Object)identityProperty)) continue;
                    return ((Map)idValue).get(identityProperty.getName());
                }
            }
        }
        return this.readProperty(rs, ctx, property);
    }

    private boolean isAllNulls(Object[] args) {
        for (Object arg : args) {
            if (arg == null) continue;
            return false;
        }
        return true;
    }

    private <K> Object readProperty(RS rs, MappingContext<K> ctx, RuntimePersistentProperty<K> prop) {
        Object result;
        Object columnName = ctx.namingStrategy.mappedName(ctx.embeddedPath, prop);
        String columnAlias = prop.getAlias();
        if (StringUtils.isNotEmpty((CharSequence)columnAlias)) {
            columnName = columnAlias;
        } else if (ctx.prefix != null && !ctx.prefix.isEmpty()) {
            columnName = ctx.prefix + (String)columnName;
        }
        DataType dataType = prop.getDataType();
        if (dataType == DataType.JSON && this.jsonColumnReader != null) {
            JsonDataType jsonDataType = prop.getJsonDataType();
            result = this.jsonColumnReader.readJsonColumn(this.resultReader, rs, (String)columnName, jsonDataType, prop.getArgument());
        } else {
            result = this.resultReader.readDynamic(rs, (String)columnName, dataType);
        }
        AttributeConverter converter = prop.getConverter();
        if (converter != null) {
            return converter.convertToEntityValue(result, (ConversionContext)ConversionContext.of((Argument)prop.getArgument()));
        }
        return result;
    }

    private <K> K triggerPostLoad(RuntimePersistentEntity<?> persistentEntity, K entity) {
        Object finalEntity = this.eventListener != null && persistentEntity.hasPostLoadEventListeners() ? this.eventListener.apply(persistentEntity, entity) : entity;
        return finalEntity;
    }

    @Nullable
    private <K> Object readEntityId(RS rs, MappingContext<K> ctx) {
        RuntimePersistentProperty identity = ctx.persistentEntity.getIdentity();
        if (identity != null) {
            if (identity instanceof Embedded) {
                Embedded embedded = (Embedded)identity;
                return this.readEntity(rs, ctx.embedded(embedded), null, null);
            }
            return this.readProperty(rs, ctx, identity);
        }
        List identityProperties = ctx.persistentEntity.getRuntimeIdentityProperties();
        if (!identityProperties.isEmpty()) {
            HashMap<String, Object> ids = new HashMap<String, Object>();
            for (RuntimePersistentProperty identityProperty : identityProperties) {
                Object id = this.readProperty(rs, ctx, identityProperty);
                if (id == null) continue;
                ids.put(identityProperty.getName(), id);
            }
            if (ids.isEmpty()) {
                return null;
            }
            return ids;
        }
        return null;
    }

    private <K> K convertAndSetWithValue(K entity, RuntimePersistentProperty<?> rpp, BeanProperty<K, Object> property, Object v) {
        return this.setProperty(property, entity, this.convert(rpp, v));
    }

    private Object convert(RuntimePersistentProperty<?> rpp, Object v) {
        Class propertyType = rpp.getType();
        if (v instanceof Array) {
            Array array = (Array)v;
            try {
                v = array.getArray();
            }
            catch (SQLException e) {
                throw new DataAccessException("Error getting an array value: " + e.getMessage(), (Throwable)e);
            }
        }
        if (propertyType.isInstance(v)) {
            return v;
        }
        return this.resultReader.convertRequired(v, rpp.getArgument());
    }

    private <K> K buildIdOnlyEntity(RS rs, MappingContext<K> ctx, Object resolvedId) {
        RuntimePersistentProperty identity = ctx.persistentEntity.getIdentity();
        if (identity != null) {
            Argument arg;
            BeanIntrospection associatedIntrospection = ctx.persistentEntity.getIntrospection();
            Argument[] constructorArgs = associatedIntrospection.getConstructorArguments();
            if (constructorArgs.length == 0) {
                Object associated = associatedIntrospection.instantiate();
                if (resolvedId == null) {
                    resolvedId = this.readEntityId(rs, ctx);
                }
                BeanWrapper.getWrapper((Object)associated).setProperty(identity.getName(), resolvedId);
                return (K)associated;
            }
            if (constructorArgs.length == 1 && (arg = constructorArgs[0]).getName().equals(identity.getName()) && arg.getType() == identity.getType()) {
                if (resolvedId == null) {
                    resolvedId = this.readEntityId(rs, ctx);
                }
                if (resolvedId != null) {
                    return (K)associatedIntrospection.instantiate(new Object[]{this.resultReader.convertRequired(resolvedId, identity.getType())});
                }
            }
        }
        return null;
    }

    public RuntimePersistentEntity<R> getPersistentEntity() {
        return this.entity;
    }

    private static final class MappingContext<E> {
        private final RuntimePersistentEntity<E> rootPersistentEntity;
        private final RuntimePersistentEntity<E> persistentEntity;
        private final NamingStrategy namingStrategy;
        private final String prefix;
        private final JoinPath jp;
        private final List<Association> joinPath;
        private final List<Association> embeddedPath;
        private final Association association;
        private Map<Object, MappingContext> manyAssociations;
        private Map<Association, MappingContext> associations;
        private E entity;

        private MappingContext(RuntimePersistentEntity rootPersistentEntity, RuntimePersistentEntity persistentEntity, NamingStrategy namingStrategy, String prefix, JoinPath jp, List<Association> joinPath, List<Association> embeddedPath, Association association) {
            this.rootPersistentEntity = rootPersistentEntity;
            this.persistentEntity = persistentEntity;
            this.namingStrategy = namingStrategy;
            this.prefix = prefix;
            this.jp = jp;
            this.joinPath = joinPath;
            this.embeddedPath = embeddedPath;
            this.association = association;
        }

        public static <K> MappingContext<K> of(RuntimePersistentEntity<K> persistentEntity, String prefix) {
            return new MappingContext(persistentEntity, persistentEntity, persistentEntity.getNamingStrategy(), prefix, null, Collections.emptyList(), Collections.emptyList(), null);
        }

        public <K> MappingContext<K> embedded(Embedded embedded) {
            if (this.associations == null) {
                this.associations = new LinkedHashMap<Association, MappingContext>();
            }
            return this.associations.computeIfAbsent((Association)embedded, e -> this.embeddedAssociation(embedded));
        }

        public <K> MappingContext<K> path(Association association) {
            RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
            return new MappingContext<E>(this.rootPersistentEntity, associatedEntity, this.namingStrategy, this.prefix, this.jp, this.joinPath, MappingContext.associated(this.embeddedPath, association), association);
        }

        public <K> MappingContext<K> join(Map<String, JoinPath> joinPaths, Association association) {
            if (this.associations == null) {
                this.associations = new LinkedHashMap<Association, MappingContext>();
            }
            return this.associations.computeIfAbsent(association, a -> this.joinAssociation(joinPaths, association));
        }

        public <K> MappingContext<K> associate(MappingContext<K> ctx, @NonNull Object associationId, @NonNull Object entity) {
            ctx.entity = entity;
            if (this.manyAssociations == null) {
                this.manyAssociations = new LinkedHashMap<Object, MappingContext>();
            }
            this.manyAssociations.put(associationId, ctx);
            return ctx;
        }

        private <K> MappingContext<K> copy() {
            MappingContext<E> ctx = new MappingContext<E>(this.rootPersistentEntity, this.persistentEntity, this.namingStrategy, this.prefix, this.jp, this.joinPath, this.embeddedPath, this.association);
            return ctx;
        }

        private <K> MappingContext<K> joinAssociation(Map<String, JoinPath> joinPaths, Association association) {
            JoinPath jp = this.findJoinPath(joinPaths, association);
            RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
            return new MappingContext<E>(this.rootPersistentEntity, associatedEntity, associatedEntity.getNamingStrategy(), jp == null ? this.prefix : jp.getAlias().orElse(this.prefix), jp, MappingContext.associated(this.joinPath, association), Collections.emptyList(), association);
        }

        private <K> MappingContext<K> embeddedAssociation(Embedded embedded) {
            RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)embedded.getAssociatedEntity();
            return new MappingContext<E>(this.rootPersistentEntity, associatedEntity, associatedEntity.findNamingStrategy().orElse(this.namingStrategy), this.prefix, this.jp, this.joinPath, MappingContext.associated(this.embeddedPath, (Association)embedded), (Association)embedded);
        }

        private JoinPath findJoinPath(Map<String, JoinPath> joinPaths, Association association) {
            Object path;
            JoinPath jp = null;
            if (!joinPaths.isEmpty() && (jp = joinPaths.get(path = this.asPath(this.joinPath, this.embeddedPath, (PersistentProperty)association))) == null && (jp = joinPaths.get(path = this.asPath(this.joinPath, (PersistentProperty)association))) == null) {
                RuntimePersistentProperty identity = this.rootPersistentEntity.getIdentity();
                if (identity instanceof Embedded) {
                    path = identity.getName() + "." + (String)path;
                }
                jp = joinPaths.get(path);
            }
            if (jp == null) {
                return null;
            }
            String alias = jp.getAlias().orElse(null);
            if (alias == null) {
                alias = association.getAliasName();
                if (!this.embeddedPath.isEmpty()) {
                    StringBuilder sb = this.prefix == null ? new StringBuilder() : new StringBuilder(this.prefix);
                    for (Association embedded : this.embeddedPath) {
                        sb.append(embedded.getName());
                        sb.append('_');
                    }
                    sb.append(alias);
                    alias = sb.toString();
                } else {
                    alias = this.prefix == null ? alias : this.prefix + alias;
                }
            }
            return new JoinPath(jp.getPath(), jp.getAssociationPath(), jp.getJoinType(), alias);
        }

        private String asPath(List<Association> joinPath, List<Association> embeddedPath, PersistentProperty property) {
            if (joinPath.isEmpty() && embeddedPath.isEmpty()) {
                return property.getName();
            }
            StringJoiner joiner = new StringJoiner(".");
            for (Association association : joinPath) {
                joiner.add(association.getName());
            }
            for (Association association : embeddedPath) {
                joiner.add(association.getName());
            }
            joiner.add(property.getName());
            return joiner.toString();
        }

        private String asPath(List<Association> associations, PersistentProperty property) {
            if (associations.isEmpty()) {
                return property.getName();
            }
            StringJoiner joiner = new StringJoiner(".");
            for (Association association : associations) {
                joiner.add(association.getName());
            }
            joiner.add(property.getName());
            return joiner.toString();
        }

        private static List<Association> associated(List<Association> associations, Association association) {
            ArrayList<Association> newAssociations = new ArrayList<Association>(associations.size() + 1);
            newAssociations.addAll(associations);
            newAssociations.add(association);
            return newAssociations;
        }
    }

    public static interface PushingMapper<RS, R> {
        public void processRow(@NonNull RS var1);

        @Nullable
        public R getResult();
    }
}

