/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.query;

import io.micronaut.aop.InvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.Limit;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.runtime.DelegatingQueryParameterBinding;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.query.internal.DelegateStoredQuery;
import io.micronaut.inject.annotation.EvaluatedAnnotationValue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;

@Internal
public class DefaultBindableParametersStoredQuery<E, R>
implements BindableParametersStoredQuery<E, R>,
DelegateStoredQuery<E, R> {
    private final StoredQuery<E, R> storedQuery;
    private final RuntimePersistentEntity<E> runtimePersistentEntity;
    private final ConversionService conversionService;

    public DefaultBindableParametersStoredQuery(StoredQuery<E, R> storedQuery, RuntimePersistentEntity<E> runtimePersistentEntity, ConversionService conversionService) {
        this.storedQuery = storedQuery;
        this.runtimePersistentEntity = runtimePersistentEntity;
        this.conversionService = conversionService;
        Objects.requireNonNull(storedQuery, "Query cannot be null");
    }

    @Override
    public RuntimePersistentEntity<E> getPersistentEntity() {
        return this.runtimePersistentEntity;
    }

    @Override
    public StoredQuery<E, R> getStoredQueryDelegate() {
        return this.storedQuery;
    }

    @Override
    public void bindParameters(BindableParametersStoredQuery.Binder binder, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity, @Nullable Map<QueryParameterBinding, Object> previousValues) {
        for (QueryParameterBinding queryParameterBinding : this.storedQuery.getQueryBindings()) {
            this.bindParameter(binder, invocationContext, entity, previousValues, queryParameterBinding);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void bindParameter(BindableParametersStoredQuery.Binder binder, @Nullable InvocationContext<?, ?> invocationContext, @Nullable E entity, @Nullable Map<QueryParameterBinding, Object> previousValues, QueryParameterBinding binding22) {
        List<Object> values;
        void binding22;
        RuntimePersistentEntity<E> persistentEntity = this.getPersistentEntity();
        Class parameterConverter = binding22.getParameterConverterClass();
        Object value = binding22.getValue();
        RuntimePersistentProperty persistentProperty = null;
        Argument argument = null;
        boolean skipExpansion = false;
        if (value == null) {
            if (binding22.isExpression()) {
                this.requireInvocationContext(invocationContext);
                AnnotationValue annotationValue = (AnnotationValue)this.storedQuery.getParameterExpressions().get(binding22.getName());
                if (annotationValue == null) {
                    throw new IllegalStateException("Required annotation value for parameter expression: " + binding22.getName());
                }
                if (!(annotationValue instanceof EvaluatedAnnotationValue)) throw new IllegalStateException("Required evaluated annotation value for parameter expression: " + binding22.getName());
                EvaluatedAnnotationValue evaluatedAnnotationValue = (EvaluatedAnnotationValue)annotationValue;
                evaluatedAnnotationValue = evaluatedAnnotationValue.withArguments(invocationContext.getTarget(), invocationContext.getParameterValues());
                value = evaluatedAnnotationValue.get((CharSequence)"expression", Argument.OBJECT_ARGUMENT).orElseThrow();
            } else if (binding22.getParameterIndex() != -1) {
                this.requireInvocationContext(invocationContext);
                value = this.resolveParameterValue((QueryParameterBinding)binding22, invocationContext.getParameterValues());
                argument = invocationContext.getArguments()[binding22.getParameterIndex()];
            } else if (binding22.isAutoPopulated()) {
                pp = this.getRequiredPropertyPath((QueryParameterBinding)binding22, (RuntimePersistentEntity)persistentEntity);
                persistentProperty = (RuntimePersistentProperty)pp.getProperty();
                if (binding22.isRequiresPreviousPopulatedValue()) {
                    if (previousValues != null) {
                        value = previousValues.get(binding22);
                    }
                } else if (entity == null) {
                    Object previousValue = null;
                    QueryParameterBinding previousPopulatedValueParameter = binding22.getPreviousPopulatedValueParameter();
                    if (previousPopulatedValueParameter != null) {
                        if (previousPopulatedValueParameter.getParameterIndex() == -1) {
                            throw new IllegalStateException("Previous value parameter cannot be bind!");
                        }
                        this.requireInvocationContext(invocationContext);
                        previousValue = this.resolveParameterValue(previousPopulatedValueParameter, invocationContext.getParameterValues());
                    }
                    value = binder.autoPopulateRuntimeProperty(persistentProperty, previousValue);
                } else {
                    value = pp.getPropertyValue(entity);
                }
                value = binder.convert(value, persistentProperty);
                parameterConverter = null;
            } else if (entity != null) {
                if (this.isJsonEntity() && binding22.getDataType() == DataType.JSON) {
                    value = entity;
                } else {
                    pp = this.getRequiredPropertyPath((QueryParameterBinding)binding22, (RuntimePersistentEntity)persistentEntity);
                    value = pp.getPropertyValue(entity);
                    persistentProperty = (RuntimePersistentProperty)pp.getProperty();
                }
            } else {
                if (binding22.getParameterIndex() != -1 || binding22.isAutoPopulated()) {
                    int currentIndex = binder.currentIndex();
                    if (currentIndex == -1) throw new IllegalStateException("Invalid query [" + this.getQuery() + "]. Unable to establish parameter value for parameter: " + binding22.getName());
                    throw new IllegalStateException("Invalid query [" + this.getQuery() + "]. Unable to establish parameter value for parameter at position: " + currentIndex);
                }
                String[] propertyPath = binding22.getPropertyPath();
                PersistentPropertyPath pp = persistentEntity.getPropertyPath(propertyPath);
                if (pp != null && pp.getProperty().isRequired()) {
                    throw new IllegalStateException("Field [" + pp.getProperty().getName() + "] does not allow null value.");
                }
            }
        } else if (value instanceof EvaluatedAnnotationValue) {
            EvaluatedAnnotationValue evaluatedAnnotationValue = (EvaluatedAnnotationValue)value;
            value = evaluatedAnnotationValue.withArguments(invocationContext.getTarget(), invocationContext.getParameterValues()).get((CharSequence)"value", Object.class).orElse(null);
        }
        if (persistentProperty != null) {
            argument = persistentProperty.getArgument();
            if (binding22.getDataType() != persistentProperty.getDataType()) {
                String finalPersistentProperty = persistentProperty;
                DelegatingQueryParameterBinding binding22 = new DelegatingQueryParameterBinding((QueryParameterBinding)binding22, (RuntimePersistentProperty)finalPersistentProperty){
                    final /* synthetic */ RuntimePersistentProperty val$finalPersistentProperty;
                    {
                        this.val$finalPersistentProperty = runtimePersistentProperty;
                        super(delegate);
                    }

                    public DataType getDataType() {
                        return this.val$finalPersistentProperty.getDataType();
                    }

                    public JsonDataType getJsonDataType() {
                        return this.val$finalPersistentProperty.getJsonDataType();
                    }
                };
            }
        }
        if (binding22.getRole() != null) {
            value = switch (binding22.getRole()) {
                case "pageable", "pageableRequired" -> (Pageable)this.conversionService.convertRequired(value, Pageable.class);
                case "querylimit" -> (Limit)this.conversionService.convertRequired(value, Limit.class);
                case "sort" -> (Sort)this.conversionService.convertRequired(value, Sort.class);
                default -> throw new IllegalArgumentException("Unsupported role " + binding22.getRole());
            };
            skipExpansion = true;
        }
        if (binding22.isExpandable()) {
            if (skipExpansion) {
                return;
            }
            values = this.expandValue(value, binding22.getDataType());
        } else {
            values = null;
        }
        if (values != null && values.isEmpty()) {
            value = null;
            values = null;
        }
        if (values == null) {
            if (parameterConverter != null) {
                value = binder.convert(parameterConverter, value, argument);
            } else if (persistentProperty != null && !binding22.isAutoPopulated()) {
                value = binder.convert(value, persistentProperty);
            }
            binder.bindOne((QueryParameterBinding)binding22, value);
            return;
        } else {
            values = new ArrayList<Object>(values);
            ListIterator<Object> iterator = values.listIterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (parameterConverter != null) {
                    v = binder.convert(parameterConverter, v, argument);
                } else if (persistentProperty != null && !binding22.isAutoPopulated()) {
                    v = binder.convert(v, persistentProperty);
                }
                iterator.set(v);
            }
            binder.bindMany((QueryParameterBinding)binding22, values);
        }
    }

    private Object resolveParameterValue(QueryParameterBinding queryParameterBinding, Object[] parameterArray) {
        Object value = parameterArray[queryParameterBinding.getParameterIndex()];
        String[] parameterBindingPath = queryParameterBinding.getParameterBindingPath();
        if (parameterBindingPath != null) {
            for (String prop : parameterBindingPath) {
                if (value == null) break;
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(prop, Argument.OBJECT_ARGUMENT);
            }
        }
        return value;
    }

    private List<Object> expandValue(Object value, @Nullable DataType dataType) {
        if (value == null || dataType != null && dataType.isArray() && dataType != DataType.BYTE_ARRAY || value instanceof byte[]) {
            return null;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            return CollectionUtils.iterableToList((Iterable)iterable);
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            if (len == 0) {
                return Collections.emptyList();
            }
            ArrayList<Object> list = new ArrayList<Object>(len);
            for (int j = 0; j < len; ++j) {
                Object o = Array.get(value, j);
                list.add(o);
            }
            return list;
        }
        return null;
    }

    protected final <T> PersistentPropertyPath getRequiredPropertyPath(QueryParameterBinding queryParameterBinding, RuntimePersistentEntity<T> persistentEntity) {
        CharSequence[] propertyPath = queryParameterBinding.getRequiredPropertyPath();
        PersistentPropertyPath pp = persistentEntity.getPropertyPath((String[])propertyPath);
        if (pp == null) {
            throw new IllegalStateException("Cannot find property: " + String.join((CharSequence)".", propertyPath));
        }
        return pp;
    }

    protected final void requireInvocationContext(InvocationContext<?, ?> invocationContext) {
        if (invocationContext == null) {
            throw new IllegalStateException("Invocation context is required!");
        }
    }
}

