/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.operations.PrimaryRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.RepositoryOperationsRegistry;
import io.micronaut.data.runtime.multitenancy.DataSourceTenantResolver;
import io.micronaut.inject.ArgumentInjectionPoint;
import io.micronaut.inject.InjectionPoint;
import jakarta.inject.Singleton;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@Internal
@Singleton
public final class DataInterceptorResolver {
    private final RepositoryOperationsRegistry repositoryOperationsRegistry;
    @Nullable
    private final DataSourceTenantResolver tenantResolver;
    private final Map<TenantRepositoryMethodKey, DataInterceptor<? super Object, ? super Object>> interceptors = new ConcurrentHashMap<TenantRepositoryMethodKey, DataInterceptor<? super Object, ? super Object>>();

    DataInterceptorResolver(RepositoryOperationsRegistry repositoryOperationsRegistry, @Nullable DataSourceTenantResolver tenantResolver) {
        this.repositoryOperationsRegistry = repositoryOperationsRegistry;
        this.tenantResolver = tenantResolver;
    }

    DataInterceptor<Object, Object> resolve(@NonNull RepositoryMethodKey key, @NonNull MethodInvocationContext<Object, Object> context, @Nullable InjectionPoint<?> injectionPoint) {
        DataInterceptor<? super Object, ? super Object> dataInterceptor;
        String tenantDataSourceName = this.tenantResolver != null ? this.tenantResolver.resolveTenantDataSourceName() : null;
        TenantRepositoryMethodKey theKey = new TenantRepositoryMethodKey(tenantDataSourceName, key, null);
        if (tenantDataSourceName == null && injectionPoint instanceof ArgumentInjectionPoint) {
            ArgumentInjectionPoint argumentInjectionPoint = (ArgumentInjectionPoint)injectionPoint;
            theKey = new TenantRepositoryMethodKey(tenantDataSourceName, key, argumentInjectionPoint.asArgument());
        }
        if ((dataInterceptor = this.interceptors.get(theKey)) == null) {
            dataInterceptor = this.findDataInterceptor(context, injectionPoint, tenantDataSourceName);
            this.interceptors.put(theKey, dataInterceptor);
        }
        return dataInterceptor;
    }

    private DataInterceptor<Object, Object> findDataInterceptor(MethodInvocationContext<Object, Object> context, InjectionPoint<?> injectionPoint, String tenantDataSourceName) {
        String dataSourceName = tenantDataSourceName == null ? context.stringValue(Repository.class).orElseGet(() -> injectionPoint == null ? null : (String)injectionPoint.getAnnotationMetadata().stringValue(Repository.class).orElse(null)) : tenantDataSourceName;
        Class<PrimaryRepositoryOperations> operationsType = context.classValue(RepositoryConfiguration.class, "operations").orElse(PrimaryRepositoryOperations.class);
        Class interceptorType = context.classValue(DataMethod.class, "interceptor").orElseGet(() -> {
            AnnotationValue declaredAnnotation = context.getDeclaredAnnotation(DataMethod.class);
            if (declaredAnnotation == null) {
                return null;
            }
            return declaredAnnotation.classValue("interceptor").orElse(null);
        });
        if (interceptorType != null && DataInterceptor.class.isAssignableFrom(interceptorType)) {
            return this.findInterceptor(dataSourceName, operationsType, interceptorType);
        }
        String interceptorName = context.getAnnotationMetadata().stringValue(DataMethod.class, "interceptor").orElse(null);
        if (interceptorName != null) {
            throw new IllegalStateException("Micronaut Data Interceptor [" + interceptorName + "] is not on the classpath but required by the method: " + context.getExecutableMethod());
        }
        throw new IllegalStateException("Micronaut Data method is missing compilation time query information. Ensure that the Micronaut Data annotation processors are declared in your build and try again with a clean re-build.");
    }

    @NonNull
    private DataInterceptor<Object, Object> findInterceptor(@Nullable String dataSourceName, @NonNull Class<? extends RepositoryOperations> operationsType, @NonNull Class<?> interceptorType) {
        if (!RepositoryOperations.class.isAssignableFrom(operationsType)) {
            throw new IllegalArgumentException("Repository type must be an instance of RepositoryOperations!");
        }
        RepositoryOperations datastore = this.repositoryOperationsRegistry.provide(operationsType, dataSourceName);
        Collection candidates = BeanIntrospector.SHARED.findIntrospections(ref -> {
            if (ref.isPresent()) {
                Class beanType = ref.getBeanType();
                return interceptorType.isAssignableFrom(beanType) && !Modifier.isAbstract(beanType.getModifiers());
            }
            return false;
        });
        BeanIntrospection introspection = (BeanIntrospection)candidates.stream().findFirst().orElseThrow(() -> new DataAccessException("No Data interceptor found for type: " + interceptorType));
        DataInterceptor interceptor = introspection.getConstructorArguments().length == 0 ? (DataInterceptor)introspection.instantiate() : (DataInterceptor)introspection.instantiate(new Object[]{datastore});
        return interceptor;
    }

    private static final class TenantRepositoryMethodKey {
        private final String dataSource;
        private final RepositoryMethodKey key;
        private final Argument<?> injectionPoint;
        private final int hashCode;

        TenantRepositoryMethodKey(String dataSource, RepositoryMethodKey key, @Nullable Argument<?> injectionPoint) {
            this.dataSource = dataSource;
            this.key = key;
            this.injectionPoint = injectionPoint;
            this.hashCode = Objects.hash(dataSource, key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TenantRepositoryMethodKey that = (TenantRepositoryMethodKey)o;
            return Objects.equals(this.dataSource, that.dataSource) && this.key.equals((Object)that.key) && Objects.equals(this.injectionPoint, that.injectionPoint);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

