/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.query.internal;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.runtime.query.internal.BasicStoredQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Internal
public final class QueryResultStoredQuery<E, R>
extends BasicStoredQuery<E, R> {
    private final DataMethod.OperationType operationType;
    private final QueryResult queryResult;
    private final Set<JoinPath> joinPaths;

    public QueryResultStoredQuery(String name, AnnotationMetadata annotationMetadata, QueryResult queryResult, Class<E> rootEntity, Class<R> resultType, boolean pageable, boolean isSingleResult, boolean isCount, DataMethod.OperationType operationType, Collection<JoinPath> joinPaths) {
        super(name, annotationMetadata, queryResult.getQuery(), queryResult.getParameterBindings().stream().anyMatch(io.micronaut.data.model.query.builder.QueryParameterBinding::isExpandable) ? queryResult.getQueryParts().toArray(new String[0]) : null, QueryResultStoredQuery.map(queryResult.getParameterBindings()), rootEntity, resultType, pageable, isSingleResult, isCount);
        this.queryResult = queryResult;
        this.operationType = operationType;
        this.joinPaths = joinPaths == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<JoinPath>(joinPaths));
    }

    public static <T> QueryResultStoredQuery<T, T> single(DataMethod.OperationType operationType, String name, AnnotationMetadata annotationMetadata, QueryResult queryResult, Class<T> rootEntity) {
        return new QueryResultStoredQuery<T, T>(name, annotationMetadata, queryResult, rootEntity, rootEntity, false, true, false, operationType, Collections.emptySet());
    }

    public static <T, R> QueryResultStoredQuery<T, R> single(DataMethod.OperationType operationType, String name, AnnotationMetadata annotationMetadata, QueryResult queryResult, Class<T> rootEntity, Class<R> resultType, Collection<JoinPath> joinPaths) {
        return new QueryResultStoredQuery<T, T>(name, annotationMetadata, queryResult, rootEntity, resultType == Object.class ? rootEntity : resultType, false, true, false, operationType, joinPaths);
    }

    public static <T> QueryResultStoredQuery<T, T> many(String name, AnnotationMetadata annotationMetadata, QueryResult queryResult, Class<T> rootEntity, boolean pageable) {
        return new QueryResultStoredQuery<T, T>(name, annotationMetadata, queryResult, rootEntity, rootEntity, pageable, false, false, DataMethod.OperationType.QUERY, Collections.emptySet());
    }

    public static <T, R> QueryResultStoredQuery<T, R> many(String name, AnnotationMetadata annotationMetadata, QueryResult queryResult, Class<T> rootEntity, Class<R> resultType, boolean pageable, Collection<JoinPath> joinPaths) {
        return new QueryResultStoredQuery<T, T>(name, annotationMetadata, queryResult, rootEntity, resultType == Object.class ? rootEntity : resultType, pageable, false, false, DataMethod.OperationType.QUERY, joinPaths);
    }

    public static <T> QueryResultStoredQuery<T, Long> count(String name, AnnotationMetadata annotationMetadata, QueryResult queryResult, Class<T> rootEntity) {
        return new QueryResultStoredQuery<T, Long>(name, annotationMetadata, queryResult, rootEntity, Long.class, false, true, true, DataMethod.OperationType.COUNT, Collections.emptySet());
    }

    private static List<QueryParameterBinding> map(List<io.micronaut.data.model.query.builder.QueryParameterBinding> parameterBindings) {
        ArrayList<QueryParameterBinding> queryParameters = new ArrayList<QueryParameterBinding>(parameterBindings.size());
        for (io.micronaut.data.model.query.builder.QueryParameterBinding p : parameterBindings) {
            queryParameters.add(new QueryResultParameterBinding(p, queryParameters));
        }
        return queryParameters;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public DataMethod.OperationType getOperationType() {
        return this.operationType;
    }

    public Set<JoinPath> getJoinFetchPaths() {
        return this.joinPaths;
    }

    private static class QueryResultParameterBinding
    implements QueryParameterBinding {
        private final io.micronaut.data.model.query.builder.QueryParameterBinding p;
        private final List<QueryParameterBinding> all;
        private boolean previousInitialized;
        private QueryParameterBinding previousPopulatedValueParameter;

        public QueryResultParameterBinding(io.micronaut.data.model.query.builder.QueryParameterBinding p, List<QueryParameterBinding> all) {
            this.p = p;
            this.all = all;
        }

        public String getName() {
            return this.p.getKey();
        }

        public DataType getDataType() {
            return this.p.getDataType();
        }

        public JsonDataType getJsonDataType() {
            return this.p.getJsonDataType();
        }

        public Class<?> getParameterConverterClass() {
            if (this.p.getConverterClassName() == null) {
                return null;
            }
            return (Class)ClassUtils.forName((String)this.p.getConverterClassName(), null).orElseThrow(IllegalStateException::new);
        }

        public int getParameterIndex() {
            return this.p.getParameterIndex();
        }

        public String[] getParameterBindingPath() {
            return this.p.getParameterBindingPath();
        }

        public String[] getPropertyPath() {
            return this.p.getPropertyPath();
        }

        public boolean isAutoPopulated() {
            return this.p.isAutoPopulated();
        }

        public boolean isRequiresPreviousPopulatedValue() {
            return this.p.isRequiresPreviousPopulatedValue();
        }

        public QueryParameterBinding getPreviousPopulatedValueParameter() {
            if (!this.previousInitialized) {
                for (QueryParameterBinding it : this.all) {
                    if (it == this || it.getParameterIndex() == -1 || !Arrays.equals(this.getPropertyPath(), it.getPropertyPath())) continue;
                    this.previousPopulatedValueParameter = it;
                    break;
                }
                this.previousInitialized = true;
            }
            return this.previousPopulatedValueParameter;
        }

        public boolean isExpandable() {
            return this.p.isExpandable();
        }

        public Object getValue() {
            return this.p.getValue();
        }
    }
}

