/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.sql;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.type.Argument;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersStoredQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Internal
public final class DefaultSqlStoredQuery<E, R>
extends DefaultBindableParametersStoredQuery<E, R>
implements SqlStoredQuery<E, R> {
    private final boolean expandableQuery;
    private final SqlQueryBuilder queryBuilder;

    public DefaultSqlStoredQuery(StoredQuery<E, R> storedQuery, RuntimePersistentEntity<E> runtimePersistentEntity, SqlQueryBuilder queryBuilder) {
        super(storedQuery, runtimePersistentEntity);
        this.queryBuilder = queryBuilder;
        Objects.requireNonNull(storedQuery, "Query cannot be null");
        Objects.requireNonNull(queryBuilder, "Builder cannot be null");
        Object[] expandableQueryParts = storedQuery.getExpandableQueryParts();
        List queryParameterBindings = storedQuery.getQueryBindings();
        boolean bl = this.expandableQuery = expandableQueryParts.length > 1 && queryParameterBindings.stream().anyMatch(QueryParameterBinding::isExpandable);
        if (this.expandableQuery && expandableQueryParts.length != queryParameterBindings.size() + 1) {
            throw new IllegalStateException("Expandable query parts size should be the same as parameters size + 1. " + expandableQueryParts.length + " != 1 + " + queryParameterBindings.size() + " " + storedQuery.getQuery() + " " + Arrays.toString(expandableQueryParts));
        }
    }

    @Override
    public boolean isExpandableQuery() {
        return this.expandableQuery;
    }

    @Override
    public Dialect getDialect() {
        return this.queryBuilder.getDialect();
    }

    @Override
    public SqlQueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    @Override
    public Map<QueryParameterBinding, Object> collectAutoPopulatedPreviousValues(E entity) {
        StoredQuery storedQuery = this.getStoredQueryDelegate();
        if (storedQuery.getQueryBindings().isEmpty()) {
            return null;
        }
        return storedQuery.getQueryBindings().stream().filter(b -> b.isAutoPopulated() && b.isRequiresPreviousPopulatedValue()).map(b -> {
            if (b.getPropertyPath() == null) {
                throw new IllegalStateException("Missing property path for query parameter: " + b);
            }
            Object value = entity;
            for (String property : b.getPropertyPath()) {
                if (value == null) break;
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(property, Argument.OBJECT_ARGUMENT);
            }
            return new AbstractMap.SimpleEntry<QueryParameterBinding, Object>((QueryParameterBinding)b, value);
        }).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }
}

