/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal.sql;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.operations.internal.AbstractRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.DefaultSqlStoredQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlPreparedQuery;
import io.micronaut.data.runtime.operations.internal.sql.SqlStoredQuery;
import io.micronaut.data.runtime.query.MethodContextAwareStoredQueryDecorator;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.internal.BasicStoredQuery;
import io.micronaut.data.runtime.query.internal.QueryResultStoredQuery;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

@Internal
public abstract class AbstractSqlRepositoryOperations<RS, PS, Exc extends Exception>
extends AbstractRepositoryOperations
implements ApplicationContextProvider,
PreparedQueryDecorator,
MethodContextAwareStoredQueryDecorator,
HintsCapableRepository {
    protected static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    protected static final SqlQueryBuilder DEFAULT_SQL_BUILDER = new SqlQueryBuilder();
    protected final ResultReader<RS, String> columnNameResultSetReader;
    protected final ResultReader<RS, Integer> columnIndexResultSetReader;
    protected final QueryStatement<PS, Integer> preparedStatementWriter;
    protected final Map<Class, SqlQueryBuilder> queryBuilders = new HashMap<Class, SqlQueryBuilder>(10);
    private final Map<QueryKey, SqlStoredQuery> entityInserts = new ConcurrentHashMap<QueryKey, SqlStoredQuery>(10);
    private final Map<QueryKey, SqlStoredQuery> entityUpdates = new ConcurrentHashMap<QueryKey, SqlStoredQuery>(10);
    private final Map<Association, String> associationInserts = new ConcurrentHashMap<Association, String>(10);

    protected AbstractSqlRepositoryOperations(String dataSourceName, ResultReader<RS, String> columnNameResultSetReader, ResultReader<RS, Integer> columnIndexResultSetReader, QueryStatement<PS, Integer> preparedStatementWriter, List<MediaTypeCodec> codecs, DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, BeanContext beanContext, DataConversionService<?> conversionService, AttributeConverterRegistry attributeConverterRegistry) {
        super(codecs, dateTimeProvider, runtimeEntityRegistry, conversionService, attributeConverterRegistry);
        this.columnNameResultSetReader = columnNameResultSetReader;
        this.columnIndexResultSetReader = columnIndexResultSetReader;
        this.preparedStatementWriter = preparedStatementWriter;
        Collection beanDefinitions = beanContext.getBeanDefinitions(GenericRepository.class, Qualifiers.byStereotype(Repository.class));
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String targetDs = beanDefinition.stringValue(Repository.class).orElse("default");
            if (!targetDs.equalsIgnoreCase(dataSourceName)) continue;
            Class beanType = beanDefinition.getBeanType();
            SqlQueryBuilder queryBuilder = new SqlQueryBuilder(beanDefinition.getAnnotationMetadata());
            this.queryBuilders.put(beanType, queryBuilder);
        }
    }

    @Override
    public <E, R> PreparedQuery<E, R> decorate(PreparedQuery<E, R> preparedQuery) {
        return new DefaultSqlPreparedQuery<E, R>(preparedQuery);
    }

    @Override
    public <E, R> StoredQuery<E, R> decorate(MethodInvocationContext<?, ?> context, StoredQuery<E, R> storedQuery) {
        Class<?> repositoryType = context.getTarget().getClass();
        SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
        RuntimePersistentEntity runtimePersistentEntity = this.runtimeEntityRegistry.getEntity(storedQuery.getRootEntity());
        return new DefaultSqlStoredQuery<E, R>(storedQuery, runtimePersistentEntity, queryBuilder);
    }

    protected <T, R> PS prepareStatement(StatementSupplier<PS> statementFunction, @NonNull PreparedQuery<T, R> preparedQuery, boolean isUpdate, boolean isSingleResult) throws Exc {
        PS ps;
        SqlPreparedQuery<T, R> sqlPreparedQuery = this.getSqlPreparedQuery(preparedQuery);
        sqlPreparedQuery.prepare(null);
        if (!isUpdate) {
            sqlPreparedQuery.attachPageable(preparedQuery.getPageable(), isSingleResult);
        }
        String query = sqlPreparedQuery.getQuery();
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)query);
        }
        try {
            ps = statementFunction.create(query);
        }
        catch (Exception e) {
            throw new DataAccessException("Unable to prepare query [" + query + "]: " + e.getMessage(), (Throwable)e);
        }
        return ps;
    }

    protected void setStatementParameter(PS preparedStatement, int index, DataType dataType, Object value, Dialect dialect) {
        switch (dataType) {
            case UUID: {
                if (value == null || !dialect.requiresStringUUID(dataType)) break;
                value = value.toString();
                break;
            }
            case JSON: {
                if (value == null || this.jsonCodec == null || value.getClass().equals(String.class)) break;
                value = new String(this.jsonCodec.encode(value), StandardCharsets.UTF_8);
                break;
            }
            case ENTITY: {
                if (value == null) break;
                RuntimePersistentProperty<Object> idReader = this.getIdReader(value);
                Object id = idReader.getProperty().get(value);
                if (id == null) {
                    throw new DataAccessException("Supplied entity is a transient instance: " + value);
                }
                this.setStatementParameter(preparedStatement, index, idReader.getDataType(), id, dialect);
                return;
            }
        }
        dataType = dialect.getDataType(dataType);
        if (QUERY_LOG.isTraceEnabled()) {
            QUERY_LOG.trace("Binding parameter at position {} to value {} with data type: {}", new Object[]{index, value, dataType});
        }
        this.preparedStatementWriter.setDynamic(preparedStatement, index, dataType, value);
    }

    @NonNull
    protected <E> SqlStoredQuery<E, E> resolveEntityInsert(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<E> rootEntity, @NonNull RuntimePersistentEntity<E> persistentEntity) {
        return this.entityInserts.computeIfAbsent(new QueryKey(repositoryType, rootEntity), queryKey -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            QueryResult queryResult = queryBuilder.buildInsert(annotationMetadata, (PersistentEntity)persistentEntity);
            return new DefaultSqlStoredQuery(QueryResultStoredQuery.single(DataMethod.OperationType.INSERT, "Custom insert", AnnotationMetadata.EMPTY_METADATA, queryResult, rootEntity), persistentEntity, queryBuilder);
        });
    }

    protected <T> String resolveAssociationInsert(Class repositoryType, RuntimePersistentEntity<T> persistentEntity, RuntimeAssociation<T> association) {
        return this.associationInserts.computeIfAbsent((Association)association, association1 -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            return queryBuilder.buildJoinTableInsert((PersistentEntity)persistentEntity, association1);
        });
    }

    @NonNull
    protected <E> SqlStoredQuery<E, E> resolveEntityUpdate(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<E> rootEntity, @NonNull RuntimePersistentEntity<E> persistentEntity) {
        QueryKey key = new QueryKey(repositoryType, rootEntity);
        return this.entityUpdates.computeIfAbsent(key, queryKey -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            RuntimePersistentProperty identity = persistentEntity.getIdentity();
            String idName = identity != null ? identity.getName() : "id";
            QueryModel queryModel = QueryModel.from((PersistentEntity)persistentEntity).idEq((Object)new QueryParameter(idName));
            List updateProperties = persistentEntity.getPersistentProperties().stream().filter(p -> (!(p instanceof Association) || !((Association)p).isForeignKey()) && p.getAnnotationMetadata().booleanValue(AutoPopulated.class, "updateable").orElse(true) != false).map(PersistentProperty::getName).collect(Collectors.toList());
            QueryResult queryResult = queryBuilder.buildUpdate(annotationMetadata, queryModel, updateProperties);
            return new DefaultSqlStoredQuery(QueryResultStoredQuery.single(DataMethod.OperationType.UPDATE, "Custom update", AnnotationMetadata.EMPTY_METADATA, queryResult, rootEntity), persistentEntity, queryBuilder);
        });
    }

    protected <T> SqlStoredQuery<T, ?> resolveSqlInsertAssociation(Class<?> repositoryType, RuntimeAssociation<T> association, RuntimePersistentEntity<T> persistentEntity, T entity) {
        String sqlInsert = this.resolveAssociationInsert(repositoryType, persistentEntity, association);
        SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
        ArrayList<QueryParameterBinding> parameters = new ArrayList<QueryParameterBinding>();
        for (final Map.Entry property : this.idPropertiesWithValues((PersistentProperty)persistentEntity.getIdentity(), entity).collect(Collectors.toList())) {
            parameters.add(new QueryParameterBinding(){

                public String getName() {
                    return ((PersistentProperty)property.getKey()).getName();
                }

                public DataType getDataType() {
                    return ((PersistentProperty)property.getKey()).getDataType();
                }

                public Object getValue() {
                    return property.getValue();
                }
            });
        }
        for (final PersistentPropertyPath pp : this.idProperties((PersistentProperty)association.getAssociatedEntity().getIdentity()).collect(Collectors.toList())) {
            parameters.add(new QueryParameterBinding(){

                public String getName() {
                    return pp.getProperty().getName();
                }

                public DataType getDataType() {
                    return pp.getProperty().getDataType();
                }

                public String[] getPropertyPath() {
                    return pp.getArrayPath();
                }
            });
        }
        RuntimePersistentEntity associatedEntity = association.getAssociatedEntity();
        return new DefaultSqlStoredQuery(new BasicStoredQuery(sqlInsert, new String[0], parameters, persistentEntity.getIntrospection().getBeanType(), Object.class), associatedEntity, queryBuilder);
    }

    private Stream<PersistentPropertyPath> idProperties(PersistentProperty property) {
        ArrayList paths = new ArrayList();
        PersistentEntityUtils.traversePersistentProperties((PersistentProperty)property, (associations, persistentProperty) -> paths.add(new PersistentPropertyPath(associations, property)));
        return paths.stream();
    }

    private Stream<Map.Entry<PersistentProperty, Object>> idPropertiesWithValues(PersistentProperty property, Object value) {
        ArrayList values = new ArrayList();
        PersistentEntityUtils.traversePersistentProperties((PersistentProperty)property, (associations, persistentProperty) -> values.add(new AbstractMap.SimpleEntry<PersistentProperty, Object>((PersistentProperty)persistentProperty, new PersistentPropertyPath(associations, property).getPropertyValue(value))));
        return values.stream();
    }

    protected final <E, R> SqlPreparedQuery<E, R> getSqlPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        if (preparedQuery instanceof SqlPreparedQuery) {
            return (SqlPreparedQuery)preparedQuery;
        }
        throw new IllegalStateException("Expected for prepared query to be of type: SqlPreparedQuery got: " + preparedQuery.getClass().getName());
    }

    protected final <E, R> SqlStoredQuery<E, R> getSqlStoredQuery(StoredQuery<E, R> storedQuery) {
        if (storedQuery instanceof SqlStoredQuery) {
            SqlStoredQuery sqlStoredQuery = (SqlStoredQuery)storedQuery;
            if (sqlStoredQuery.isExpandableQuery() && !(sqlStoredQuery instanceof SqlPreparedQuery)) {
                return new DefaultSqlPreparedQuery(sqlStoredQuery);
            }
            return sqlStoredQuery;
        }
        throw new IllegalStateException("Expected for prepared query to be of type: SqlStoredQuery got: " + storedQuery.getClass().getName());
    }

    protected boolean isSupportsBatchInsert(PersistentEntity persistentEntity, Dialect dialect) {
        switch (dialect) {
            case SQL_SERVER: {
                return false;
            }
            case MYSQL: 
            case ORACLE: {
                if (persistentEntity.getIdentity() != null) {
                    return !persistentEntity.getIdentity().isGenerated();
                }
                return false;
            }
        }
        return true;
    }

    protected boolean isSupportsBatchUpdate(PersistentEntity persistentEntity, Dialect dialect) {
        return true;
    }

    protected boolean isSupportsBatchDelete(PersistentEntity persistentEntity, Dialect dialect) {
        return true;
    }

    @FunctionalInterface
    protected static interface StatementSupplier<PS> {
        public PS create(String var1) throws Exception;
    }

    private class QueryKey {
        final Class repositoryType;
        final Class entityType;

        QueryKey(Class repositoryType, Class entityType) {
            this.repositoryType = repositoryType;
            this.entityType = entityType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryKey queryKey = (QueryKey)o;
            return this.repositoryType.equals(queryKey.repositoryType) && this.entityType.equals(queryKey.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.repositoryType, this.entityType);
        }
    }
}

