/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.query.internal;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.StoredQuery;
import java.util.List;

@Internal
public class BasicStoredQuery<E, R>
implements StoredQuery<E, R> {
    private final String name;
    private final AnnotationMetadata annotationMetadata;
    private final String query;
    private final String[] expandableQueryParts;
    private final List<QueryParameterBinding> queryParameterBindings;
    private final Class<E> rootEntity;
    private final Class<R> resultType;
    private final boolean pageable;
    private final boolean isSingleResult;
    private final boolean isCount;
    private final DataType resultDataType;

    public BasicStoredQuery(String query, String[] expandableQueryParts, List<QueryParameterBinding> queryParameterBindings, Class<E> rootEntity, Class<R> resultType) {
        this("Custom query", AnnotationMetadata.EMPTY_METADATA, query, expandableQueryParts, queryParameterBindings, rootEntity, resultType, false, false, false);
    }

    public BasicStoredQuery(String name, AnnotationMetadata annotationMetadata, String query, String[] expandableQueryParts, List<QueryParameterBinding> queryParameterBindings, Class<E> rootEntity, Class<R> resultType, boolean pageable, boolean isSingleResult, boolean isCount) {
        this.name = name;
        this.annotationMetadata = annotationMetadata;
        this.query = query;
        this.expandableQueryParts = expandableQueryParts == null ? new String[]{} : expandableQueryParts;
        this.queryParameterBindings = queryParameterBindings;
        this.rootEntity = rootEntity;
        this.resultType = resultType;
        this.pageable = pageable;
        this.isSingleResult = isSingleResult;
        this.isCount = isCount;
        this.resultDataType = isCount ? DataType.forType(resultType) : DataType.ENTITY;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public String getName() {
        return this.name;
    }

    public Class<E> getRootEntity() {
        return this.rootEntity;
    }

    public Class<R> getResultType() {
        return this.resultType;
    }

    public Argument<R> getResultArgument() {
        return Argument.of(this.getResultType());
    }

    public DataType getResultDataType() {
        return this.resultDataType;
    }

    public boolean hasPageable() {
        return this.pageable;
    }

    public String getQuery() {
        return this.query;
    }

    public String[] getExpandableQueryParts() {
        return this.expandableQueryParts;
    }

    public List<QueryParameterBinding> getQueryBindings() {
        return this.queryParameterBindings;
    }

    public boolean useNumericPlaceholders() {
        return this.annotationMetadata.classValue(RepositoryConfiguration.class, "queryBuilder").map(c -> c == SqlQueryBuilder.class).orElse(false);
    }

    public boolean isCount() {
        return this.isCount;
    }

    public boolean isSingleResult() {
        return this.isSingleResult;
    }

    public boolean hasResultConsumer() {
        return false;
    }
}

