/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.runtime.operations.internal.StoredSqlOperation;
import java.util.stream.Collectors;

@Internal
public class QueryResultSqlOperation
extends StoredSqlOperation {
    public QueryResultSqlOperation(SqlQueryBuilder queryBuilder, QueryResult queryResult) {
        super(queryBuilder, queryResult.getQuery(), queryResult.getParameterBindings().stream().anyMatch(io.micronaut.data.model.query.builder.QueryParameterBinding::isExpandable) ? queryResult.getQueryParts().toArray(new String[0]) : null, queryResult.getParameterBindings().stream().map(QueryResultSqlOperation::map).collect(Collectors.toList()), false);
    }

    private static QueryParameterBinding map(final io.micronaut.data.model.query.builder.QueryParameterBinding binding) {
        return new QueryParameterBinding(){

            public String getName() {
                return binding.getKey();
            }

            public DataType getDataType() {
                return binding.getDataType();
            }

            public Class<?> getParameterConverterClass() {
                return (Class)ClassUtils.forName((String)binding.getConverterClassName(), null).orElseThrow(IllegalStateException::new);
            }

            public int getParameterIndex() {
                return binding.getParameterIndex();
            }

            public String[] getParameterBindingPath() {
                return binding.getParameterBindingPath();
            }

            public String[] getPropertyPath() {
                return binding.getPropertyPath();
            }

            public boolean isAutoPopulated() {
                return binding.isAutoPopulated();
            }

            public boolean isRequiresPreviousPopulatedValue() {
                return binding.isRequiresPreviousPopulatedValue();
            }

            public QueryParameterBinding getPreviousPopulatedValueParameter() {
                return null;
            }
        };
    }
}

