/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.operations.internal.AbstractCascadeOperations;
import io.micronaut.data.runtime.operations.internal.OperationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ReactiveCascadeOperations<Ctx extends OperationContext>
extends AbstractCascadeOperations {
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveCascadeOperations.class);
    private final ReactiveCascadeOperationsHelper<Ctx> helper;

    public ReactiveCascadeOperations(ConversionService<?> conversionService, ReactiveCascadeOperationsHelper<Ctx> helper) {
        super(conversionService);
        this.helper = helper;
    }

    public <T> Mono<T> cascadeEntity(Ctx ctx, T entity, RuntimePersistentEntity<T> persistentEntity, boolean isPost, Relation.Cascade cascadeType) {
        ArrayList<AbstractCascadeOperations.CascadeOp> cascadeOps = new ArrayList<AbstractCascadeOperations.CascadeOp>();
        this.cascade(((OperationContext)ctx).annotationMetadata, ((OperationContext)ctx).repositoryType, isPost, cascadeType, AbstractCascadeOperations.CascadeContext.of(((OperationContext)ctx).associations, entity, persistentEntity), persistentEntity, entity, cascadeOps);
        Mono monoEntity = Mono.just(entity);
        for (AbstractCascadeOperations.CascadeOp cascadeOp : cascadeOps) {
            Mono children;
            Flux childrenFlux;
            if (cascadeOp instanceof AbstractCascadeOperations.CascadeOneOp) {
                Mono<Object> childMono;
                boolean bl;
                AbstractCascadeOperations.CascadeOneOp cascadeOneOp = (AbstractCascadeOperations.CascadeOneOp)cascadeOp;
                Object child = cascadeOneOp.child;
                RuntimePersistentEntity childPersistentEntity = cascadeOneOp.childPersistentEntity;
                RuntimeAssociation association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
                if (((OperationContext)ctx).persisted.contains(child)) continue;
                RuntimePersistentProperty identity = childPersistentEntity.getIdentity();
                boolean bl2 = bl = identity.getProperty().get(child) != null;
                if ((!bl || identity instanceof Association) && cascadeType == Relation.Cascade.PERSIST) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), cascadeOp.ctx.associations);
                    }
                    Mono<Object> persisted = this.helper.persistOne(ctx, child, childPersistentEntity);
                    monoEntity = monoEntity.flatMap(e -> persisted.map(persistedEntity -> this.afterCascadedOne(e, cascadeOp.ctx.associations, child, persistedEntity)));
                    childMono = persisted;
                } else if (bl && cascadeType == Relation.Cascade.UPDATE) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading MERGE for '{}' ({}) association: '{}'", new Object[]{persistentEntity.getName(), persistentEntity.getIdentity().getProperty().get(entity), cascadeOp.ctx.associations});
                    }
                    Mono<Object> updated = this.helper.updateOne(ctx, child, childPersistentEntity);
                    monoEntity = monoEntity.flatMap(e -> updated.map(updatedEntity -> this.afterCascadedOne(e, cascadeOp.ctx.associations, child, updatedEntity)));
                    childMono = updated;
                } else {
                    childMono = Mono.just((Object)child);
                }
                if (!bl && (cascadeType == Relation.Cascade.PERSIST || cascadeType == Relation.Cascade.UPDATE) && SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association)) {
                    monoEntity = monoEntity.flatMap(e -> childMono.flatMap(c -> {
                        if (ctx.persisted.contains(c)) {
                            return Mono.just((Object)e);
                        }
                        ctx.persisted.add(c);
                        Mono<Void> op = this.helper.persistManyAssociation((OperationContext)ctx, association, e, (RuntimePersistentEntity<Object>)persistentEntity, c, (RuntimePersistentEntity<Object>)childPersistentEntity);
                        return op.thenReturn(e);
                    }));
                    continue;
                }
                monoEntity = monoEntity.flatMap(arg_0 -> ReactiveCascadeOperations.lambda$cascadeEntity$7((Mono)childMono, ctx, arg_0));
                continue;
            }
            if (!(cascadeOp instanceof AbstractCascadeOperations.CascadeManyOp)) continue;
            AbstractCascadeOperations.CascadeManyOp cascadeManyOp = (AbstractCascadeOperations.CascadeManyOp)cascadeOp;
            RuntimePersistentEntity childPersistentEntity = cascadeManyOp.childPersistentEntity;
            if (cascadeType == Relation.Cascade.UPDATE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cascading UPDATE for '{}' association: '{}'", (Object)persistentEntity.getName(), cascadeOp.ctx.associations);
                }
                childrenFlux = Flux.empty();
                for (Object e2 : cascadeManyOp.children) {
                    if (((OperationContext)ctx).persisted.contains(e2)) continue;
                    Mono modifiedEntity = childPersistentEntity.getIdentity().getProperty().get(e2) == null ? this.helper.persistOne(ctx, e2, childPersistentEntity) : this.helper.updateOne(ctx, e2, childPersistentEntity);
                    childrenFlux = childrenFlux.concatWith(modifiedEntity);
                }
                children = childrenFlux.collectList();
            } else {
                if (cascadeType != Relation.Cascade.PERSIST) continue;
                if (this.helper.isSupportsBatchInsert(ctx, persistentEntity)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), cascadeOp.ctx.associations);
                    }
                    RuntimePersistentProperty identity = childPersistentEntity.getIdentity();
                    Predicate<Object> veto = val -> ctx.persisted.contains(val) || identity.getProperty().get(val) != null && !(identity instanceof Association);
                    Flux<Object> flux = this.helper.persistBatch(ctx, cascadeManyOp.children, childPersistentEntity, veto);
                    children = flux.collectList();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cascading PERSIST for '{}' association: '{}'", (Object)persistentEntity.getName(), cascadeOp.ctx.associations);
                    }
                    childrenFlux = Flux.empty();
                    for (Object object : cascadeManyOp.children) {
                        if (((OperationContext)ctx).persisted.contains(object) || childPersistentEntity.getIdentity().getProperty().get(object) != null) {
                            childrenFlux = childrenFlux.concatWith((Publisher)Mono.just((Object)object));
                            continue;
                        }
                        Mono<Object> persisted = this.helper.persistOne(ctx, object, childPersistentEntity);
                        childrenFlux = childrenFlux.concatWith(persisted);
                    }
                    children = childrenFlux.collectList();
                }
            }
            monoEntity = monoEntity.flatMap(e -> children.flatMap(newChildren -> {
                Object entityAfterCascade = this.afterCascadedMany(e, cascadeOp.ctx.associations, cascadeManyOp.children, (List<Object>)newChildren);
                RuntimeAssociation association = (RuntimeAssociation)cascadeOp.ctx.getAssociation();
                if (SqlQueryBuilder.isForeignKeyWithJoinTable((Association)association)) {
                    if (this.helper.isSupportsBatchInsert((OperationContext)ctx, cascadeOp.ctx.parentPersistentEntity)) {
                        Predicate<Object> veto = ctx.persisted::contains;
                        Mono<Void> op = this.helper.persistManyAssociationBatch((OperationContext)ctx, association, cascadeOp.ctx.parent, cascadeOp.ctx.parentPersistentEntity, (Iterable<Object>)newChildren, (RuntimePersistentEntity<Object>)childPersistentEntity, veto);
                        return op.thenReturn(entityAfterCascade);
                    }
                    Mono res = Mono.just((Object)entityAfterCascade);
                    for (Object child : newChildren) {
                        if (ctx.persisted.contains(child)) continue;
                        Mono<Void> op = this.helper.persistManyAssociation((OperationContext)ctx, association, cascadeOp.ctx.parent, cascadeOp.ctx.parentPersistentEntity, child, (RuntimePersistentEntity<Object>)childPersistentEntity);
                        res = res.flatMap(arg_0 -> op.thenReturn(arg_0));
                    }
                    return res;
                }
                ctx.persisted.addAll((Collection<Object>)newChildren);
                return Mono.just((Object)entityAfterCascade);
            }));
        }
        return monoEntity;
    }

    private static /* synthetic */ Mono lambda$cascadeEntity$7(Mono childMono, OperationContext ctx, Object e) {
        return childMono.map(c -> {
            ctx.persisted.add(c);
            return e;
        });
    }

    public static interface ReactiveCascadeOperationsHelper<Ctx extends OperationContext> {
        default public boolean isSupportsBatchInsert(Ctx ctx, RuntimePersistentEntity<?> persistentEntity) {
            return true;
        }

        default public boolean isSupportsBatchUpdate(Ctx ctx, RuntimePersistentEntity<?> persistentEntity) {
            return true;
        }

        default public boolean isSupportsBatchDelete(Ctx ctx, RuntimePersistentEntity<?> persistentEntity) {
            return true;
        }

        public <T> Mono<T> persistOne(Ctx var1, T var2, RuntimePersistentEntity<T> var3);

        public <T> Flux<T> persistBatch(Ctx var1, Iterable<T> var2, RuntimePersistentEntity<T> var3, Predicate<T> var4);

        public <T> Mono<T> updateOne(Ctx var1, T var2, RuntimePersistentEntity<T> var3);

        public Mono<Void> persistManyAssociation(Ctx var1, RuntimeAssociation var2, Object var3, RuntimePersistentEntity<Object> var4, Object var5, RuntimePersistentEntity<Object> var6);

        public Mono<Void> persistManyAssociationBatch(Ctx var1, RuntimeAssociation var2, Object var3, RuntimePersistentEntity<Object> var4, Iterable<Object> var5, RuntimePersistentEntity<Object> var6, Predicate<Object> var7);
    }
}

