/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.type.Argument;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.operations.internal.OpContext;
import io.micronaut.data.runtime.operations.internal.StoredSqlOperation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Internal
public final class PreparedQueryDBOperation
extends StoredSqlOperation {
    private final Object[] queryParameters;
    private final int[] parameterBinding;
    private final DataType[] parameterTypes;
    private final String[] indexedParameterPaths;
    private final String[] indexedParameterAutoPopulatedPropertyPaths;
    private final String[] indexedParameterAutoPopulatedPreviousPropertyPaths;
    private final int[] indexedParameterAutoPopulatedPreviousPropertyIndexes;
    private final Class[] parameterConvertors;
    private final Argument[] parameterArguments;
    private boolean queryExpanded;

    protected PreparedQueryDBOperation(@NonNull PreparedQuery<?, ?> preparedQuery, Dialect dialect) {
        super(dialect, preparedQuery.getQuery(), new String[0], null, false);
        this.queryParameters = preparedQuery.getParameterArray();
        this.parameterBinding = preparedQuery.getIndexedParameterBinding();
        this.parameterTypes = preparedQuery.getIndexedParameterTypes();
        this.indexedParameterPaths = preparedQuery.getIndexedParameterPaths();
        this.indexedParameterAutoPopulatedPropertyPaths = preparedQuery.getIndexedParameterAutoPopulatedPropertyPaths();
        this.indexedParameterAutoPopulatedPreviousPropertyPaths = preparedQuery.getIndexedParameterAutoPopulatedPreviousPropertyPaths();
        this.indexedParameterAutoPopulatedPreviousPropertyIndexes = preparedQuery.getIndexedParameterAutoPopulatedPreviousPropertyIndexes();
        this.parameterConvertors = preparedQuery.getAnnotationMetadata().classValues(DataMethod.class, "parameterConverters");
        this.parameterArguments = preparedQuery.getArguments();
    }

    public <K> void checkForParameterToBeExpanded(RuntimePersistentEntity<K> persistentEntity, K entity, SqlQueryBuilder queryBuilder) {
        Iterator<Object> valuesIterator = new Iterator<Object>(){
            int i;

            @Override
            public boolean hasNext() {
                if (this.i >= PreparedQueryDBOperation.this.parameterBinding.length) {
                    return false;
                }
                int parameterIndex = PreparedQueryDBOperation.this.parameterBinding[this.i];
                DataType dataType = PreparedQueryDBOperation.this.parameterTypes[this.i];
                if (parameterIndex == -1 || dataType.isArray() && dataType != DataType.BYTE_ARRAY) {
                    ++this.i;
                    return this.hasNext();
                }
                return true;
            }

            @Override
            public Object next() {
                Object queryParameter = PreparedQueryDBOperation.this.queryParameters[PreparedQueryDBOperation.this.parameterBinding[this.i]];
                ++this.i;
                return queryParameter;
            }
        };
        String expandedQuery = this.expandMultipleValues(this.parameterBinding.length, valuesIterator, this.query, queryBuilder);
        this.queryExpanded = !this.query.equals(expandedQuery);
        this.query = expandedQuery;
    }

    public <K> void attachPageable(Pageable pageable, boolean isSingleResult, RuntimePersistentEntity<K> persistentEntity, SqlQueryBuilder queryBuilder) {
        if (pageable != Pageable.UNPAGED) {
            Sort sort = pageable.getSort();
            if (sort.isSorted()) {
                this.query = this.query + queryBuilder.buildOrderBy(persistentEntity, sort).getQuery();
            } else if (this.isSqlServerWithoutOrderBy(this.query, this.dialect)) {
                sort = this.sortById(persistentEntity);
                this.query = this.query + queryBuilder.buildOrderBy(persistentEntity, sort).getQuery();
            }
            if (isSingleResult && pageable.getOffset() > 0L) {
                pageable = Pageable.from((int)pageable.getNumber(), (int)1);
            }
            this.query = this.query + queryBuilder.buildPagination(pageable).getQuery();
        }
    }

    @NonNull
    private <K> Sort sortById(RuntimePersistentEntity<K> persistentEntity) {
        RuntimePersistentProperty identity = persistentEntity.getIdentity();
        if (identity == null) {
            throw new DataAccessException("Pagination requires an entity ID on SQL Server");
        }
        Sort sort = Sort.unsorted().order(Sort.Order.asc((String)identity.getName()));
        return sort;
    }

    private boolean isSqlServerWithoutOrderBy(String query, Dialect dialect) {
        return dialect == Dialect.SQL_SERVER && !query.contains(" ORDER BY ");
    }

    public <K, Cnt, PS> void setParameters(OpContext<Cnt, PS> context, Cnt connection, PS stmt, RuntimePersistentEntity<K> persistentEntity, K entity, Map<String, Object> previousValues) {
        int index = context.shiftIndex(0);
        for (int i = 0; i < this.parameterBinding.length; ++i) {
            Object value;
            int parameterIndex = this.parameterBinding[i];
            DataType dataType = this.parameterTypes[i];
            Class parameterConverter = null;
            if (this.parameterConvertors.length > i && (parameterConverter = this.parameterConvertors[i]) == Object.class) {
                parameterConverter = null;
            }
            if (parameterIndex > -1) {
                value = this.queryParameters[parameterIndex];
            } else {
                String propertyPath = this.indexedParameterPaths[i];
                String autoPopulatedPropertyPath = this.indexedParameterAutoPopulatedPropertyPaths[i];
                if (autoPopulatedPropertyPath != null) {
                    RuntimePersistentProperty persistentProperty = persistentEntity.getPropertyByName(autoPopulatedPropertyPath);
                    if (persistentProperty == null) {
                        throw new IllegalStateException("Cannot find auto populated property: " + autoPopulatedPropertyPath);
                    }
                    Object previousValue = null;
                    int autoPopulatedPreviousPropertyIndex = this.indexedParameterAutoPopulatedPreviousPropertyIndexes[i];
                    if (autoPopulatedPreviousPropertyIndex > -1) {
                        previousValue = this.queryParameters[autoPopulatedPreviousPropertyIndex];
                    } else {
                        String previousValuePath = this.indexedParameterAutoPopulatedPreviousPropertyPaths[i];
                        if (previousValuePath != null) {
                            previousValue = this.resolveQueryParameterByPath(this.query, i, this.queryParameters, previousValuePath);
                        }
                    }
                    value = context.getRuntimeEntityRegistry().autoPopulateRuntimeProperty(persistentProperty, previousValue);
                    value = context.convert(connection, value, persistentProperty);
                    parameterConverter = null;
                } else if (propertyPath != null) {
                    value = this.resolveQueryParameterByPath(this.query, i, this.queryParameters, propertyPath);
                } else {
                    throw new IllegalStateException("Invalid query [" + this.query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
                }
            }
            List<Object> values = this.expandValue(value, dataType);
            if (values != null && values.isEmpty()) {
                value = null;
                values = null;
            }
            if (values == null) {
                if (parameterConverter != null) {
                    Argument argument = parameterIndex > -1 ? this.parameterArguments[parameterIndex] : null;
                    value = context.convert(parameterConverter, connection, value, argument);
                }
                context.setStatementParameter(stmt, index++, dataType, value, this.dialect);
                continue;
            }
            for (Object v : values) {
                if (parameterConverter != null) {
                    Argument argument = parameterIndex > -1 ? this.parameterArguments[parameterIndex] : null;
                    v = context.convert(parameterConverter, connection, v, argument);
                }
                context.setStatementParameter(stmt, index++, dataType, v, this.dialect);
            }
        }
    }

    private Object resolveQueryParameterByPath(String query, int i, Object[] queryParameters, String propertyPath) {
        int j = propertyPath.indexOf(46);
        if (j > -1) {
            String[] properties = propertyPath.split("\\.");
            Object value = queryParameters[Integer.parseInt(properties[0])];
            for (int k = 1; k < properties.length && value != null; ++k) {
                String property = properties[k];
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(property, Argument.OBJECT_ARGUMENT);
            }
            return value;
        }
        throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
    }
}

