/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.operations.internal;

import io.micronaut.context.ApplicationContextProvider;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.AttributeConverterRegistry;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.data.runtime.operations.internal.AbstractRepositoryOperations;
import io.micronaut.data.runtime.operations.internal.DBOperation;
import io.micronaut.data.runtime.operations.internal.OpContext;
import io.micronaut.data.runtime.operations.internal.PreparedQueryDBOperation;
import io.micronaut.data.runtime.operations.internal.StoredSqlOperation;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Internal
public abstract class AbstractSqlRepositoryOperations<Cnt, RS, PS, Exc extends Exception>
extends AbstractRepositoryOperations<Cnt, PS, Exc>
implements ApplicationContextProvider,
OpContext<Cnt, PS> {
    protected static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    protected static final SqlQueryBuilder DEFAULT_SQL_BUILDER = new SqlQueryBuilder();
    protected final ResultReader<RS, String> columnNameResultSetReader;
    protected final ResultReader<RS, Integer> columnIndexResultSetReader;
    protected final QueryStatement<PS, Integer> preparedStatementWriter;
    protected final Map<Class, SqlQueryBuilder> queryBuilders = new HashMap<Class, SqlQueryBuilder>(10);
    private final Map<QueryKey, DBOperation> entityInserts = new ConcurrentHashMap<QueryKey, DBOperation>(10);
    private final Map<QueryKey, DBOperation> entityUpdates = new ConcurrentHashMap<QueryKey, DBOperation>(10);
    private final Map<Association, String> associationInserts = new ConcurrentHashMap<Association, String>(10);

    protected AbstractSqlRepositoryOperations(String dataSourceName, ResultReader<RS, String> columnNameResultSetReader, ResultReader<RS, Integer> columnIndexResultSetReader, QueryStatement<PS, Integer> preparedStatementWriter, List<MediaTypeCodec> codecs, DateTimeProvider<Object> dateTimeProvider, RuntimeEntityRegistry runtimeEntityRegistry, BeanContext beanContext, DataConversionService<?> conversionService, AttributeConverterRegistry attributeConverterRegistry) {
        super(codecs, dateTimeProvider, runtimeEntityRegistry, conversionService, attributeConverterRegistry);
        this.columnNameResultSetReader = columnNameResultSetReader;
        this.columnIndexResultSetReader = columnIndexResultSetReader;
        this.preparedStatementWriter = preparedStatementWriter;
        Collection beanDefinitions = beanContext.getBeanDefinitions(GenericRepository.class, Qualifiers.byStereotype(Repository.class));
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String targetDs = beanDefinition.stringValue(Repository.class).orElse("default");
            if (!targetDs.equalsIgnoreCase(dataSourceName)) continue;
            Class beanType = beanDefinition.getBeanType();
            SqlQueryBuilder queryBuilder = new SqlQueryBuilder(beanDefinition.getAnnotationMetadata());
            this.queryBuilders.put(beanType, queryBuilder);
        }
    }

    protected <T, R> PS prepareStatement(Cnt connection, AbstractRepositoryOperations.StatementSupplier<PS> statementFunction, @NonNull PreparedQuery<T, R> preparedQuery, boolean isUpdate, boolean isSingleResult) throws Exc {
        PS ps;
        SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(preparedQuery.getRepositoryType(), DEFAULT_SQL_BUILDER);
        Dialect dialect = queryBuilder.getDialect();
        RuntimePersistentEntity persistentEntity = this.getEntity(preparedQuery.getRootEntity());
        PreparedQueryDBOperation pqSqlOperation = new PreparedQueryDBOperation(preparedQuery, dialect);
        pqSqlOperation.checkForParameterToBeExpanded(persistentEntity, null, queryBuilder);
        if (!isUpdate) {
            pqSqlOperation.attachPageable(preparedQuery.getPageable(), isSingleResult, persistentEntity, queryBuilder);
        }
        String query = pqSqlOperation.getQuery();
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)query);
        }
        try {
            ps = statementFunction.create(query);
        }
        catch (Exception e) {
            throw new DataAccessException("Unable to prepare query [" + query + "]: " + e.getMessage(), (Throwable)e);
        }
        pqSqlOperation.setParameters(this, connection, ps, persistentEntity, null, (Map<String, Object>)null);
        return ps;
    }

    @Override
    public void setStatementParameter(PS preparedStatement, int index, DataType dataType, Object value, Dialect dialect) {
        switch (dataType) {
            case UUID: {
                if (value == null || !dialect.requiresStringUUID(dataType)) break;
                value = value.toString();
                break;
            }
            case JSON: {
                if (value == null || this.jsonCodec == null || value.getClass().equals(String.class)) break;
                value = new String(this.jsonCodec.encode(value), StandardCharsets.UTF_8);
                break;
            }
            case ENTITY: {
                if (value == null) break;
                RuntimePersistentProperty<Object> idReader = this.getIdReader(value);
                Object id = idReader.getProperty().get(value);
                if (id == null) {
                    throw new DataAccessException("Supplied entity is a transient instance: " + value);
                }
                this.setStatementParameter(preparedStatement, index, idReader.getDataType(), id, dialect);
                return;
            }
        }
        dataType = dialect.getDataType(dataType);
        if (QUERY_LOG.isTraceEnabled()) {
            QUERY_LOG.trace("Binding parameter at position {} to value {} with data type: {}", new Object[]{index, value, dataType});
        }
        this.preparedStatementWriter.setDynamic(preparedStatement, index, dataType, value);
    }

    @NonNull
    protected DBOperation resolveEntityInsert(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<?> rootEntity, @NonNull RuntimePersistentEntity<?> persistentEntity) {
        return this.entityInserts.computeIfAbsent(new QueryKey(repositoryType, rootEntity), queryKey -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            QueryResult queryResult = queryBuilder.buildInsert(annotationMetadata, (PersistentEntity)persistentEntity);
            return new StoredSqlOperation(queryBuilder.getDialect(), queryResult.getQuery(), (String[])queryResult.getParameterBindings().stream().map(QueryParameterBinding::getPath).toArray(String[]::new), new String[0], false);
        });
    }

    @Override
    protected <T> String resolveAssociationInsert(Class repositoryType, RuntimePersistentEntity<T> persistentEntity, RuntimeAssociation<T> association) {
        return this.associationInserts.computeIfAbsent((Association)association, association1 -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            return queryBuilder.buildJoinTableInsert((PersistentEntity)persistentEntity, association1);
        });
    }

    @NonNull
    protected DBOperation resolveEntityUpdate(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<?> rootEntity, @NonNull RuntimePersistentEntity<?> persistentEntity) {
        QueryKey key = new QueryKey(repositoryType, rootEntity);
        return this.entityUpdates.computeIfAbsent(key, queryKey -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            RuntimePersistentProperty identity = persistentEntity.getIdentity();
            String idName = identity != null ? identity.getName() : "id";
            QueryModel queryModel = QueryModel.from((PersistentEntity)persistentEntity).idEq(new QueryParameter(idName));
            List updateProperties = persistentEntity.getPersistentProperties().stream().filter(p -> (!(p instanceof Association) || !((Association)p).isForeignKey()) && p.getAnnotationMetadata().booleanValue(AutoPopulated.class, "updateable").orElse(true) != false).map(PersistentProperty::getName).collect(Collectors.toList());
            QueryResult queryResult = queryBuilder.buildUpdate(annotationMetadata, queryModel, updateProperties);
            return new StoredSqlOperation(queryBuilder.getDialect(), queryResult.getQuery(), (String[])queryResult.getParameterBindings().stream().map(QueryParameterBinding::getPath).toArray(String[]::new), new String[0], false);
        });
    }

    private class QueryKey {
        final Class repositoryType;
        final Class entityType;

        QueryKey(Class repositoryType, Class entityType) {
            this.repositoryType = repositoryType;
            this.entityType = entityType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryKey queryKey = (QueryKey)o;
            return this.repositoryType.equals(queryKey.repositoryType) && this.entityType.equals(queryKey.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.repositoryType, this.entityType);
        }
    }
}

