/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept.async;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.async.FindAllAsyncInterceptor;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.async.AbstractAsyncInterceptor;
import java.util.Collections;
import java.util.concurrent.CompletionStage;

public class DefaultFindAllAsyncInterceptor<T>
extends AbstractAsyncInterceptor<T, Iterable<Object>>
implements FindAllAsyncInterceptor<T> {
    protected DefaultFindAllAsyncInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public CompletionStage<Iterable<Object>> intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, CompletionStage<Iterable<Object>>> context) {
        CompletionStage future;
        if (context.hasAnnotation(Query.class)) {
            PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
            future = this.asyncDatastoreOperations.findAll(preparedQuery);
        } else {
            future = this.asyncDatastoreOperations.findAll(this.getPagedQuery(context));
        }
        return future.thenApply(iterable -> {
            Argument targetType = context.getReturnType().asArgument();
            Argument argument = targetType.getFirstTypeVariable().orElse(Argument.listOf(Object.class));
            Iterable result = ConversionService.SHARED.convert(iterable, argument).orElse(null);
            return result == null ? Collections.emptyList() : result;
        });
    }
}

