/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.event.listeners;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.data.annotation.event.PrePersist;
import io.micronaut.data.event.EntityEventContext;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.event.listeners.AutoPopulatedEntityEventListener;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.inject.Singleton;

@Singleton
public class UUIDGeneratingEntityEventListener
extends AutoPopulatedEntityEventListener {
    private static final Predicate<RuntimePersistentProperty<Object>> UUID_PREDICATE = p -> p.getType() == UUID.class;

    @Override
    @NonNull
    protected final List<Class<? extends Annotation>> getEventTypes() {
        return Collections.singletonList(PrePersist.class);
    }

    @Override
    @NonNull
    protected Predicate<RuntimePersistentProperty<Object>> getPropertyPredicate() {
        return UUID_PREDICATE;
    }

    public boolean prePersist(@NonNull EntityEventContext<Object> context) {
        RuntimePersistentProperty<Object>[] persistentProperties;
        Object entity = context.getEntity();
        for (RuntimePersistentProperty<Object> persistentProperty : persistentProperties = this.getApplicableProperties((RuntimePersistentEntity<Object>)context.getPersistentEntity())) {
            BeanProperty property = persistentProperty.getProperty();
            property.set(entity, (Object)UUID.randomUUID());
        }
        return true;
    }
}

