/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.mapper;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.runtime.mapper.BeanIntrospectionMapper;
import io.micronaut.data.runtime.mapper.ResultReader;

public class DTOMapper<T, S, R>
implements BeanIntrospectionMapper<S, R> {
    private final RuntimePersistentEntity<T> persistentEntity;
    private final ResultReader<S, String> resultReader;

    public DTOMapper(RuntimePersistentEntity<T> persistentEntity, ResultReader<S, String> resultReader) {
        ArgumentUtils.requireNonNull((String)"persistentEntity", persistentEntity);
        ArgumentUtils.requireNonNull((String)"resultReader", resultReader);
        this.persistentEntity = persistentEntity;
        this.resultReader = resultReader;
    }

    @Override
    @Nullable
    public Object read(@NonNull S object, @NonNull String name) throws ConversionErrorException {
        RuntimePersistentProperty pp = this.persistentEntity.getPropertyByName(name);
        if (pp == null) {
            throw new DataAccessException("DTO projection defines a property [" + name + "] that doesn't exist on root entity: " + this.persistentEntity.getName());
        }
        return this.read(object, pp);
    }

    @Nullable
    public Object read(@NonNull S resultSet, @NonNull RuntimePersistentProperty<T> property) {
        String propertyName = property.getPersistedName();
        DataType dataType = property.getDataType();
        return this.read(resultSet, propertyName, dataType);
    }

    @Nullable
    public Object read(@NonNull S resultSet, @NonNull String persistedName, @NonNull DataType dataType) {
        return this.resultReader.readDynamic(resultSet, persistedName, dataType);
    }

    public PersistentEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    public ResultReader<S, String> getResultReader() {
        return this.resultReader;
    }
}

