/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.spring;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.model.Sort;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.Sort;

@Internal
class SortDelegate
implements Sort {
    private org.springframework.data.domain.Sort sort;

    SortDelegate(org.springframework.data.domain.Sort sort) {
        this.sort = sort;
    }

    public boolean isSorted() {
        return this.sort.isSorted();
    }

    @NonNull
    public Sort order(@NonNull String propertyName) {
        this.sort = this.sort.and(new org.springframework.data.domain.Sort(Sort.Direction.ASC, new String[]{propertyName}));
        return this;
    }

    @NonNull
    public Sort order(@NonNull Sort.Order order) {
        Sort.Direction direction = order.isAscending() ? Sort.Direction.ASC : Sort.Direction.DESC;
        String property = order.getProperty();
        org.springframework.data.domain.Sort springSort = this.toSpringSort(direction, property);
        this.sort = this.sort.and(springSort);
        return this;
    }

    private org.springframework.data.domain.Sort toSpringSort(Sort.Direction direction, String property) {
        return new org.springframework.data.domain.Sort(direction, new String[]{property});
    }

    @NonNull
    public Sort order(@NonNull String propertyName, @NonNull Sort.Order.Direction direction) {
        Sort.Direction d = Sort.Direction.valueOf((String)direction.name());
        org.springframework.data.domain.Sort springSort = this.toSpringSort(d, propertyName);
        this.sort = this.sort.and(springSort);
        return this;
    }

    @NonNull
    public List<Sort.Order> getOrderBy() {
        return SortDelegate.iteratorToList(this.sort.iterator());
    }

    private static List<Sort.Order> iteratorToList(Iterator<Sort.Order> iterator) {
        ArrayList<Sort.Order> list = new ArrayList<Sort.Order>();
        while (iterator.hasNext()) {
            Sort.Order order = iterator.next();
            if (order.isAscending()) {
                list.add(Sort.Order.asc((String)order.getProperty()));
                continue;
            }
            list.add(Sort.Order.desc((String)order.getProperty()));
        }
        return list;
    }
}

