/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.runtime.intercept;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.intercept.DeleteOneInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.Collections;

public class DefaultDeleteOneInterceptor<T>
extends AbstractQueryInterceptor<T, Void>
implements DeleteOneInterceptor<T> {
    protected DefaultDeleteOneInterceptor(@NonNull RepositoryOperations datastore) {
        super(datastore);
    }

    public Void intercept(RepositoryMethodKey methodKey, MethodInvocationContext<T, Void> context) {
        BatchOperation<Object> batchOperation;
        Object[] parameterValues = context.getParameterValues();
        if (parameterValues.length == 1) {
            Object o = parameterValues[0];
            if (context.hasAnnotation(Query.class)) {
                PreparedQuery<?, ?> preparedQuery = this.prepareQuery(methodKey, context);
                this.operations.executeUpdate(preparedQuery).orElse(0);
                return null;
            }
            batchOperation = this.getBatchOperation(context, Collections.singletonList(o));
            if (o == null) {
                throw new IllegalArgumentException("Entity to delete cannot be null");
            }
        } else {
            throw new IllegalStateException("Expected exactly one argument");
        }
        this.operations.deleteAll(batchOperation);
        return null;
    }
}

