/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;

@Internal
final class R2dbcTuple
implements Tuple {
    private final ConversionService conversionService;
    private final @Nullable Object[] values;
    private final Map<String, Integer> aliasToPosition;

    public R2dbcTuple(ConversionService conversionService, @Nullable Object[] values, Map<String, Integer> aliasToPosition) {
        this.conversionService = conversionService;
        this.values = values;
        this.aliasToPosition = aliasToPosition;
    }

    public <X> X get(TupleElement<X> tupleElement) {
        throw new UnsupportedOperationException();
    }

    public <X> @Nullable X get(String alias, Class<X> type) {
        return (X)this.conversionService.convertRequired(this.get(alias), type);
    }

    public @Nullable Object get(String alias) {
        Integer index = this.aliasToPosition.get(alias);
        if (index == null) {
            throw new IllegalArgumentException("Unknown alias: " + alias);
        }
        return this.get(index);
    }

    public <X> @Nullable X get(int i, Class<X> type) {
        return (X)this.conversionService.convertRequired(this.get(i), type);
    }

    public @Nullable Object get(int i) {
        return this.values[i];
    }

    public @Nullable Object[] toArray() {
        return this.values;
    }

    public List<TupleElement<?>> getElements() {
        throw new UnsupportedOperationException();
    }
}

