/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.r2dbc.connection;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.support.AbstractReactorConnectionOperations;
import io.micronaut.data.r2dbc.config.DataR2dbcConfiguration;
import io.micronaut.data.r2dbc.operations.R2dbcSchemaHandler;
import io.micronaut.data.runtime.multitenancy.SchemaTenantResolver;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@EachBean(value=ConnectionFactory.class)
@Internal
public final class DefaultR2dbcReactorConnectionOperations
extends AbstractReactorConnectionOperations<Connection> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultR2dbcReactorConnectionOperations.class);
    private final String dataSourceName;
    private final ConnectionFactory connectionFactory;
    private final DataR2dbcConfiguration configuration;
    private final @Nullable SchemaTenantResolver schemaTenantResolver;
    private final R2dbcSchemaHandler schemaHandler;

    DefaultR2dbcReactorConnectionOperations(@Parameter String dataSourceName, @Parameter ConnectionFactory connectionFactory, @Parameter DataR2dbcConfiguration configuration, @Nullable SchemaTenantResolver schemaTenantResolver, R2dbcSchemaHandler schemaHandler) {
        this.dataSourceName = dataSourceName;
        this.connectionFactory = connectionFactory;
        this.configuration = configuration;
        this.schemaTenantResolver = schemaTenantResolver;
        this.schemaHandler = schemaHandler;
    }

    protected Publisher<Connection> openConnection(ConnectionDefinition definition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening Connection for R2DBC configuration: {} and definition: {}", (Object)this.dataSourceName, (Object)definition);
        }
        return this.connectionFactory.create();
    }

    protected Publisher<Void> closeConnection(Connection connection, ConnectionDefinition definition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing Connection for R2DBC configuration: {} and definition: {}", (Object)this.dataSourceName, (Object)definition);
        }
        return connection.close();
    }

    public <T> Publisher<T> withConnection(ConnectionDefinition definition, Function<ConnectionStatus<Connection>, Publisher<T>> handler) {
        String schemaName;
        Function<Object, Object> finalHandler = this.schemaTenantResolver != null ? ((schemaName = this.schemaTenantResolver.resolveTenantSchemaName()) != null ? status -> Mono.fromDirect(this.schemaHandler.useSchema((Connection)status.getConnection(), this.configuration.getDialect(), schemaName)).thenReturn(status).flatMapMany(handler) : handler) : handler;
        return super.withConnection(definition, finalHandler);
    }

    public <T> Flux<T> withConnectionFlux(ConnectionDefinition definition, Function<ConnectionStatus<Connection>, Flux<T>> handler) {
        String schemaName;
        Function<Object, Object> finalHandler = this.schemaTenantResolver != null ? ((schemaName = this.schemaTenantResolver.resolveTenantSchemaName()) != null ? status -> Mono.fromDirect(this.schemaHandler.useSchema((Connection)status.getConnection(), this.configuration.getDialect(), schemaName)).thenReturn(status).flatMapMany(handler) : handler) : handler;
        return super.withConnectionFlux(definition, finalHandler);
    }

    public <T> Mono<T> withConnectionMono(ConnectionDefinition definition, Function<ConnectionStatus<Connection>, Mono<T>> handler) {
        String schemaName;
        Function<Object, Object> finalHandler = this.schemaTenantResolver != null ? ((schemaName = this.schemaTenantResolver.resolveTenantSchemaName()) != null ? status -> Mono.fromDirect(this.schemaHandler.useSchema((Connection)status.getConnection(), this.configuration.getDialect(), schemaName)).thenReturn(status).flatMap(handler) : handler) : handler;
        return super.withConnectionMono(definition, finalHandler);
    }
}

